/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.constraint;

import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.gui.constraint.ConstraintComparisonRow;
import com.mimvista.dose.constraints.AppliedDoseContourConstraint;
import com.mimvista.dose.constraints.DoseConstraintSet;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.response.StatisticDerivationType;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class DoseConstraintComparisonModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    DoseConstraintSet constraintSet;
    IsodoseOverlay dose;
    IsodoseOverlay comparisonDose;
    List<StatisticDerivationType> derivations;
    List<ConstraintComparisonRow> rows;

    public DoseConstraintComparisonModel(DoseConstraintSet doseConstraintSet, IsodoseOverlay isodoseOverlay, IsodoseOverlay isodoseOverlay2, List<StatisticDerivationType> list) {
        this.constraintSet = doseConstraintSet;
        this.dose = isodoseOverlay;
        this.comparisonDose = isodoseOverlay2;
        this.derivations = Lists.newArrayList(list);
        this.rows = Lists.newArrayList();
        this.buildRows();
    }

    @Override
    public int getColumnCount() {
        return 3 + this.derivations.size();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        if (n2 < 0 || n2 >= this.rows.size()) {
            return null;
        }
        ConstraintComparisonRow constraintComparisonRow = this.rows.get(n2);
        switch (n3) {
            case 0: {
                return constraintComparisonRow.getCurrentContour() == null ? constraintComparisonRow.getComparisonContour() : constraintComparisonRow.getCurrentContour();
            }
            case 1: {
                return constraintComparisonRow.getConstraintName();
            }
            case 2: {
                return constraintComparisonRow.getCurrentValue();
            }
            case 3: {
                return constraintComparisonRow.getComparisonValue();
            }
        }
        int n4 = n3 - 4;
        if (n4 < 0 || n4 >= this.derivations.size()) {
            return null;
        }
        return constraintComparisonRow.getDerivedValue(this.derivations.get(n4));
    }

    private void buildRows() {
        if (this.constraintSet != null && this.constraintSet.constraints != null) {
            for (AppliedDoseContourConstraint appliedDoseContourConstraint : this.constraintSet.constraints) {
                this.rows.add(new ConstraintComparisonRow(this.dose, this.comparisonDose, appliedDoseContourConstraint));
            }
        }
    }
}

