/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.constraint;

import com.google.common.collect.Maps;
import com.mimvista.dicom.rtdose.gui.constraint.DoseValuePairRenderer;
import com.mimvista.dicom.rtdose.gui.constraint.FulfilledCellObject;
import com.mimvista.dicom.rtdose.gui.constraint.FulfilledCellRenderer;
import com.mimvista.dicom.rtdose.gui.constraint.OverlayNameAndColorCellRenderer;
import com.mimvista.mui.overlays.p;
import com.mimvista.report.gui.content.constraints.DoseValueRenderer;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class DoseConstraintTable
extends JXTable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_COL_WIDTH = 1000;
    private Map<Integer, Integer> rowHeights = Maps.newHashMap();

    public DoseConstraintTable() {
        this.setDefaultRenderer(FulfilledCellObject.class, new FulfilledCellRenderer());
        this.setDefaultRenderer(p.class, new OverlayNameAndColorCellRenderer());
        this.setDefaultRenderer(Pair.class, new DoseValuePairRenderer());
        DoseValueRenderer doseValueRenderer = new DoseValueRenderer();
        this.setDefaultRenderer(String.class, doseValueRenderer);
        this.setDefaultRenderer(Float.class, doseValueRenderer);
        this.setDefaultRenderer(Double.class, doseValueRenderer);
        this.setDefaultRenderer(DoseValueRenderer.a.class, doseValueRenderer);
        this.getTableHeader().setReorderingAllowed(false);
        this.setSortable(false);
        this.addHeaderTooltips();
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n2, int n3) {
        Component component = super.prepareRenderer(tableCellRenderer, n2, n3);
        int n4 = this.getColumnModel().getColumn(n3).getWidth();
        component.setSize(n4, Integer.MAX_VALUE);
        component.doLayout();
        int n5 = (int)component.getPreferredSize().getHeight();
        component.setSize(n4, n5);
        int n6 = Integer.MIN_VALUE;
        if (n3 == 0) {
            n6 = n5;
            this.rowHeights.put(n2, n5);
        } else {
            Integer n7 = this.rowHeights.get(n2);
            n6 = Math.max(n7, n5);
            this.rowHeights.put(n2, n6);
        }
        int n8 = this.getRowHeight(n2);
        if (n8 != n6 && n3 == this.getColumnCount() - 1) {
            this.setRowHeight(n2, n6);
        }
        return component;
    }

    public void packAll() {
        try {
            Component component;
            Object object;
            int n2;
            int[] nArray = new int[this.getColumnCount()];
            for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
                String string = this.getModel().getColumnName(n2);
                object = this.getColumnModel().getColumn(n2).getHeaderRenderer();
                if (object == null) {
                    object = this.getTableHeader().getDefaultRenderer();
                }
                component = object.getTableCellRendererComponent((JTable)((Object)this), string, false, false, -1, n2);
                component.setSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
                nArray[n2] = (int)component.getPreferredSize().getWidth();
            }
            for (n2 = 0; n2 < this.getRowCount(); ++n2) {
                for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                    object = this.getModel().getValueAt(n2, i2);
                    component = this.getCellRenderer(n2, i2).getTableCellRendererComponent((JTable)((Object)this), object, this.getSelectedRow() == n2, this.getSelectedRow() == n2, n2, i2);
                    int n3 = this.searchForMinWidth(component);
                    nArray[i2] = Math.max(n3, nArray[i2]);
                }
            }
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.getColumnModel().getColumn(n2).setPreferredWidth(nArray[n2] + 5);
            }
        }
        catch (Exception exception) {
            ay.d((Object)"Error packing table.  Falling back to default behavior", (Object)this);
            super.packAll();
        }
    }

    private int searchForMinWidth(Component component) {
        int n2 = this.getWidth();
        if (n2 == 0) {
            n2 = 1000;
        }
        component.setSize(n2, Integer.MAX_VALUE);
        component.doLayout();
        int n3 = component.getPreferredSize().height;
        int n4 = 20;
        while (n4 < n2) {
            int n5 = (n2 + n4) / 2;
            component.setSize(n5, Integer.MAX_VALUE);
            component.doLayout();
            int n6 = component.getPreferredSize().height;
            if (n6 > n3) {
                n4 = n5 + 1;
                continue;
            }
            n2 = n5;
        }
        return n2;
    }

    private void addHeaderTooltips() {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
        this.getTableHeader().addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n2 = DoseConstraintTable.this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                DoseConstraintTable.this.getTableHeader().setToolTipText(DoseConstraintTable.this.getModel().getColumnName(n2));
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }
        });
    }
}

