/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.constraint;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.gui.constraint.ConstraintRow;
import com.mimvista.dicom.rtdose.gui.constraint.FulfilledCellObject;
import com.mimvista.dose.constraints.AppliedDoseContourConstraint;
import com.mimvista.dose.constraints.DoseConstraint;
import com.mimvista.dose.constraints.DoseConstraintSet;
import com.mimvista.dose.constraints.DoseContext;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.statistics.OverlayStatistician;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.OverlayCollection;
import com.mimvista.mui.overlays.OverlayDirtParams;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.mui.overlays.y;
import com.mimvista.util.Messages;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.swing.table.AbstractTableModel;

class DoseConstraintTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private List<ConstraintRow> rows = Lists.newArrayList();
    private IsodoseOverlay dose;
    private DoseConstraintSet persona;
    private OverlayCollection.a collListener;
    private OverlayStatistician.e statListener;
    private y ovListener;
    private y doseListener;

    public DoseConstraintTableModel(IsodoseOverlay isodoseOverlay, DoseConstraintSet doseConstraintSet) {
        this.dose = isodoseOverlay;
        this.persona = doseConstraintSet;
        this.ovListener = this.buildContourListener();
        this.reprocessAll();
        this.statListener = this.buildOverlayStatsListener();
        isodoseOverlay.h().a(this.statListener);
        this.collListener = this.buildOverlayCollectionListener();
        isodoseOverlay.ao().n().a(this.collListener);
        this.doseListener = this.buildDoseListener();
        isodoseOverlay.a(this.doseListener);
    }

    private y buildDoseListener() {
        return new y(){

            @Override
            public void overlayDataChanged(Overlayish overlayish, OverlayDirtParams.OverlayChangeGranularity overlayChangeGranularity) {
                DoseContext doseContext;
                if (overlayish instanceof IsodoseOverlay && (doseContext = ((IsodoseOverlay)overlayish).g()) != null && DoseConstraintTableModel.this.persona != doseContext.what) {
                    DoseConstraintTableModel.this.rows.clear();
                    DoseConstraintTableModel.this.dose.h().a(DoseConstraintTableModel.this);
                    DoseConstraintTableModel.this.reprocessAll();
                    DoseConstraintTableModel.this.fireTableDataChanged();
                }
            }
        };
    }

    private OverlayCollection.a buildOverlayCollectionListener() {
        return new OverlayCollection.a(){

            @Override
            public void overlayAdded(Overlayish overlayish) {
                if (DoseConstraintTableModel.this.persona != null && overlayish.u() && ((AbstractContourOverlayish)overlayish).w()) {
                    boolean bl2 = false;
                    VolumetricContourOverlayish volumetricContourOverlayish = ((AbstractContourOverlayish)overlayish).G();
                    ImmutableList<AppliedDoseContourConstraint> immutableList = ((DoseConstraintTableModel)DoseConstraintTableModel.this).persona.constraints;
                    for (AppliedDoseContourConstraint appliedDoseContourConstraint : immutableList) {
                        if (!appliedDoseContourConstraint.matches(volumetricContourOverlayish)) continue;
                        bl2 = true;
                        DoseConstraintTableModel.this.rows.add(new ConstraintRow(volumetricContourOverlayish, appliedDoseContourConstraint));
                    }
                    if (bl2) {
                        DoseConstraintTableModel.this.dose.h().a(DoseConstraintTableModel.this, volumetricContourOverlayish, false);
                        Collections.sort(DoseConstraintTableModel.this.rows);
                        DoseConstraintTableModel.this.fireTableDataChanged();
                        DoseConstraintTableModel.this.dose.h().i();
                    }
                    volumetricContourOverlayish.a(DoseConstraintTableModel.this.ovListener);
                }
            }

            @Override
            public void overlayRemoved(Overlayish overlayish) {
                if (DoseConstraintTableModel.this.persona != null && overlayish.u() && ((AbstractContourOverlayish)overlayish).w()) {
                    VolumetricContourOverlayish volumetricContourOverlayish = ((AbstractContourOverlayish)overlayish).G();
                    ListIterator listIterator = DoseConstraintTableModel.this.rows.listIterator();
                    while (listIterator.hasNext()) {
                        ConstraintRow constraintRow = (ConstraintRow)listIterator.next();
                        if (constraintRow.vco != volumetricContourOverlayish) continue;
                        int n2 = listIterator.previousIndex();
                        listIterator.remove();
                        DoseConstraintTableModel.this.fireTableRowsDeleted(n2, n2);
                    }
                    DoseConstraintTableModel.this.dose.h().a((Object)DoseConstraintTableModel.this, volumetricContourOverlayish);
                    volumetricContourOverlayish.c(DoseConstraintTableModel.this.ovListener);
                }
            }
        };
    }

    private OverlayStatistician.e buildOverlayStatsListener() {
        return new OverlayStatistician.e(){

            @Override
            public void finishedComputingStatistics(Overlayish overlayish) {
                DoseConstraintTableModel.this.fireTableDataChanged();
            }

            @Override
            public void statsDirtied(Overlayish overlayish) {
                DoseConstraintTableModel.this.fireTableDataChanged();
            }
        };
    }

    private y buildContourListener() {
        return new y(){

            @Override
            public void overlayDataChanged(Overlayish overlayish, OverlayDirtParams.OverlayChangeGranularity overlayChangeGranularity) {
                if (overlayish.u() && ((AbstractContourOverlayish)overlayish).w()) {
                    ImmutableList<AppliedDoseContourConstraint> immutableList;
                    VolumetricContourOverlayish volumetricContourOverlayish = ((AbstractContourOverlayish)overlayish).G();
                    boolean bl2 = false;
                    ListIterator listIterator = DoseConstraintTableModel.this.rows.listIterator();
                    while (listIterator.hasNext()) {
                        immutableList = (ImmutableList<AppliedDoseContourConstraint>)listIterator.next();
                        if (immutableList.vco != volumetricContourOverlayish) continue;
                        if (!immutableList.cons.matches(volumetricContourOverlayish)) {
                            int n2 = listIterator.previousIndex();
                            listIterator.remove();
                            DoseConstraintTableModel.this.fireTableRowsDeleted(n2, n2);
                            continue;
                        }
                        bl2 = true;
                    }
                    boolean bl3 = false;
                    if (DoseConstraintTableModel.this.persona != null) {
                        immutableList = ((DoseConstraintTableModel)DoseConstraintTableModel.this).persona.constraints;
                        for (AppliedDoseContourConstraint appliedDoseContourConstraint : immutableList) {
                            if (!appliedDoseContourConstraint.matches(volumetricContourOverlayish)) continue;
                            ConstraintRow constraintRow = new ConstraintRow(volumetricContourOverlayish, appliedDoseContourConstraint);
                            if (DoseConstraintTableModel.this.rows.contains(constraintRow)) continue;
                            DoseConstraintTableModel.this.rows.add(constraintRow);
                            bl3 = true;
                        }
                    }
                    if (bl2 || bl3) {
                        DoseConstraintTableModel.this.dose.h().a(DoseConstraintTableModel.this, volumetricContourOverlayish, false);
                    } else {
                        DoseConstraintTableModel.this.dose.h().a((Object)DoseConstraintTableModel.this, volumetricContourOverlayish);
                    }
                    if (bl3) {
                        Collections.sort(DoseConstraintTableModel.this.rows);
                        DoseConstraintTableModel.this.fireTableDataChanged();
                        DoseConstraintTableModel.this.dose.h().i();
                    }
                }
            }
        };
    }

    private void reprocessAll() {
        if (this.persona != null) {
            ImmutableList<AppliedDoseContourConstraint> immutableList = this.persona.constraints;
            List<AbstractContourOverlayish> list = this.dose.ao().n().D();
            for (AbstractContourOverlayish abstractContourOverlayish : list) {
                if (!abstractContourOverlayish.w()) continue;
                abstractContourOverlayish.a(this.ovListener);
                boolean bl2 = false;
                for (AppliedDoseContourConstraint appliedDoseContourConstraint : immutableList) {
                    if (!appliedDoseContourConstraint.matches(abstractContourOverlayish)) continue;
                    this.rows.add(new ConstraintRow(abstractContourOverlayish.G(), appliedDoseContourConstraint));
                    bl2 = true;
                }
                if (!bl2) continue;
                this.dose.h().a(this, abstractContourOverlayish.G(), false);
            }
            Collections.sort(this.rows);
            this.dose.h().i();
        }
    }

    public void cleanup() {
        OverlayCollection overlayCollection;
        ImageFrame imageFrame = this.dose.ao();
        if (imageFrame != null && (overlayCollection = imageFrame.n()) != null) {
            overlayCollection.c(this.collListener);
            for (Overlayish overlayish : overlayCollection) {
                overlayish.c(this.ovListener);
            }
        }
        this.dose.h().b(this.statListener);
        this.dose.h().a(this);
        this.dose.c(this.doseListener);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        switch (n2) {
            case 0: {
                return VolumetricContourOverlayish.class;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return String.class;
            }
            case 5: {
                return FulfilledCellObject.class;
            }
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int n2) {
        switch (n2) {
            case 0: {
                return Messages.a("General", "CONTOUR_OVERLAY");
            }
            case 1: {
                return Messages.a("Dose", "DOSE_CONSTRAINT_NAME");
            }
            case 2: {
                return Messages.a("Dose", "DOSE_CONSTRAINT_DESC");
            }
            case 3: {
                return Messages.a("Dose", "DOSE_CONSTRAINT_CURR_VALUE");
            }
            case 4: {
                return Messages.a("Dose", "DOSE_CONSTRAINT_UNITS");
            }
            case 5: {
                return Messages.a("Dose", "DOSE_CONSTRAINT_FULFILLED");
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        if (n2 >= 0 && n2 < this.getRowCount()) {
            ConstraintRow constraintRow = this.rows.get(n2);
            DoseConstraint.DoseContourConstraint doseContourConstraint = constraintRow.cons.constraint;
            Double d2 = doseContourConstraint.getValueForDisplay(this.dose, constraintRow.vco);
            switch (n3) {
                case 0: {
                    return constraintRow.vco;
                }
                case 1: {
                    return constraintRow.cons.name;
                }
                case 2: {
                    return doseContourConstraint.getDescription() + " " + doseContourConstraint.getPosNegThresholdString();
                }
                case 3: {
                    if (d2 != null) {
                        return doseContourConstraint.formatValue(d2);
                    }
                    return "-";
                }
                case 4: {
                    if (d2 != null) {
                        return doseContourConstraint.getUnitsForDisplay().getExternalizedString();
                    }
                    return "-";
                }
                case 5: {
                    return new FulfilledCellObject(doseContourConstraint.getComparisonType(), doseContourConstraint.fulfilled(this.dose, constraintRow.vco));
                }
            }
        }
        return null;
    }
}

