/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.constraint;

import com.mimvista.archive.gui.SeriesColumn;
import com.mimvista.brachytherapy.report.a.a;
import com.mimvista.dicom.devices.dump.gui.TableColumnAdjuster;
import com.mimvista.dicom.rtdose.gui.DVHTableColumnModel;
import com.mimvista.dicom.rtdose.gui.DVHTableModel;
import com.mimvista.dicom.rtdose.gui.constraint.OverlayNameAndColorCellRenderer;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.proui.MIMLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class DoseDvhTable
extends JXTable {
    private static final long serialVersionUID = 1L;
    public static final Color ROW_HIGHLIGHT = new Color(184, 204, 228);

    public DoseDvhTable() {
        this.init();
    }

    private void init() {
        this.setAutoResizeMode(0);
        this.setOpaque(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setDefaultRenderer(Object.class, this.getRightAlignedRenderer());
        this.setDefaultRenderer(String.class, this.getRightAlignedRenderer());
        this.setDefaultRenderer(VolumetricContourOverlayish.class, new OverlayNameAndColorCellRenderer());
    }

    public void setModel(DVHTableModel dVHTableModel) {
        this.setModel(dVHTableModel, true);
    }

    public void setModel(DVHTableModel dVHTableModel, boolean bl2) {
        super.setModel((TableModel)dVHTableModel);
        for (int i2 = 0; i2 < this.getColumnCount(true); ++i2) {
            this.getColumnExt(i2).setComparator(SeriesColumn.q());
        }
        if (!bl2) {
            return;
        }
        final TableColumnAdjuster tableColumnAdjuster = new TableColumnAdjuster((JTable)((Object)this));
        tableColumnAdjuster.setColumnHeaderIncluded(true);
        tableColumnAdjuster.adjustColumns();
        dVHTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tableColumnAdjuster.adjustColumns();
                    }
                });
            }
        });
    }

    public void setLookAndFeel(Color color, Color color2) {
        this.setBackground(color);
        this.setForeground(color2);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setBackground(color);
        jTableHeader.setForeground(color2);
        this.repaint();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    private DefaultTableCellRenderer getRightAlignedRenderer() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;
            private static final int DVH_VIEWER_PADDING = 2;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                Object object2;
                Serializable serializable;
                Object object3;
                if (object instanceof String[]) {
                    object3 = (String[])object;
                    serializable = new JPanel();
                    ((Container)serializable).setLayout(new GridLayout(1, ((Object)object3).length, 0, 0));
                    for (Object object4 : object3) {
                        JLabel jLabel = new JLabel((String)object4);
                        jLabel.setForeground(DoseDvhTable.this.getForeground());
                        jLabel.setOpaque(false);
                        if (n3 == 0) {
                            jLabel.setFont(jLabel.getFont().deriveFont(1));
                        }
                        jLabel.setHorizontalAlignment(0);
                        jLabel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.BLACK));
                        ((Container)serializable).add(jLabel);
                    }
                    object2 = serializable;
                } else {
                    object3 = new JLabel(object.toString());
                    ((JLabel)object3).setHorizontalAlignment(4);
                    object2 = object3;
                }
                object3 = (DVHTableModel)DoseDvhTable.this.getModel();
                if (object3 instanceof DVHTableColumnModel) {
                    ((JComponent)object2).setOpaque(true);
                    ((JComponent)object2).setBackground(DoseDvhTable.shouldHighlightRow((DVHTableModel)object3, n2) || bl2 ? ROW_HIGHLIGHT : DoseDvhTable.this.getBackground());
                    if (n2 == ((DVHTableModel)DoseDvhTable.this.getModel()).getNumberOfDoseRows() - 1) {
                        ((JComponent)object2).setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
                    }
                } else {
                    ((JComponent)object2).setBackground(bl2 ? jTable.getSelectionBackground() : DoseDvhTable.this.getBackground());
                    ((JComponent)object2).setOpaque(true);
                    serializable = BorderFactory.createMatteBorder(2, 2, 2, 2, ((Component)object2).getBackground());
                    if (n3 == ((DVHTableModel)DoseDvhTable.this.getModel()).getNumberOfDoseRows()) {
                        MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 0, 2, MIMLookAndFeel.j());
                        ((JComponent)object2).setBorder(BorderFactory.createCompoundBorder(matteBorder, (Border)((Object)serializable)));
                    } else {
                        ((JComponent)object2).setBorder((Border)((Object)serializable));
                    }
                }
                ((JComponent)object2).setForeground(DoseDvhTable.this.getForeground());
                ((JComponent)object2).setAlignmentX(1.0f);
                return object2;
            }
        };
        return defaultTableCellRenderer;
    }

    public static boolean shouldHighlightRow(DVHTableModel dVHTableModel, int n2) {
        if (n2 >= 0 && n2 < dVHTableModel.getNumberOfDoseRows()) {
            int n3 = (int)((float)n2 * a.b.floatValue() * 100.0f);
            for (BigDecimal bigDecimal : dVHTableModel.getHighlightedRows()) {
                int n4 = (int)(bigDecimal.floatValue() * 100.0f);
                if (n4 != n3) continue;
                return true;
            }
        }
        return false;
    }
}

