/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.constraint;

import com.google.common.collect.Lists;
import com.mimvista.archive.gui.SeriesColumn;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.dicom.devices.dump.gui.TableColumnAdjuster;
import com.mimvista.dicom.rtdose.DVHGeneratorFactory;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DVHTableModel;
import com.mimvista.dicom.rtdose.gui.DVHTableRowModel;
import com.mimvista.dicom.rtdose.gui.constraint.DoseConstraintCombo;
import com.mimvista.dicom.rtdose.gui.constraint.DoseConstraintTableModel;
import com.mimvista.dicom.rtdose.gui.constraint.DoseDvhTable;
import com.mimvista.dicom.rtdose.gui.constraint.DoseStepEditor;
import com.mimvista.dicom.rtdose.gui.constraint.FulfilledCellObject;
import com.mimvista.dicom.rtdose.gui.constraint.FulfilledCellRenderer;
import com.mimvista.dicom.rtdose.gui.constraint.OverlayNameAndColorCellRenderer;
import com.mimvista.dose.constraints.AppliedDoseContourConstraint;
import com.mimvista.dose.constraints.DoseConstraintSet;
import com.mimvista.dose.constraints.DoseContext;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.internals.DynamicVolumeRef;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.ak;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.Session;
import com.mimvista.mui.captures.Capture;
import com.mimvista.mui.captures.CaptureStorage;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.SimpleVolumetricContourOverlayishBase;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.report.cbct.config.ArtAssistConfig;
import com.mimvista.report.cbct.config.h;
import com.mimvista.report.cbct.config.l;
import com.mimvista.report.data.b.d;
import com.mimvista.report.data.overlay.ReportableContour;
import com.mimvista.response.gui.TherapyResponseWindow;
import com.mimvista.response.n;
import com.mimvista.swing.c;
import com.mimvista.swing.widgets.DoseListCellRenderer;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import com.mimvista.util.work.m;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class DoseStatisticsPage
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox<IsodoseOverlay> doseCombo;
    private DoseConstraintCombo personaCombo;
    private SessionDoseModel doseModel;
    private IsodoseOverlay selectedDose = null;
    private DoseConstraintSet selectedPersona = null;
    private JXTable constraintTable;
    private JXTable dvhTable;
    private DoseConstraintSet artPersona = null;

    public DoseStatisticsPage(Session session) {
        this.doseModel = new SessionDoseModel(session);
        this.build();
    }

    public void refresh() {
        this.updateSelection();
        this.repaint();
    }

    public void rebuildDvhTable() {
        TableModel tableModel;
        if (this.dvhTable != null && (tableModel = this.dvhTable.getModel()) instanceof DVHTableModel) {
            ((DVHTableModel)tableModel).rebuild();
        }
    }

    public void setSelectdDoseFromDoseVol(ImageVolumeShort imageVolumeShort) {
        for (int i2 = 0; i2 < this.doseCombo.getItemCount(); ++i2) {
            if (!this.doseCombo.getItemAt(i2).C().equals(imageVolumeShort)) continue;
            this.doseCombo.setSelectedIndex(i2);
            break;
        }
    }

    public IsodoseOverlay getSelectedDose() {
        return this.selectedDose;
    }

    private void build() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(Box.createHorizontalStrut(8));
        jPanel.add(new JLabel(Messages.a("Dose", "DOSE_STATS_SELECTED_DOSE")));
        jPanel.add(Box.createHorizontalStrut(4));
        this.doseCombo = new JComboBox<IsodoseOverlay>(this.doseModel);
        this.doseCombo.setRenderer(new DoseListCellRenderer());
        jPanel.add(this.doseCombo);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        this.initDoseCombo();
        this.personaCombo = new DoseConstraintCombo(true);
        if (this.doseCombo.getSelectedItem() != null) {
            this.setPersonaFromDoseCombo();
        }
        this.doseCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DoseStatisticsPage.this.setPersonaFromDoseCombo();
                DoseStatisticsPage.this.updateSelection();
            }
        });
        this.personaCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DoseStatisticsPage.this.updateSelection();
            }
        });
        jPanel.add(new JLabel(Messages.a("DoseConstraints", "CONFIG_GUI_DOSE_CONTEXTS_PERSONA")));
        jPanel.add(this.personaCombo);
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.constraintTable = new JXTable();
        this.constraintTable.setDefaultRenderer(FulfilledCellObject.class, (TableCellRenderer)new FulfilledCellRenderer());
        this.constraintTable.setDefaultRenderer(VolumetricContourOverlayish.class, (TableCellRenderer)new OverlayNameAndColorCellRenderer());
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        this.constraintTable.setDefaultRenderer(String.class, (TableCellRenderer)defaultTableCellRenderer);
        this.constraintTable.getTableHeader().setReorderingAllowed(false);
        JComponent jComponent = this.makeTableLabelAndSaveButton(Messages.a("Dose", "DOSE_CONSTRAINT_TITLE"), this.constraintTable);
        jPanel2.add((Component)jComponent, "North");
        JScrollPane jScrollPane = new JScrollPane((Component)this.constraintTable);
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.dvhTable = new DoseDvhTable();
        JComponent jComponent2 = this.makeTableLabelAndSaveButton(Messages.a("Dose", "DOSE_TABLE_TITLE"), this.dvhTable);
        jPanel3.add((Component)jComponent2, "North");
        JScrollPane jScrollPane2 = new JScrollPane((Component)this.dvhTable);
        jScrollPane2.getViewport().setBackground(this.dvhTable.getBackground());
        jPanel3.add((Component)jScrollPane2, "Center");
        final JCheckBox jCheckBox = new JCheckBox(Messages.a("DVH", "DVH_NORM_VOL"));
        jCheckBox.setSelected(true);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableModel tableModel;
                if (DoseStatisticsPage.this.dvhTable != null && (tableModel = DoseStatisticsPage.this.dvhTable.getModel()) instanceof DVHTableModel) {
                    ((DVHTableModel)tableModel).setNormalizeVolume(jCheckBox.isSelected());
                }
            }
        });
        jPanel3.add((Component)c.d(jCheckBox, Box.createHorizontalStrut(30), new DoseStepEditor(this)), "South");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        this.add((Component)jPanel4, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.4f;
        jPanel4.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weighty = 0.6f;
        jPanel4.add((Component)jPanel3, gridBagConstraints);
        this.updateSelection();
    }

    private void initDoseCombo() {
        IsodoseOverlay isodoseOverlay;
        Object e2;
        int n2;
        boolean bl2 = false;
        for (n2 = 0; n2 < this.doseModel.getSize(); ++n2) {
            e2 = this.doseModel.getElementAt(n2);
            if (!(e2 instanceof IsodoseOverlay)) continue;
            isodoseOverlay = (IsodoseOverlay)e2;
            if (!isodoseOverlay.C().getUncopiedMutableInfo().accumulationProducedVolume || !isodoseOverlay.h().m()) continue;
            this.doseModel.setSelectedItem(isodoseOverlay);
            bl2 = true;
            break;
        }
        if (!bl2) {
            for (n2 = 0; n2 < this.doseModel.getSize(); ++n2) {
                e2 = this.doseModel.getElementAt(n2);
                if (!(e2 instanceof IsodoseOverlay) || !(isodoseOverlay = (IsodoseOverlay)e2).h().m()) continue;
                this.doseModel.setSelectedItem(isodoseOverlay);
                break;
            }
        }
    }

    private void setPersonaFromDoseCombo() {
        Object object = this.doseCombo.getSelectedItem();
        if (object instanceof IsodoseOverlay) {
            IsodoseOverlay isodoseOverlay = (IsodoseOverlay)object;
            DoseContext doseContext = isodoseOverlay.g();
            this.setupARTPersona(isodoseOverlay);
            if (this.artPersona != null) {
                this.personaCombo.setSelectedItem(this.artPersona);
            } else if (doseContext != null && doseContext.what != null) {
                for (int i2 = 0; i2 < this.personaCombo.getModel().getSize(); ++i2) {
                    DoseConstraintSet doseConstraintSet = (DoseConstraintSet)this.personaCombo.getItemAt(i2);
                    if (!doseContext.what.name.equals(doseConstraintSet.name)) continue;
                    this.personaCombo.setSelectedIndex(i2);
                    break;
                }
                this.personaCombo.setSelectedItem(doseContext.what);
            } else if (this.personaCombo.getModel().getSize() > 0) {
                this.personaCombo.setSelectedIndex(0);
            }
        }
    }

    private void updateSelection() {
        Object object = this.doseModel.getSelectedItem();
        DoseConstraintSet doseConstraintSet = this.personaCombo.getSelectedItem();
        if (object != this.selectedDose || doseConstraintSet != this.selectedPersona) {
            if (object instanceof IsodoseOverlay && doseConstraintSet != null) {
                TableModel tableModel;
                this.selectedDose = (IsodoseOverlay)object;
                this.selectedPersona = doseConstraintSet;
                if (this.constraintTable != null) {
                    tableModel = this.constraintTable.getModel();
                    if (tableModel instanceof DoseConstraintTableModel) {
                        ((DoseConstraintTableModel)tableModel).cleanup();
                    }
                    this.constraintTable.setModel((TableModel)new DoseConstraintTableModel(this.selectedDose, this.selectedPersona));
                }
                if (this.dvhTable != null) {
                    tableModel = this.dvhTable.getModel();
                    if (tableModel instanceof DVHTableModel) {
                        ((DVHTableModel)tableModel).cleanup();
                    }
                    this.computeAndCacheDVHsIfNeeded(this.selectedDose);
                    com.mimvista.report.data.c.c c2 = new com.mimvista.report.data.c.c(this.selectedDose.ao(), null);
                    d d2 = new d(c2, this.selectedDose);
                    DVHTableRowModel dVHTableRowModel = new DVHTableRowModel(d2, null);
                    this.dvhTable.setModel((TableModel)dVHTableRowModel);
                    for (int i2 = 0; i2 < dVHTableRowModel.getColumnCount(); ++i2) {
                        this.dvhTable.getColumnExt(i2).setComparator(SeriesColumn.q());
                    }
                    final TableColumnAdjuster tableColumnAdjuster = new TableColumnAdjuster((JTable)this.dvhTable, 10);
                    tableColumnAdjuster.setColumnHeaderIncluded(true);
                    tableColumnAdjuster.adjustColumns();
                    dVHTableRowModel.addTableModelListener(new TableModelListener(){

                        @Override
                        public void tableChanged(TableModelEvent tableModelEvent) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    tableColumnAdjuster.adjustColumns();
                                }
                            });
                        }
                    });
                }
            } else {
                this.selectedDose = null;
                this.selectedPersona = null;
            }
        }
    }

    public void cleanup() {
        this.doseModel.listener.detachAndCleanup();
        TableModel tableModel = this.constraintTable.getModel();
        if (tableModel instanceof DoseConstraintTableModel) {
            ((DoseConstraintTableModel)tableModel).cleanup();
        }
    }

    private void computeAndCacheDVHsIfNeeded(final IsodoseOverlay isodoseOverlay) {
        m.e.submit(new Runnable(){

            @Override
            public void run() {
                ArrayList arrayList = Lists.newArrayList();
                for (ReportableContour reportableContour : isodoseOverlay.ao().n().F()) {
                    SimpleVolumetricContourOverlayishBase simpleVolumetricContourOverlayishBase = (SimpleVolumetricContourOverlayishBase)((Object)reportableContour);
                    if (isodoseOverlay.h().b(simpleVolumetricContourOverlayishBase) != null) continue;
                    DoseVolumeHistogram doseVolumeHistogram = DVHGeneratorFactory.generate((SimpleVolumetricContourOverlayishBase)((Object)reportableContour), isodoseOverlay, (Progress)o.o());
                    arrayList.add(doseVolumeHistogram);
                }
                if (!arrayList.isEmpty()) {
                    isodoseOverlay.h().a(new Object(), arrayList);
                }
            }
        });
    }

    private JComponent makeTableLabelAndSaveButton(final String string, final JXTable jXTable) {
        Box box = Box.createHorizontalBox();
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(jLabel.getFont().deriveFont(18.0f));
        box.add(jLabel);
        box.add(Box.createHorizontalGlue());
        final JButton jButton = new JButton(TherapyResponseWindow.a.getProperty("SAVE_AS"), ImageManipulator.c("save", 25));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = DoseStatisticsPage.this.buildCaptureMenuItem(string, jXTable);
                jPopupMenu.add(jMenuItem);
                JMenuItem jMenuItem2 = DoseStatisticsPage.this.buildSpreadSheetMenuItem(jXTable);
                jPopupMenu.add(jMenuItem2);
                jPopupMenu.show(jButton, jButton.getWidth() / 2 - jPopupMenu.getPreferredSize().width / 2, jButton.getHeight());
            }
        });
        box.add(jButton);
        return box;
    }

    private JMenuItem buildSpreadSheetMenuItem(JXTable jXTable) {
        JMenuItem jMenuItem = new JMenuItem(TherapyResponseWindow.a.getProperty("SPREADSHEET"));
        if (this.selectedDose != null) {
            jMenuItem.addActionListener(n.a(jXTable, this.selectedDose.getUncopiedMutableInfo()));
        } else {
            jMenuItem.setEnabled(false);
        }
        return jMenuItem;
    }

    private JMenuItem buildCaptureMenuItem(final String string, final JXTable jXTable) {
        JMenuItem jMenuItem = new JMenuItem(Messages.a("mui", "CAPTURE_GALLERY"));
        if (this.selectedDose != null && this.selectedPersona != null) {
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MIMSwingUtils.a(new Runnable(){

                        @Override
                        public void run() {
                            BufferedImage bufferedImage = n.a(jXTable);
                            String string = string + " - " + ((DoseStatisticsPage)DoseStatisticsPage.this).selectedPersona.name;
                            Capture capture = new Capture(bufferedImage, string, false, new ArrayList<ViewController>());
                            CaptureStorage.a(DoseStatisticsPage.this.selectedDose.aD(), capture);
                        }
                    });
                }
            });
        } else {
            jMenuItem.setEnabled(false);
        }
        return jMenuItem;
    }

    private void setupARTPersona(IsodoseOverlay isodoseOverlay) {
        SearchSource searchSource;
        if (isodoseOverlay == null) {
            return;
        }
        ViewController3D viewController3D = isodoseOverlay.t();
        if (this.artPersona != null) {
            this.personaCombo.removeItem(this.artPersona);
            this.artPersona = null;
        }
        if (!(searchSource = viewController3D.bJ()).s()) {
            return;
        }
        try {
            h h2 = (h)((Object)searchSource);
            ArtAssistConfig artAssistConfig = l.b(h2, viewController3D.getPatientName(), viewController3D.getPatientID(), ArtAssistConfig.a(viewController3D));
            if (artAssistConfig == null) {
                return;
            }
            List<AppliedDoseContourConstraint> list = artAssistConfig.D();
            if (!list.isEmpty()) {
                this.artPersona = new DoseConstraintSet(Messages.a("DVH", "DVH_ART_CONTOUR_CONSTRAINT"), list);
                this.personaCombo.addItem(this.artPersona);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ay.d((Object)"ART Contour Constraint Failed To Load", (Throwable)illegalArgumentException, this);
        }
    }

    private static class SessionDoseModel
    extends DefaultComboBoxModel<IsodoseOverlay> {
        private static final long serialVersionUID = 1L;
        private ak listener;

        public SessionDoseModel(Session session) {
            this.listener = new ak(session){

                @Override
                public void overlayAdded(Overlayish overlayish) {
                    if (overlayish instanceof IsodoseOverlay && this.getIndexOf(overlayish) < 0) {
                        this.addElement((IsodoseOverlay)overlayish);
                    }
                }

                @Override
                public void overlayRemoved(Overlayish overlayish) {
                    if (overlayish instanceof IsodoseOverlay) {
                        this.removeElement(overlayish);
                    }
                }

                @Override
                public void imageFrameAdded(DynamicVolumeRef dynamicVolumeRef) {
                }

                @Override
                public void imageFrameRemoved(DynamicVolumeRef dynamicVolumeRef) {
                }
            };
        }
    }
}

