/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.constraint;

import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.gui.constraint.DoseStatisticsPage;
import com.mimvista.dose.constraints.units.DoseUnit;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.preferencesNew.DosePrefs;
import com.mimvista.report.d;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.NumberFormatter;

public class DoseStepEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final DoseStatisticsPage statsPage;
    private BigDecimal stepSize;
    private boolean isGray;

    public DoseStepEditor(DoseStatisticsPage doseStatisticsPage) {
        this.statsPage = doseStatisticsPage;
        this.setPreferredSize(new Dimension(400, 24));
        this.setMaximumSize(new Dimension(800, 24));
        this.loadValuesFromPrefs();
        this.rebuild(false);
    }

    private void loadValuesFromPrefs() {
        this.stepSize = DosePrefs.getDvhTablePercentStepSizeAsProperRawPercentOrAsGraysIfPercentsAreGrays();
        this.isGray = DosePrefs.dvhTablePercentsAreGrays.getValue();
        if (!this.isGray) {
            this.stepSize = this.stepSize.movePointRight(2);
        } else {
            DoseUnit doseUnit = DoseUnit.f();
            if (!DoseUnit.a.equals(doseUnit)) {
                this.stepSize = doseUnit.a(this.stepSize, DoseUnit.a, null, null);
            }
        }
    }

    private void storeValuesInPrefs() {
        DoseUnit doseUnit;
        BigDecimal bigDecimal = this.stepSize;
        if (this.isGray && !DoseUnit.a.equals(doseUnit = DoseUnit.f())) {
            bigDecimal = DoseUnit.a.a(this.stepSize, doseUnit, null, null);
        }
        DosePrefs.dvhTablePercentStepSize.setValue(bigDecimal);
        DosePrefs.dvhTablePercentsAreGrays.setValue(this.isGray);
        this.statsPage.rebuildDvhTable();
    }

    private void rebuild(final boolean bl2) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                DoseStepEditor.this.removeAll();
                if (bl2) {
                    DoseStepEditor.this.buildEditMode();
                } else {
                    DoseStepEditor.this.buildViewingMode();
                }
                DoseStepEditor.this.revalidate();
                DoseStepEditor.this.repaint();
            }
        });
    }

    private void buildViewingMode() {
        String string;
        Serializable serializable;
        if (this.isGray) {
            serializable = new DoseValue(this.stepSize.floatValue());
            string = ((DoseValue)serializable).getFormattedString();
        } else {
            string = MIMFormat.a(Messages.a("Dose", "DOSE_AND_UNITS_FORMAT"), this.stepSize, Messages.a("DoseConstraints", "DOSE_UNIT_PERCENT_RX"));
        }
        serializable = new JLabel(string);
        ((JLabel)serializable).setHorizontalTextPosition(2);
        ((Component)serializable).addMouseListener(new MouseAdapter((JLabel)serializable){
            final /* synthetic */ JLabel val$valueLabel;
            {
                this.val$valueLabel = jLabel;
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.updateLabel(true, ImageManipulator.c("pencil", 12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.updateLabel(false, null);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DoseStepEditor.this.rebuild(true);
            }

            private void updateLabel(boolean bl2, Icon icon) {
                Font font = d.a(this.val$valueLabel.getFont(), bl2);
                this.val$valueLabel.setFont(font);
                this.val$valueLabel.setIcon(icon);
                this.val$valueLabel.revalidate();
                this.val$valueLabel.repaint();
            }
        });
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(Messages.a("DVH", "DVH_TABLE_STEP_SIZE")), "Center");
        jPanel.add(Box.createHorizontalStrut(5), "East");
        this.add((Component)jPanel, "West");
        this.add((Component)serializable);
    }

    private void buildEditMode() {
        this.setLayout(new BoxLayout(this, 2));
        this.add(new JLabel(Messages.a("DVH", "DVH_TABLE_STEP_SIZE")));
        this.add(Box.createHorizontalStrut(5));
        this.add(this.buildNumberEditor());
        this.add(Box.createHorizontalStrut(5));
        this.add(this.buildUnitEditor());
        this.add(Box.createHorizontalStrut(5));
        this.add(this.buildAcceptButton());
        this.add(Box.createHorizontalStrut(5));
        this.add(this.buildRejectButton());
    }

    private JComponent buildNumberEditor() {
        NumberFormatter numberFormatter = new NumberFormatter();
        numberFormatter.setValueClass(BigDecimal.class);
        numberFormatter.setCommitsOnValidEdit(true);
        numberFormatter.setMinimum(new BigDecimal("0.001"));
        final JFormattedTextField jFormattedTextField = new JFormattedTextField(numberFormatter);
        jFormattedTextField.setValue(this.stepSize);
        jFormattedTextField.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("value".equalsIgnoreCase(propertyChangeEvent.getPropertyName())) {
                    DoseStepEditor.this.stepSize = (BigDecimal)propertyChangeEvent.getNewValue();
                }
            }
        });
        jFormattedTextField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent jComponent) {
                JFormattedTextField jFormattedTextField2;
                JFormattedTextField.AbstractFormatter abstractFormatter;
                if (jComponent instanceof JFormattedTextField && (abstractFormatter = (jFormattedTextField2 = (JFormattedTextField)jComponent).getFormatter()) != null) {
                    block3: {
                        String string = jFormattedTextField2.getText();
                        try {
                            abstractFormatter.stringToValue(string);
                        }
                        catch (ParseException parseException) {
                            if (cn.g(jFormattedTextField.getText())) break block3;
                            ay.c((Object)("Could not parse \"" + jFormattedTextField.getText() + "\" as a number"), this);
                        }
                    }
                    return false;
                }
                return true;
            }

            @Override
            public boolean shouldYieldFocus(JComponent jComponent) {
                return this.verify(jComponent);
            }
        });
        jFormattedTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jFormattedTextField.selectAll();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jFormattedTextField.select(-1, -1);
                    }
                });
            }
        });
        return jFormattedTextField;
    }

    private JComponent buildUnitEditor() {
        final JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{DoseValue.doseUnit.toString(), Messages.a("DoseConstraints", "DOSE_UNIT_PERCENT_RX")});
        jComboBox.setSelectedIndex(this.isGray ? 0 : 1);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = jComboBox.getSelectedIndex();
                DoseStepEditor.this.isGray = n2 == 0;
            }
        });
        return jComboBox;
    }

    private JComponent buildAcceptButton() {
        JButton jButton = new JButton(ImageManipulator.c("checkmark_green", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DoseStepEditor.this.storeValuesInPrefs();
                DoseStepEditor.this.rebuild(false);
            }
        });
        return jButton;
    }

    private JComponent buildRejectButton() {
        JButton jButton = new JButton(ImageManipulator.c("cancel", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DoseStepEditor.this.loadValuesFromPrefs();
                DoseStepEditor.this.rebuild(false);
            }
        });
        return jButton;
    }
}

