/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.constraint;

import com.lowagie.text.pdf.PdfPCell;
import com.mimvista.dose.constraints.ComparisonType;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;

public class FulfilledCellObject {
    private ComparisonType type;
    private FulfilledState isFulfilled;

    public static String getIconString(ComparisonType comparisonType, FulfilledState fulfilledState) {
        String string = comparisonType == ComparisonType.c ? "checkmark_grey" : FulfilledCellObject.getIconString(fulfilledState);
        return string;
    }

    public static String getIconString(FulfilledState fulfilledState) {
        String string = fulfilledState != null ? (fulfilledState == FulfilledState.FULFILLED ? "checkmark_green" : (fulfilledState == FulfilledState.FAILED ? "stop_sign" : "flag_orange")) : "question_mark";
        return string;
    }

    public FulfilledCellObject(ComparisonType comparisonType, FulfilledState fulfilledState) {
        this.type = comparisonType;
        this.isFulfilled = fulfilledState;
    }

    public FulfilledState getFulfilledState() {
        return this.isFulfilled;
    }

    public JComponent getCellComponent(JTable jTable, boolean bl2) {
        JLabel jLabel = new JLabel();
        String string = FulfilledCellObject.getIconString(this.type, this.isFulfilled);
        jLabel = new JLabel(ImageManipulator.c(string, 16));
        jLabel.setOpaque(true);
        if (bl2) {
            jLabel.setForeground(jTable.getSelectionForeground());
            jLabel.setBackground(jTable.getSelectionBackground());
        } else {
            jLabel.setForeground(jTable.getForeground());
            jLabel.setBackground(jTable.getBackground());
        }
        return jLabel;
    }

    public PdfPCell getPdfCell() {
        String string = FulfilledCellObject.getIconString(this.type, this.isFulfilled);
        com.lowagie.text.Image image = null;
        try {
            BufferedImage bufferedImage = ImageManipulator.d(string, 16);
            image = com.lowagie.text.Image.getInstance((Image)bufferedImage, null);
            image.scalePercent(80.0f);
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
        PdfPCell pdfPCell = new PdfPCell(image);
        pdfPCell.setHorizontalAlignment(1);
        pdfPCell.setVerticalAlignment(5);
        return pdfPCell;
    }

    public String toString() {
        if (this.type == ComparisonType.c) {
            return this.type.getExternalizedString();
        }
        if (this.isFulfilled != null) {
            if (this.isFulfilled == FulfilledState.FULFILLED) {
                return Messages.a("General", "YES");
            }
            if (this.isFulfilled == FulfilledState.FAILED) {
                return Messages.a("General", "NO");
            }
            return Messages.a("DoseConstraints", "SAVE_EXCEL_MAYBE");
        }
        return Messages.a("InfoItem", "NA_STRING");
    }

    public static enum FulfilledState {
        FULFILLED,
        FAILED,
        FUZZY;

    }
}

