/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.controls;

import com.google.common.collect.Lists;
import com.mimvista.dicom.devices.dump.gui.TableColumnAdjuster;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.gui.DVHDisplayState;
import com.mimvista.dicom.rtdose.gui.DVHLineStyleRenderer;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.DvhLineStyle;
import com.mimvista.dicom.rtdose.gui.StrokePickerModel;
import com.mimvista.dicom.rtdose.gui.controls.DVHVisibilityTable;
import com.mimvista.dicom.rtdose.gui.controls.DvhCollectionRenderer;
import com.mimvista.dicom.rtdose.gui.controls.DvhVisibilityTableModel;
import com.mimvista.dicom.rtdose.gui.controls.SortedComboBoxModel;
import com.mimvista.dose.bed.ui.b;
import com.mimvista.file.MIMFile;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.work.m;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import net.tomahawk.ExtensionsFilter;
import org.jdesktop.swingx.table.TableColumnExt;

public class DVHCollectionDisplayControls
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final int COLOR_SETTING_PICKER_HEIGHT = 28;
    protected static final Dimension COLOR_SETTING_PICKER_DIMS = new Dimension(130, 28);
    protected static final float COLOR_SETTING_FONT = 11.0f;
    private final DVHDisplayState dvhDisplay;
    private transient DVHVisibilityTable table = null;
    JComboBox<DVHCollection> doseCombo;

    public DVHCollectionDisplayControls(DVHDisplayState dVHDisplayState, int n2) {
        this.dvhDisplay = dVHDisplayState;
        this.setPreferredSize(new Dimension(n2, 0));
        this.setLayout(new BorderLayout());
        this.rebuild();
    }

    public void selectDVH(int n2) {
        int n3 = 0;
        for (Map.Entry<DVHCollection, List<DvhDisplayInfo>> entry : this.dvhDisplay.getDVHParams().getFilteredDVHs().entrySet()) {
            for (DvhDisplayInfo dvhDisplayInfo : entry.getValue()) {
                if (n3 == n2) {
                    dvhDisplayInfo.setSelected(true);
                } else {
                    dvhDisplayInfo.setSelected(false);
                }
                ++n3;
            }
        }
    }

    public void selectDVH(DvhDisplayInfo dvhDisplayInfo) {
        this.dvhDisplay.getDVHParams().selectDVH(dvhDisplayInfo);
    }

    public void selectAllDVH() {
        if (this.dvhDisplay.getSelectedCollection() != null) {
            this.dvhDisplay.getDVHParams().showAll(this.dvhDisplay.getSelectedCollection());
        }
    }

    public void deselectAllDVH() {
        if (this.dvhDisplay.getSelectedCollection() != null) {
            this.dvhDisplay.getDVHParams().hideAll(this.dvhDisplay.getSelectedCollection());
        }
    }

    public void rebuild() {
        SwingUtilities.invokeLater(() -> {
            TableColumn tableColumn = null;
            SortOrder sortOrder = null;
            if (this.table != null && (tableColumn = this.table.getSortedColumn()) != null) {
                sortOrder = this.table.getSortOrder(tableColumn.getIdentifier());
            }
            this.removeAll();
            this.add(this.buildTabPanel());
            this.revalidate();
            this.repaint();
            if (tableColumn != null && sortOrder != null) {
                this.table.setSortOrder(tableColumn.getIdentifier(), sortOrder);
            }
        });
    }

    public void refresh() {
        SwingUtilities.invokeLater(() -> {
            DVHCollection dVHCollection = (DVHCollection)this.doseCombo.getSelectedItem();
            this.revalidate();
            this.repaint();
            this.updateDoseCombo();
            DVHCollection dVHCollection2 = this.dvhDisplay.getSelectedCollection();
            if (dVHCollection2 != dVHCollection) {
                this.doseCombo.setSelectedItem(dVHCollection2);
                return;
            }
            if (this.table == null) {
                return;
            }
            int n2 = this.table.getColumnCount();
            int n3 = this.table.getRowCount();
            this.table.getModel().setDVHCollection(dVHCollection2);
            this.table.getModel().setDVHDisplayState(this.dvhDisplay);
            int n4 = this.table.getModel().getRowCount();
            int n5 = this.table.getModel().getColumnCount();
            if (n5 != n2 || n3 == 0 || n4 == 0) {
                this.table.getModel().fireTableStructureChanged();
            }
            this.table.getModel().fireTableDataChanged();
            this.table.selectActiveDvh();
        });
    }

    private void updateDoseCombo() {
        List<DVHCollection> list = this.dvhDisplay.getSortedDvhCollections();
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < this.doseCombo.getModel().getSize(); ++i2) {
            if (list.contains(this.doseCombo.getModel().getElementAt(i2))) continue;
            arrayList.add(this.doseCombo.getModel().getElementAt(i2));
        }
        for (DVHCollection dVHCollection : list) {
            if (((DefaultComboBoxModel)this.doseCombo.getModel()).getIndexOf(dVHCollection) != -1) continue;
            this.doseCombo.addItem(dVHCollection);
        }
        for (DVHCollection dVHCollection : arrayList) {
            this.doseCombo.removeItem(dVHCollection);
        }
    }

    private JComponent buildTabPanel() {
        List<DVHCollection> list = this.dvhDisplay.getSortedDvhCollections();
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setPreferredSize(new Dimension(400, 0));
        jPanel.setMinimumSize(new Dimension(400, 0));
        SortedComboBoxModel<DVHCollection> sortedComboBoxModel = new SortedComboBoxModel<DVHCollection>(list, DVHCollection.getDVHComparator());
        this.doseCombo = new JComboBox<DVHCollection>(sortedComboBoxModel);
        jPanel.add(this.doseCombo, "North");
        this.doseCombo.setRenderer(new DvhCollectionRenderer(list));
        this.doseCombo.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            JComboBox jComboBox = (JComboBox)itemEvent.getSource();
            DVHCollection dVHCollection = (DVHCollection)jComboBox.getSelectedItem();
            jPanel.removeAll();
            jPanel.add((Component)jComboBox, "North");
            jPanel.add(this.makeTabFor(dVHCollection));
            DVHCollection dVHCollection2 = this.dvhDisplay.getSelectedCollection();
            if (dVHCollection2 != dVHCollection) {
                List<DvhDisplayInfo> list = this.dvhDisplay.getDVHParams().getFilteredDVHs().get(dVHCollection);
                if (list == null || list.isEmpty()) {
                    this.dvhDisplay.selectDVH(this.findFirstVisibleOrReturnFirst(dVHCollection.getDvhDisplayInfo()));
                } else {
                    this.dvhDisplay.selectDVH(this.findFirstVisibleOrReturnFirst(this.dvhDisplay.getDVHParams().getFilteredDVHs().get(dVHCollection)));
                }
            }
            jPanel.revalidate();
            jPanel.repaint();
            this.refresh();
        });
        DVHCollection dVHCollection = this.dvhDisplay.getSelectedCollection();
        if (dVHCollection != null) {
            this.doseCombo.setSelectedItem(dVHCollection);
        }
        return jPanel;
    }

    private DvhDisplayInfo findFirstVisibleOrReturnFirst(List<DvhDisplayInfo> list) {
        for (DvhDisplayInfo dvhDisplayInfo : list) {
            if (!dvhDisplayInfo.isVisible()) continue;
            return dvhDisplayInfo;
        }
        return list.get(0);
    }

    private JComponent makeTabFor(DVHCollection dVHCollection) {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)this.makeCollectionActionPanel(dVHCollection), "North");
        this.table = new DVHVisibilityTable(dVHCollection, this.dvhDisplay);
        this.table.setHorizontalScrollEnabled(true);
        TableColumnAdjuster tableColumnAdjuster = new TableColumnAdjuster((JTable)((Object)this.table));
        tableColumnAdjuster.setApplyMaxAndPreferredWidth(true);
        tableColumnAdjuster.setApplyMinWidth(true);
        tableColumnAdjuster.setColumnHeaderIncluded(true);
        tableColumnAdjuster.setDynamicAdjustment(false);
        tableColumnAdjuster.adjustColumns(true);
        TableColumnExt tableColumnExt = this.table.getColumnExt(1);
        tableColumnExt.setMaxWidth(30);
        tableColumnExt.setMinWidth(30);
        tableColumnExt.setPreferredWidth(30);
        tableColumnExt.setWidth(30);
        this.table.getColumn(0).setMinWidth(100);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.table));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JComponent makeCollectionActionPanel(DVHCollection dVHCollection) {
        JButton jButton;
        Box box = Box.createHorizontalBox();
        box.add(this.makeLineStyleCombo(dVHCollection));
        box.add(Box.createHorizontalGlue());
        JCheckBox jCheckBox = new JCheckBox(Messages.a("Report", "LOCK_DOSE_LINESTYLES"), this.dvhDisplay.getLockDoseLineStyles());
        jCheckBox.setToolTipText(Messages.a("Report", "LOCK_DOSE_LINESTYLES_TIP"));
        jCheckBox.addActionListener(actionEvent -> this.dvhDisplay.updateLockDoseLineStyles(jCheckBox.isSelected()));
        box.add(jCheckBox);
        box.add(Box.createHorizontalGlue());
        if (dVHCollection != null && !dVHCollection.getDoseInfo().u().s()) {
            jButton = new JButton(Messages.a("Dose", "TCP_DVH_BUTTON"));
            box.add(Box.createHorizontalStrut(5));
            box.add(jButton);
            box.add(Box.createHorizontalStrut(10));
            jButton.addActionListener(new b(this.dvhDisplay, dVHCollection));
        }
        jButton = new JButton(Messages.a("DVH").b("DVH_OUTPUT_CONTOUR_STATS"));
        jButton.setToolTipText(Messages.a("DVH").b("DVH_OUTPUT_CONTOUR_STATS_TIP"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Window window = SwingUtilities.getWindowAncestor(DVHCollectionDisplayControls.this);
                MIMFileDialog mIMFileDialog = MIMFileDialog.a(window, Messages.a("DVH").getProperty("DVH_OUTPUT_CSV"), MIMFileDialog.FileDialogType.b, true);
                mIMFileDialog.a(ExtensionsFilter.getNoDescSingleExt("csv"));
                mIMFileDialog.a(true);
                String string = mIMFileDialog.a();
                if (!cn.g(string)) {
                    if (!string.endsWith(".csv")) {
                        string = string + ".csv";
                    }
                    final MIMFile mIMFile = new MIMFile(string);
                    m.b.submit(new Runnable(){

                        @Override
                        public void run() {
                            DVHCollectionDisplayControls.this.writeDVHStatsToCSV(mIMFile);
                        }
                    });
                }
            }
        });
        box.add(jButton);
        box.add(Box.createHorizontalStrut(5));
        return box;
    }

    private void writeDVHStatsToCSV(MIMFile mIMFile) {
        try (a.a.a.a.b b2 = new a.a.a.a.b(new FileWriter(mIMFile));){
            int n2;
            DvhVisibilityTableModel dvhVisibilityTableModel = this.table.getModel();
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)this.table.getColumnCount());
            for (int i2 = 0; i2 < this.table.getColumnCount(); ++i2) {
                n2 = this.table.convertColumnIndexToModel(i2);
                if (n2 == 1) continue;
                arrayList.add(dvhVisibilityTableModel.getColumnName(n2));
            }
            b2.b(arrayList);
            NumberFormat numberFormat = NumberFormatFactory.a();
            for (n2 = 0; n2 < dvhVisibilityTableModel.getRowCount(); ++n2) {
                arrayList.clear();
                int n3 = this.table.convertRowIndexToModel(n2);
                for (int i3 = 0; i3 < this.table.getColumnCount(); ++i3) {
                    int n4 = this.table.convertColumnIndexToModel(i3);
                    if (n4 == 1) continue;
                    Object object = dvhVisibilityTableModel.getValueAt(n3, n4);
                    String string = null;
                    string = object instanceof Number ? numberFormat.format(((Number)object).doubleValue()) : object.toString();
                    arrayList.add(string);
                }
                b2.b(arrayList);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Unable to export the contour/dose stats to CSV.", "CSV Output Error", 0);
            ay.d((Object)"Error while exporting contour/dose stats to CSV.", (Throwable)exception, this);
        }
    }

    private JComboBox<DvhLineStyle> makeLineStyleCombo(DVHCollection dVHCollection2) {
        JComboBox<DvhLineStyle> jComboBox = new JComboBox<DvhLineStyle>();
        StrokePickerModel strokePickerModel = new StrokePickerModel(dVHCollection2, dVHCollection -> {
            if (dVHCollection == null) {
                return;
            }
            DvhLineStyle dvhLineStyle = (DvhLineStyle)jComboBox.getSelectedItem();
            if (dvhLineStyle == null) {
                return;
            }
            for (DvhDisplayInfo dvhDisplayInfo : dVHCollection.getDvhDisplayInfo()) {
                this.dvhDisplay.updateStroke(dvhDisplayInfo, dvhLineStyle);
            }
        });
        jComboBox.setModel(strokePickerModel);
        jComboBox.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            SwingUtilities.invokeLater(() -> strokePickerModel.setSelectedItem(strokePickerModel.getSelectedItem()));
        });
        jComboBox.setRenderer(new DVHLineStyleRenderer(new Color(100, 100, 100, 255)));
        jComboBox.setPreferredSize(COLOR_SETTING_PICKER_DIMS);
        jComboBox.setMaximumSize(COLOR_SETTING_PICKER_DIMS);
        jComboBox.setAlignmentX(0.0f);
        jComboBox.setFont(jComboBox.getFont().deriveFont(11.0f));
        jComboBox.setMaximumRowCount(50);
        return jComboBox;
    }
}

