/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.controls;

import com.mimvista.archive.gui.SeriesColumn;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.gui.DVHDisplayState;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.controls.DvhVisibilityEditor;
import com.mimvista.dicom.rtdose.gui.controls.DvhVisibilityTableModel;
import com.mimvista.dicom.rtdose.gui.controls.style.DvhColorAndStyle;
import com.mimvista.dicom.rtdose.gui.controls.style.DvhStyleEditor;
import com.mimvista.util.NumberFormatFactory;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class DVHVisibilityTable
extends JXTable {
    private static final long serialVersionUID = 1L;

    public DVHVisibilityTable(DVHCollection dVHCollection, DVHDisplayState dVHDisplayState) {
        super((TableModel)new DvhVisibilityTableModel(dVHCollection, dVHDisplayState));
        int n2;
        this.setSelectionMode(0);
        this.setDefaultRenderer(DvhDisplayInfo.class, new DvhVisibilityEditor());
        this.setDefaultEditor(DvhDisplayInfo.class, new DvhVisibilityEditor());
        this.setDefaultRenderer(DvhColorAndStyle.class, new DvhStyleEditor(dVHDisplayState));
        this.setDefaultEditor(DvhColorAndStyle.class, new DvhStyleEditor(dVHDisplayState));
        this.setDefaultRenderer(Number.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                if (object instanceof Number) {
                    NumberFormat numberFormat = NumberFormatFactory.a();
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, numberFormat.format(((Number)object).doubleValue()), bl2, bl3, n2, n3);
                    jLabel.setHorizontalAlignment(4);
                    return jLabel;
                }
                return super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            }
        });
        this.getColumnExt(0).setPreferredWidth(150);
        this.getColumnExt(1).setPreferredWidth(30);
        for (n2 = 2; n2 <= 6; ++n2) {
            this.getColumnExt(n2).setPreferredWidth(50);
        }
        for (n2 = 0; n2 <= 6; ++n2) {
            this.getColumnExt(n2).setComparator(SeriesColumn.q());
        }
        this.selectActiveDvh();
        this.listenForSelectionChange(dVHDisplayState);
    }

    public DvhVisibilityTableModel getModel() {
        return (DvhVisibilityTableModel)super.getModel();
    }

    public void selectActiveDvh() {
        DvhVisibilityTableModel dvhVisibilityTableModel = this.getModel();
        for (int i2 = 0; i2 < dvhVisibilityTableModel.getRowCount(); ++i2) {
            int n2 = this.convertRowIndexToModel(i2);
            if (!dvhVisibilityTableModel.getDisplayInfoFor(n2).isSelected()) continue;
            this.getSelectionModel().setSelectionInterval(n2, n2);
        }
    }

    private void listenForSelectionChange(final DVHDisplayState dVHDisplayState) {
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n2 = DVHVisibilityTable.this.getSelectedRow();
                if (n2 == -1) {
                    return;
                }
                int n3 = DVHVisibilityTable.this.convertRowIndexToModel(n2);
                DvhDisplayInfo dvhDisplayInfo = DVHVisibilityTable.this.getModel().getDisplayInfoFor(n3);
                if (dvhDisplayInfo != null) {
                    dVHDisplayState.getDVHParams().selectDVH(dvhDisplayInfo);
                }
            }
        });
    }
}

