/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.controls;

import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.mui.info.InfoItemLayout;
import com.mimvista.mui.overlays.LabelDrawer;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.util.DateUtils;
import com.mimvista.util.cn;
import com.mimvista.viewer.SeriesInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class DvhCollectionRenderer
extends JPanel
implements ListCellRenderer<DVHCollection> {
    private static final long serialVersionUID = 1L;
    private int maxHeight = 0;
    private int maxNameWidth = 0;
    private int maxDateWidth = 0;
    private int maxFrameWidth = 0;

    DvhCollectionRenderer(List<DVHCollection> list) {
        this.setLayout(new BoxLayout(this, 2));
        for (DVHCollection dVHCollection : list) {
            Dimension dimension = this.getNameLabel(dVHCollection).getPreferredSize();
            this.maxNameWidth = Math.max(this.maxNameWidth, dimension.width);
            this.maxHeight = Math.max(this.maxHeight, dimension.height);
            dimension = this.getDateLabel(dVHCollection).getPreferredSize();
            this.maxDateWidth = Math.max(this.maxDateWidth, dimension.width);
            this.maxHeight = Math.max(this.maxHeight, dimension.height);
            dimension = this.getFrameLabel(dVHCollection).getPreferredSize();
            this.maxFrameWidth = Math.max(this.maxFrameWidth, dimension.width);
            this.maxHeight = Math.max(this.maxHeight, dimension.height);
        }
        int n2 = 380 - this.maxNameWidth - this.maxDateWidth - this.maxFrameWidth;
        this.maxNameWidth += n2 / 2;
        this.maxDateWidth += n2 / 2;
        this.maxHeight = Math.max(this.maxHeight, 30);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends DVHCollection> jList, DVHCollection dVHCollection, int n2, boolean bl2, boolean bl3) {
        this.removeAll();
        this.setToolTipText(null);
        if (dVHCollection == null) {
            return this;
        }
        JLabel jLabel = this.getNameLabel(dVHCollection);
        JLabel jLabel2 = this.getDateLabel(dVHCollection);
        JLabel jLabel3 = this.getFrameLabel(dVHCollection);
        this.forceSize(jLabel, this.maxNameWidth, this.maxHeight);
        this.forceSize(jLabel2, this.maxDateWidth, this.maxHeight);
        this.forceSize(jLabel3, this.maxFrameWidth, this.maxHeight);
        this.add(jLabel);
        this.add(jLabel2);
        this.add(jLabel3);
        this.setToolTipText(this.buildTooltip(jLabel, jLabel2, jLabel3));
        return this;
    }

    private String buildTooltip(JLabel jLabel, JLabel jLabel2, JLabel jLabel3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><table cellpadding='10'><tr><td><strong style='color:");
        stringBuilder.append(MIMLookAndFeel.a(jLabel.getForeground()));
        stringBuilder.append(";'>");
        stringBuilder.append(jLabel.getText());
        stringBuilder.append("</strong></td><td><font style='color:");
        stringBuilder.append(MIMLookAndFeel.a(jLabel2.getForeground()));
        stringBuilder.append(";'>");
        stringBuilder.append(jLabel2.getText());
        stringBuilder.append("</font></td><td><i>");
        stringBuilder.append(jLabel3.getText());
        stringBuilder.append("</i></td>");
        stringBuilder.append("</tr></table></html>");
        return stringBuilder.toString();
    }

    private void forceSize(JLabel jLabel, int n2, int n3) {
        Dimension dimension = new Dimension(n2, n3);
        jLabel.setPreferredSize(dimension);
        jLabel.setMinimumSize(dimension);
        jLabel.setMaximumSize(dimension);
    }

    private JLabel getNameLabel(DVHCollection dVHCollection) {
        SeriesInfo seriesInfo = dVHCollection.getAnonDoseInfoIfNeeded();
        String string = cn.i(dVHCollection.getUpdatedSeriesDesc());
        String string2 = cn.i(seriesInfo.seriesDesc);
        if (cn.g(string)) {
            string = string2;
        }
        JLabel jLabel = new JLabel(string);
        if (!cn.a(string, string2, true)) {
            jLabel.setForeground(InfoItemLayout.WORKFLOW_NAME_COLOR);
        }
        return jLabel;
    }

    private JLabel getDateLabel(DVHCollection dVHCollection) {
        SeriesInfo seriesInfo = dVHCollection.getAnonDoseInfoIfNeeded();
        String string = seriesInfo.a(DateUtils.b());
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(InfoItemLayout.CHRONOLOGY_COLOR);
        return jLabel;
    }

    private JLabel getFrameLabel(DVHCollection dVHCollection) {
        JLabel jLabel = new JLabel();
        if (dVHCollection.isSeries4D()) {
            jLabel.setIcon(ImageManipulator.c("icon_clock", 16));
            jLabel.setText(LabelDrawer.a(dVHCollection.getViewController(), dVHCollection.getVolume()));
            jLabel.setFont(jLabel.getFont().deriveFont(2));
        }
        return jLabel;
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        this.validate();
    }
}

