/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.controls;

import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.proui.MIMLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DvhVisibilityEditor
extends DefaultCellEditor
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private JComponent checkAndName = new JPanel(new BorderLayout());
    private JLabel nameLabel = new JLabel();

    public DvhVisibilityEditor() {
        this(true);
    }

    public DvhVisibilityEditor(boolean bl2) {
        super(new JCheckBox());
        if (bl2) {
            this.checkAndName.add((Component)this.editorComponent, "West");
            this.checkAndName.add(this.nameLabel);
        } else {
            this.checkAndName = Box.createHorizontalBox();
            this.checkAndName.add(Box.createHorizontalGlue());
            this.checkAndName.add(this.editorComponent);
            this.checkAndName.add(Box.createHorizontalGlue());
        }
        this.editorComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DvhVisibilityEditor.this.checkAndName.setBackground(MIMLookAndFeel.getMenuSelectedBackground());
            }
        });
        this.checkAndName.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DvhVisibilityEditor.this.stopCellEditing();
            }
        });
        this.nameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DvhVisibilityEditor.this.stopCellEditing();
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
        return this.getTableCellEditorComponent(jTable, object, bl2, n2, n3);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
        JCheckBox jCheckBox = (JCheckBox)this.editorComponent;
        jCheckBox.setOpaque(false);
        this.nameLabel.setOpaque(false);
        this.checkAndName.setOpaque(true);
        if (this.nameLabel == null) {
            return jCheckBox;
        }
        if (jTable.getSelectedRow() == n2 || bl2) {
            this.checkAndName.setBackground(jTable.getSelectionBackground());
        } else {
            this.checkAndName.setBackground(jTable.getBackground());
        }
        if (object instanceof DvhDisplayInfo) {
            DvhDisplayInfo dvhDisplayInfo = (DvhDisplayInfo)object;
            this.delegate.setValue(dvhDisplayInfo.isVisible());
            this.nameLabel.setText(dvhDisplayInfo.getName());
        } else {
            this.delegate.setValue(object);
            this.nameLabel.setText("");
        }
        return this.checkAndName;
    }
}

