/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.controls;

import com.google.common.base.Objects;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.SimpleBEDInfo;
import com.mimvista.dicom.rtdose.gui.DVHDisplayState;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.controls.style.DvhColorAndStyle;
import com.mimvista.util.Messages;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;

public class DvhVisibilityTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private DVHCollection dvhCollection;
    private DVHDisplayState dvhDisplay;

    DvhVisibilityTableModel(DVHCollection dVHCollection, DVHDisplayState dVHDisplayState) {
        this.dvhCollection = dVHCollection;
        this.dvhDisplay = dVHDisplayState;
    }

    public void setDVHCollection(DVHCollection dVHCollection) {
        this.dvhCollection = dVHCollection;
    }

    public void setDVHDisplayState(DVHDisplayState dVHDisplayState) {
        this.dvhDisplay = dVHDisplayState;
    }

    public DvhDisplayInfo getDisplayInfoFor(int n2) {
        List<DvhDisplayInfo> list = this.getDvhItems();
        if (this.isRowInvalid(n2, list)) {
            return null;
        }
        return list.get(n2);
    }

    @Override
    public String getColumnName(int n2) {
        Column column = Column.get(n2);
        if (column != null) {
            return column.userText;
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        boolean bl2 = false;
        for (DvhDisplayInfo dvhDisplayInfo : this.getDvhItems()) {
            SimpleBEDInfo simpleBEDInfo;
            DoseVolumeHistogram doseVolumeHistogram = dvhDisplayInfo.getDVH();
            if (doseVolumeHistogram == null || (simpleBEDInfo = doseVolumeHistogram.getBedInfo()) == null) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            return Column.TCP.index + 1;
        }
        return Column.STDEV.index + 1;
    }

    @Override
    public int getRowCount() {
        return this.getDvhItems().size();
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return n3 == Column.VISIBILITY.index || n3 == Column.STYLE.index;
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        if (n2 == Column.VISIBILITY.index) {
            return DvhDisplayInfo.class;
        }
        if (n2 == Column.STYLE.index) {
            return DvhColorAndStyle.class;
        }
        return Number.class;
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        DvhDisplayInfo dvhDisplayInfo = this.getDisplayInfoFor(n2);
        if (dvhDisplayInfo == null) {
            return;
        }
        if (n3 == Column.VISIBILITY.index) {
            if (object instanceof Boolean) {
                this.dvhDisplay.setVisible(dvhDisplayInfo, (Boolean)object);
            }
        } else if (n3 == Column.STYLE.index && object instanceof DvhColorAndStyle) {
            DvhColorAndStyle dvhColorAndStyle = (DvhColorAndStyle)object;
            if (!Objects.equal((Object)dvhDisplayInfo.getColor(), (Object)dvhColorAndStyle.getColor())) {
                this.dvhDisplay.updateColor(dvhDisplayInfo, dvhColorAndStyle.getColor());
            }
            if (dvhDisplayInfo.getLineStyle() != dvhColorAndStyle.getStyle()) {
                this.dvhDisplay.updateStroke(dvhDisplayInfo, dvhColorAndStyle.getStyle());
            }
        }
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        DvhDisplayInfo dvhDisplayInfo = this.getDisplayInfoFor(n2);
        if (dvhDisplayInfo == null) {
            return null;
        }
        Column column = Column.get(n3);
        if (column == null) {
            return null;
        }
        DoseVolumeHistogram doseVolumeHistogram = dvhDisplayInfo.getDVH();
        if (doseVolumeHistogram == null) {
            return null;
        }
        switch (column) {
            case VISIBILITY: {
                return dvhDisplayInfo;
            }
            case STYLE: {
                DvhColorAndStyle dvhColorAndStyle = new DvhColorAndStyle();
                dvhColorAndStyle.setColor(dvhDisplayInfo.getColor());
                dvhColorAndStyle.setStyle(dvhDisplayInfo.getLineStyle());
                return dvhColorAndStyle;
            }
            case VOLUME: {
                return doseVolumeHistogram.getMaxVolume();
            }
            case MAX: {
                return this.getDoseValueInCurrentUnit(doseVolumeHistogram.getMaxDose());
            }
            case MIN: {
                return this.getDoseValueInCurrentUnit(doseVolumeHistogram.getMinDose());
            }
            case MEAN: {
                return this.getDoseValueInCurrentUnit(doseVolumeHistogram.getMeanDose());
            }
            case STDEV: {
                return this.getDoseValueInCurrentUnit(doseVolumeHistogram.getDoseStdDev());
            }
            case TCP: {
                return doseVolumeHistogram.calculateTCP();
            }
        }
        return null;
    }

    private double getDoseValueInCurrentUnit(double d2) {
        DoseValue doseValue = new DoseValue();
        doseValue.setValueInGy((float)d2);
        return doseValue.getValueInCurrentUnit();
    }

    private boolean isRowInvalid(int n2, List<DvhDisplayInfo> list) {
        return n2 < 0 || n2 >= list.size();
    }

    private List<DvhDisplayInfo> getDvhItems() {
        if (this.dvhDisplay == null || this.dvhDisplay.getDVHParams() == null) {
            return Collections.emptyList();
        }
        Map<DVHCollection, List<DvhDisplayInfo>> map = this.dvhDisplay.getDVHParams().getFilteredDVHs();
        if (map == null || map.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.dvhCollection == null) {
            return Collections.emptyList();
        }
        List<DvhDisplayInfo> list = map.get(this.dvhCollection);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    private static enum Column {
        VISIBILITY(0, Messages.a("Contour", "CONT_COLL_PANEL_NAME")),
        STYLE(1, ""),
        VOLUME(2, Messages.a("Contour", "VOLUME_FULL_STAT")),
        MAX(3, Messages.a("DVH", "DVH_MAX_DOSE")),
        MIN(4, Messages.a("DVH", "DVH_MIN_DOSE")),
        MEAN(5, Messages.a("DVH", "DVH_MEAN_DOSE")),
        STDEV(6, Messages.a("DVH", "DVH_SD_DOSE")),
        TCP(7, Messages.a("Dose", "TCP"));

        private final int index;
        private final String userText;

        private Column(int n3, String string2) {
            this.index = n3;
            this.userText = string2;
        }

        static Column get(int n2) {
            for (Column column : Column.values()) {
                if (column.index != n2) continue;
                return column;
            }
            return null;
        }
    }
}

