/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.controls;

import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;

class SortedComboBoxModel<E>
extends DefaultComboBoxModel<E> {
    private static final long serialVersionUID = 1L;
    private Comparator<E> comparator;

    public SortedComboBoxModel(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    public SortedComboBoxModel(List<E> list, Comparator<E> comparator) {
        this.comparator = comparator;
        for (E e2 : list) {
            this.addElement(e2);
        }
    }

    public static <F extends Comparable<F>> SortedComboBoxModel<F> buildSortedComboBoxModelWithNaturalSorting(Vector<F> vector) {
        return new SortedComboBoxModel<F>(vector, new Comparator<F>(){

            @Override
            public int compare(F f2, F f3) {
                return f2.compareTo(f3);
            }
        });
    }

    public static <F extends Comparable<F>> SortedComboBoxModel<F> buildSortedComboBoxModelWithNaturalSorting(List<F> list) {
        return new SortedComboBoxModel<F>(list, new Comparator<F>(){

            @Override
            public int compare(F f2, F f3) {
                return f2.compareTo(f3);
            }
        });
    }

    public SortedComboBoxModel(Vector<E> vector, Comparator<E> comparator) {
        this.comparator = comparator;
        for (E e2 : vector) {
            this.addElement(e2);
        }
    }

    @Override
    public void addElement(E e2) {
        this.insertElementAt(e2, 0);
    }

    @Override
    public void insertElementAt(E e2, int n2) {
        Object e3;
        int n3 = this.getSize();
        for (n2 = 0; n2 < n3 && this.comparator.compare(e3 = this.getElementAt(n2), e2) <= 0; ++n2) {
        }
        super.insertElementAt(e2, n2);
    }
}

