/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.controls.style;

import com.mimvista.dicom.rtdose.gui.DVHDisplayState;
import com.mimvista.dicom.rtdose.gui.DVHLineStyleRenderer;
import com.mimvista.dicom.rtdose.gui.DvhLineStyle;
import com.mimvista.dicom.rtdose.gui.controls.style.DvhColorAndStyle;
import com.mimvista.mui.contours.e;
import com.mimvista.mui.overlays.OverlayColor;
import com.mimvista.mui.overlays.OverlayColorPool;
import com.mimvista.util.Messages;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DvhStyleEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected DvhColorAndStyle colorAndStyle;
    protected DVHLineStyleRenderer renderer = new DVHLineStyleRenderer();
    private DVHDisplayState state;

    public DvhStyleEditor(DVHDisplayState dVHDisplayState) {
        this.state = dVHDisplayState;
        this.listenForClick();
    }

    @Override
    public Object getCellEditorValue() {
        return this.colorAndStyle;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
        return this.getTableCellRendererComponent(jTable, object, bl2 || jTable.getSelectedRow() == n2, true, n2, n3);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
        if (object instanceof DvhColorAndStyle) {
            this.colorAndStyle = (DvhColorAndStyle)object;
            this.renderer.setColorAndStyle(this.colorAndStyle);
        } else {
            this.colorAndStyle = null;
            this.renderer.setColorAndStyle(null);
        }
        this.renderer.setOpaque(true);
        if (bl2) {
            this.renderer.setBackground(jTable.getSelectionBackground());
        } else {
            this.renderer.setBackground(jTable.getBackground());
        }
        return this.renderer;
    }

    private void listenForClick() {
        this.renderer.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DvhStyleEditor.this.showMenu(mouseEvent);
            }
        });
    }

    private void showMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = this.buildMenu();
        jPopupMenu.show(this.renderer, (this.renderer.getWidth() - jPopupMenu.getWidth()) / 2, this.renderer.getHeight());
    }

    private JPopupMenu buildMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.buildColorMenu());
        jPopupMenu.add(this.buildStyleMenu());
        return jPopupMenu;
    }

    private JMenu buildColorMenu() {
        JMenu jMenu = new JMenu(Messages.a("Dose", "SETTING_DIALOG_LEVEL_COLORCOL"));
        OverlayColorPool overlayColorPool = new OverlayColorPool();
        for (final OverlayColor overlayColor : overlayColorPool.b()) {
            JMenuItem jMenuItem = new JMenuItem(overlayColor.name, e.a(overlayColor));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DvhStyleEditor.this.colorAndStyle.setColor(overlayColor.color);
                    DvhStyleEditor.this.fireEditingStopped();
                }
            });
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    private JMenu buildStyleMenu() {
        JMenu jMenu = new JMenu(Messages.a("Commands", "CAPTURE_DVH_LINE_STYLE"));
        for (final DvhLineStyle dvhLineStyle : DvhLineStyle.values()) {
            JMenuItem jMenuItem = new JMenuItem(dvhLineStyle.getIcon(16, jMenu.getBackground()));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DvhStyleEditor.this.colorAndStyle.setStyle(dvhLineStyle);
                    DvhStyleEditor.this.fireEditingStopped();
                }
            });
            jMenu.add(jMenuItem);
        }
        jMenu.setEnabled(!this.state.getLockDoseLineStyles());
        return jMenu;
    }
}

