/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.stats;

import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.stats.DvhStatsSource;
import java.io.Serializable;
import java.util.List;

public class CummulativeDvhStatsGenerator
implements DvhStatsSource,
Serializable {
    private static final long serialVersionUID = -4876012178891352134L;
    final double doseOfFirstBin;
    final List<DoseVolumeHistogram.HistogramBin> bins;
    Double meanDose = null;

    public CummulativeDvhStatsGenerator(double d2, double[] dArray, double[] dArray2) {
        this(d2, DoseVolumeHistogram.buildHistogramBins(dArray, dArray2));
    }

    public CummulativeDvhStatsGenerator(double d2, List<DoseVolumeHistogram.HistogramBin> list) {
        this.doseOfFirstBin = d2;
        this.bins = Lists.newArrayList(list);
    }

    public CummulativeDvhStatsGenerator(double d2, double d3, List<DoseVolumeHistogram.HistogramBin> list) {
        this.doseOfFirstBin = d2;
        this.bins = Lists.newArrayList(list);
    }

    @Override
    public synchronized double computeMeanDose() {
        if (this.meanDose != null) {
            return this.meanDose;
        }
        double d2 = this.doseOfFirstBin;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i2 = 0; i2 < this.bins.size() - 1; ++i2) {
            DoseVolumeHistogram.HistogramBin histogramBin = this.bins.get(i2);
            DoseVolumeHistogram.HistogramBin histogramBin2 = this.bins.get(i2 + 1);
            d3 = histogramBin.value - histogramBin2.value;
            d5 += ((d2 += histogramBin.width) - histogramBin.width / 2.0) * d3;
            d4 += d3;
        }
        DoseVolumeHistogram.HistogramBin histogramBin = this.bins.get(this.bins.size() - 1);
        d3 = histogramBin.value;
        d5 += (d2 += histogramBin.width / 2.0) * d3;
        if ((d4 += d3) == 0.0) {
            this.meanDose = 0.0;
            return 0.0;
        }
        this.meanDose = d5 / d4;
        return this.meanDose;
    }

    @Override
    public double computeMinDose() {
        if (this.bins.get((int)0).value <= 0.0) {
            return 0.0;
        }
        double d2 = this.doseOfFirstBin;
        for (int i2 = 0; i2 < this.bins.size() - 1; ++i2) {
            DoseVolumeHistogram.HistogramBin histogramBin = this.bins.get(i2);
            DoseVolumeHistogram.HistogramBin histogramBin2 = this.bins.get(i2 + 1);
            if (Math.abs(histogramBin.value - histogramBin2.value) > 1.0E-4) break;
            d2 += histogramBin.width;
        }
        return d2;
    }

    @Override
    public double computeMaxDose() {
        double d2 = this.doseOfFirstBin;
        for (int i2 = 0; i2 < this.bins.size(); ++i2) {
            DoseVolumeHistogram.HistogramBin histogramBin = this.bins.get(i2);
            if (!(histogramBin.value > 0.0)) break;
            d2 += histogramBin.width;
        }
        return d2;
    }

    @Override
    public synchronized double computeStandardDeviation() {
        if (this.meanDose == null) {
            this.computeMeanDose();
        }
        if (this.bins.size() == 0) {
            return 0.0;
        }
        double d2 = 0.0;
        double d3 = this.doseOfFirstBin;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i2 = 0; i2 < this.bins.size() - 1; ++i2) {
            DoseVolumeHistogram.HistogramBin histogramBin = this.bins.get(i2);
            DoseVolumeHistogram.HistogramBin histogramBin2 = this.bins.get(i2 + 1);
            double d6 = (d3 += histogramBin.width) - histogramBin.width / 2.0;
            d4 = histogramBin.value - histogramBin2.value;
            if (d4 != 0.0) {
                d2 += d4 * Math.pow(d6 - this.meanDose, 2.0);
            }
            d5 += d4;
        }
        DoseVolumeHistogram.HistogramBin histogramBin = this.bins.get(this.bins.size() - 1);
        d4 = histogramBin.value;
        d2 += d4 * Math.pow((d3 += histogramBin.width / 2.0) - this.meanDose, 2.0);
        if ((d5 += d4) == 0.0) {
            return 0.0;
        }
        return Math.sqrt(d2 / d5);
    }

    @Override
    public double computeMaxVolume() {
        double d2 = 0.0;
        for (DoseVolumeHistogram.HistogramBin histogramBin : this.bins) {
            if (!(histogramBin.value > d2)) continue;
            d2 = histogramBin.value;
        }
        return d2;
    }
}

