/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.stats;

import com.mimvista.dicom.rtdose.stats.DvhStatsSource;
import com.mimvista.dicom.util.RescaleConverter;
import java.io.Serializable;

public class DvhStatsGenerator
implements DvhStatsSource,
Serializable {
    private static final long serialVersionUID = 6594442051846510114L;
    final RescaleConverter rescale;
    final long[] histogram;
    final int rawValueOfFirstBin;
    final double sampleVolume;
    final double max;
    final double min;
    Double meanDose = null;

    public DvhStatsGenerator(RescaleConverter rescaleConverter, int n2, long[] lArray, double d2, double d3, double d4) {
        this.rescale = rescaleConverter;
        this.rawValueOfFirstBin = n2;
        this.histogram = lArray;
        this.sampleVolume = d2;
        this.max = d4;
        this.min = d3;
    }

    @Override
    public double computeMaxDose() {
        return this.max;
    }

    @Override
    public double computeMaxVolume() {
        long l2 = 0L;
        for (int i2 = 0; i2 < this.histogram.length; ++i2) {
            l2 += this.histogram[i2];
        }
        return (double)l2 * this.sampleVolume;
    }

    @Override
    public synchronized double computeMeanDose() {
        if (this.meanDose != null) {
            return this.meanDose;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.histogram.length; ++i2) {
            d2 += (double)(this.rescale.apply(this.rawValueOfFirstBin + i2) * (float)this.histogram[i2]);
            d3 += (double)this.histogram[i2];
        }
        this.meanDose = d2 / d3;
        return this.meanDose;
    }

    @Override
    public double computeMinDose() {
        return this.min;
    }

    @Override
    public synchronized double computeStandardDeviation() {
        if (this.meanDose == null) {
            this.computeMeanDose();
        }
        double d2 = 0.0;
        long l2 = 0L;
        for (int i2 = 0; i2 < this.histogram.length; ++i2) {
            if (this.histogram[i2] > 0L) {
                double d3 = this.rescale.apply(this.rawValueOfFirstBin + i2);
                d2 += (double)this.histogram[i2] * Math.pow(d3 - this.meanDose, 2.0);
            }
            l2 += this.histogram[i2];
        }
        return Math.sqrt(d2 / (double)l2);
    }
}

