/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtplan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mimvista.dicom.rtplan.FloatQuantity;
import com.mimvista.e;
import com.mimvista.numerics.MathUtils;
import com.mimvista.state.b;
import com.mimvista.util.MIMSerializable;
import com.mimvista.util.ay;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

@e
public abstract class Collimator {
    List<CollimatorTimepoint> timepoints = Lists.newArrayList();
    FloatQuantity.MMQuantity sourceToCollimatorDistance;
    boolean usingDefaultSTC = false;
    LeafOrientation leafOrientation;
    float[] cumulativeMetersets;
    float finalMeterset;

    Collimator(LeafOrientation leafOrientation) {
        this.leafOrientation = leafOrientation;
    }

    public LeafOrientation getLeafOrientation() {
        return this.leafOrientation;
    }

    public void setLeafOrientation(LeafOrientation leafOrientation) {
        this.leafOrientation = leafOrientation;
    }

    public void setSourceToCollimatorDistance(FloatQuantity.MMQuantity mMQuantity) {
        this.sourceToCollimatorDistance = mMQuantity;
    }

    public FloatQuantity.MMQuantity getSourceToCollimatorDistance() {
        return this.sourceToCollimatorDistance;
    }

    public boolean isUsingDefaultSourceToCollimatorDistance() {
        return this.usingDefaultSTC;
    }

    public void addTimePoint(CollimatorTimepoint collimatorTimepoint) {
        this.timepoints.add(collimatorTimepoint);
    }

    public ImmutableList<CollimatorTimepoint> getTimePoints() {
        return new ImmutableList.Builder().addAll(this.timepoints).build();
    }

    public CollimatorTimepoint getFirstTimePoint() {
        return this.timepoints.get(0);
    }

    public int getNumberOfLeaves() {
        return ((CollimatorTimepoint)this.getTimePoints().get(0)).getLeafJawPositions().length / 2;
    }

    public CollimatorTimepoint getMaxProjectionTimePoint() {
        int n2 = this.getNumberOfLeaves();
        float[] fArray = (float[])((CollimatorTimepoint)this.getTimePoints().get(0)).getLeafJawPositions().clone();
        for (CollimatorTimepoint collimatorTimepoint : this.getTimePoints()) {
            int n3;
            float[] fArray2 = collimatorTimepoint.getLeafJawPositions();
            for (n3 = 0; n3 < n2; ++n3) {
                if (!(fArray[n3] > fArray2[n3])) continue;
                fArray[n3] = fArray2[n3];
            }
            for (n3 = n2; n3 < n2 * 2; ++n3) {
                if (!(fArray[n3] < fArray2[n3])) continue;
                fArray[n3] = fArray2[n3];
            }
        }
        return new CollimatorTimepoint(-1, fArray);
    }

    public CollimatorTimepoint getTimePointByIndex(int n2) {
        if (n2 == -1) {
            return this.getMaxProjectionTimePoint();
        }
        if (this.timepoints.size() == 1) {
            return this.timepoints.get(0);
        }
        return this.timepoints.get(n2);
    }

    public float getFinalCumulativeMeterset() {
        return this.finalMeterset;
    }

    public float getMetersetAt(int n2) {
        return this.cumulativeMetersets[n2];
    }

    public CollimatorTimepoint getTimePointByMeterset(float f2) {
        if (f2 < 0.0f || f2 > this.finalMeterset) {
            ay.e((Object)"A collimator was queried at an invalid cumulative meterset. Clamping to the valid range...", this);
            f2 = MathUtils.c(f2, 0.0f, this.finalMeterset);
        }
        if (this.timepoints.size() == 1) {
            return this.timepoints.get(0);
        }
        int n2 = Arrays.binarySearch(this.cumulativeMetersets, f2);
        if (n2 >= 0) {
            CollimatorTimepoint collimatorTimepoint = this.getTimePointByIndex(n2);
            return new CollimatorTimepoint(collimatorTimepoint.getTimePointIndex(), collimatorTimepoint.getLeafJawPositions());
        }
        n2 = -(n2 + 1);
        int n3 = n2 - 1;
        float[] fArray = this.timepoints.get(n3).getLeafJawPositions();
        float[] fArray2 = this.timepoints.get(n2).getLeafJawPositions();
        float[] fArray3 = new float[fArray.length];
        float f3 = (f2 - this.cumulativeMetersets[n3]) / (this.cumulativeMetersets[n2] - this.cumulativeMetersets[n3]);
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray3[i2] = fArray[i2] + f3 * (fArray2[i2] - fArray[i2]);
        }
        return new CollimatorTimepoint(n3, fArray3);
    }

    public abstract String getType();

    private static class DeserializableCollimatorSubclass
    extends DeserializableCollimator
    implements MIMSerializable {
        protected float[] leafBoundaries;

        public DeserializableCollimatorSubclass(LeafOrientation leafOrientation) {
            super(leafOrientation);
        }
    }

    private static class DeserializableCollimator
    implements MIMSerializable {
        LeafOrientation leafOrientation;

        public DeserializableCollimator(LeafOrientation leafOrientation) {
        }
    }

    public static class MultiLeafCollimator
    extends Collimator {
        protected float[] leafBoundaries;

        public MultiLeafCollimator(LeafOrientation leafOrientation) {
            super(leafOrientation);
        }

        public void setLeafBoundaries(float[] fArray) {
            this.leafBoundaries = fArray;
        }

        public float[] getLeafBoundaries() {
            return ArrayUtils.clone((float[])this.leafBoundaries);
        }

        @Override
        public String getType() {
            return "MLC";
        }
    }

    public static class CollimatorJaws
    extends Collimator {
        private boolean isSymmetric = false;

        public CollimatorJaws(LeafOrientation leafOrientation) {
            super(leafOrientation);
        }

        public void setSymmetric(boolean bl2) {
            this.isSymmetric = bl2;
        }

        public boolean isSymmetric() {
            return this.isSymmetric;
        }

        @Override
        public String getType() {
            return "JAWS";
        }
    }

    public static enum LeafOrientation implements b,
    MIMSerializable
    {
        X,
        Y;


        @Override
        public String convertOldValue(String string) {
            if (string.equals("MLCX")) {
                return "X";
            }
            if (string.equals("MLCY")) {
                return "Y";
            }
            return null;
        }
    }

    public static class CollimatorTimepoint
    implements MIMSerializable {
        private int timePointIndex;
        private float[] leafJawPositions;

        public float[] getLeafJawPositions() {
            return ArrayUtils.clone((float[])this.leafJawPositions);
        }

        public void setLeafJawPositions(float[] fArray) {
            this.leafJawPositions = fArray;
        }

        public int getTimePointIndex() {
            return this.timePointIndex;
        }

        public CollimatorTimepoint(int n2, float[] fArray) {
            this.timePointIndex = n2;
            this.leafJawPositions = fArray;
        }
    }
}

