/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtplan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.commands.workflow.AssignRtImageOrientationCommand;
import com.mimvista.d;
import com.mimvista.dicom.SerializableDicomObject;
import com.mimvista.dicom.rtplan.Bolus;
import com.mimvista.dicom.rtplan.Collimator;
import com.mimvista.dicom.rtplan.FloatQuantity;
import com.mimvista.dicom.rtplan.ReferencePoint;
import com.mimvista.dicom.rtplan.ReportableRtplanState;
import com.mimvista.dicom.rtplan.RtplanSessionState;
import com.mimvista.dicom.rtplan.RtplanStateManager;
import com.mimvista.dicom.rtplan.Wedge;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.ViewController;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.contourtools.l;
import com.mimvista.state.ReadHelper;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.apache.commons.lang3.ArrayUtils;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class DicomBeamRecord
implements ReportableRtplanState.BeamRecord {
    private static final long serialVersionUID = 1L;
    protected Point3f.PointVolumeInfo pvi;
    protected int refBeamNumber;
    protected String rtstSop;
    protected List<ReferencePoint> doseReferencePoints;
    protected SerializableDicomObject beamItemDcm;
    protected SerializableDicomObject rtPlanDcm;
    protected transient List<Wedge> wedges;
    protected transient List<ReferencePoint> referencePoints;
    protected transient List<Bolus> boli;
    protected transient List<Collimator> collimators;
    private static final FloatQuantity.MMQuantity DEFAULT_STC = new FloatQuantity.MMQuantity(400.0f);
    protected transient FloatQuantity.MonitorUnitQuantity monitorUnits = null;
    protected transient FloatQuantity.GrayQuantity beamDose = null;
    protected transient FloatQuantity.MMQuantity ssd = null;

    public static DicomBeamRecord getBeamFor(ViewController viewController) {
        if (viewController.bh().cz()) {
            ImmutableList<RtplanSessionState> immutableList = RtplanStateManager.getForSession(viewController.g()).getRtplanStates();
            for (RtplanSessionState rtplanSessionState : immutableList) {
                DicomBeamRecord dicomBeamRecord = (DicomBeamRecord)rtplanSessionState.getBeam(viewController);
                if (dicomBeamRecord == null) continue;
                return dicomBeamRecord;
            }
        }
        return null;
    }

    public static FloatQuantity.MMQuantity getDefaultSTC() {
        return new FloatQuantity.MMQuantity(DEFAULT_STC.getValue());
    }

    public DicomBeamRecord(DicomObject dicomObject, int n2, String string, Point3f.PointVolumeInfo pointVolumeInfo, List<ReferencePoint> list) {
        this.setBeamItem(dicomObject.get(805961904).getDicomObject(n2));
        this.setRtPlan(dicomObject);
        this.pvi = pointVolumeInfo;
        this.rtstSop = string;
        this.refBeamNumber = this.getBeamItem().getInt(805961920);
        this.doseReferencePoints = list;
        this.initialize();
    }

    public void initialize() {
        this.referencePoints = Lists.newArrayList();
        this.boli = Lists.newArrayList();
        this.collimators = Lists.newArrayList();
        this.wedges = Lists.newArrayList();
        this.parseBolusAndWedgesAndJaws();
        this.readMetersets();
        this.parseFractionGroup();
    }

    public boolean isUsingDefaultSTC() {
        Collimator.MultiLeafCollimator multiLeafCollimator = this.getFirstMLC();
        if (multiLeafCollimator != null) {
            return multiLeafCollimator.isUsingDefaultSourceToCollimatorDistance();
        }
        return this.collimators.stream().allMatch(collimator -> collimator.isUsingDefaultSourceToCollimatorDistance());
    }

    protected DicomObject getFirstControlPoint() {
        DicomElement dicomElement = this.getBeamItem().get(805962001);
        if (dicomElement.countItems() < 1) {
            return null;
        }
        return dicomElement.getDicomObject(0);
    }

    public void setSSD(FloatQuantity.MMQuantity mMQuantity) {
        this.ssd = mMQuantity;
    }

    @Override
    @d
    public FloatQuantity.MMQuantity getSSD() {
        return this.ssd;
    }

    @Override
    public String getMachineId() {
        return this.getBeamItem().getString(805961906);
    }

    @Override
    public String getEnergyMode() {
        return this.getBeamItem().getString(805961926);
    }

    @Override
    public FloatQuantity.MuPerMinuteQuantity getDoseRate() {
        return this.getDoseRate(0);
    }

    public FloatQuantity.MuPerMinuteQuantity getDoseRate(int n2) {
        DicomObject dicomObject = this.getBeamItem().get(805962001).getDicomObject(n2);
        if (dicomObject == null) {
            return null;
        }
        if (dicomObject.containsValue(805962005)) {
            return new FloatQuantity.MuPerMinuteQuantity(dicomObject.getFloat(805962005));
        }
        DicomObject dicomObject2 = this.getBeamItem().get(805962001).getDicomObject(0);
        if (dicomObject2.containsValue(805962005)) {
            return new FloatQuantity.MuPerMinuteQuantity(dicomObject2.getFloat(805962005));
        }
        return null;
    }

    public DosimeterUnit getPrimaryDosimeterUnit() {
        String string = this.getBeamItem().getString(805961907, "");
        if (string.equalsIgnoreCase("MU")) {
            return DosimeterUnit.MU;
        }
        if (string.equalsIgnoreCase("MINUTE")) {
            return DosimeterUnit.MINUTE;
        }
        return null;
    }

    public int getMaxMUSegment() {
        DicomElement dicomElement = this.getBeamItem().get(805962001);
        if (dicomElement.countItems() <= 2) {
            return 0;
        }
        float[] fArray = this.getCumulativeMetersets();
        boolean bl2 = this.getPrimaryDosimeterUnit() == DosimeterUnit.MINUTE;
        int n2 = -1;
        float f2 = Float.MIN_VALUE;
        for (int i2 = 0; i2 < fArray.length - 1; ++i2) {
            float f3 = fArray[i2 + 1] - fArray[i2];
            if (bl2) {
                f3 *= this.getDoseRate(i2).getValue();
            }
            if (!(f3 > f2)) continue;
            f2 = f3;
            n2 = i2;
        }
        return n2;
    }

    @Override
    public FloatQuantity.EnergyQuantity getBeamEnergy() {
        DicomObject dicomObject = this.getFirstControlPoint();
        if (dicomObject == null) {
            return null;
        }
        if (dicomObject.containsValue(805962004)) {
            if ("PHOTON".equals(this.getBeamItem().getString(805961926))) {
                return new FloatQuantity.MVQuantity(dicomObject.getFloat(805962004));
            }
            return new FloatQuantity.MeVQuantity(dicomObject.getFloat(805962004));
        }
        return null;
    }

    @Override
    public String getTechnique() {
        return this.getBeamItem().getString(805961924);
    }

    @Override
    public FloatQuantity.MMQuantity getSourceAxisDistance() {
        float f2 = this.getBeamItem().getFloat(805961908);
        return new FloatQuantity.MMQuantity(f2);
    }

    @Override
    public FloatQuantity.MMQuantity[] getFieldSize() {
        Collimator.CollimatorJaws collimatorJaws = this.getXJaws();
        Collimator.CollimatorJaws collimatorJaws2 = this.getYJaws();
        float[] fArray = collimatorJaws.getMaxProjectionTimePoint().getLeafJawPositions();
        float[] fArray2 = collimatorJaws2.getMaxProjectionTimePoint().getLeafJawPositions();
        float f2 = Math.abs(fArray2[1] - fArray2[0]);
        float f3 = Math.abs(fArray[1] - fArray[0]);
        return new FloatQuantity.MMQuantity[]{new FloatQuantity.MMQuantity(f3), new FloatQuantity.MMQuantity(f2)};
    }

    @Override
    public FloatQuantity.AngleDegQuantity getGantryAngle() {
        DicomObject dicomObject = this.getFirstControlPoint();
        if (dicomObject == null) {
            return null;
        }
        return new FloatQuantity.AngleDegQuantity(dicomObject.getFloat(805962014));
    }

    @Override
    public SimpleOrientationHelper.PatientPosition getPatientPosition() {
        DicomElement dicomElement = this.getRtPlan().get(805962112);
        if (dicomElement.countItems() == 1) {
            return SimpleOrientationHelper.PatientPosition.a(dicomElement.getDicomObject(0).getString(1593600, ""));
        }
        int n2 = this.getBeamItem().getInt(806092906, 0);
        Optional<String> optional = IntStream.range(0, dicomElement.countItems()).mapToObj(arg_0 -> ((DicomElement)dicomElement).getDicomObject(arg_0)).filter(dicomObject -> dicomObject.getInt(805962114) == n2).map(dicomObject -> dicomObject.getString(1593600)).findFirst();
        if (optional.isPresent()) {
            return SimpleOrientationHelper.PatientPosition.a(optional.get());
        }
        ay.d((Object)("Beam \"" + this.getBeamName() + "\" does not reference a valid patient setup!"), this);
        return null;
    }

    @Override
    public FloatQuantity.AngleDegQuantity getCollimatorAngle() {
        DicomObject dicomObject = this.getFirstControlPoint();
        if (dicomObject == null) {
            return null;
        }
        return new FloatQuantity.AngleDegQuantity(dicomObject.getFloat(805962016));
    }

    public FloatQuantity.AngleDegQuantity getCollimatorAngle(int n2) {
        DicomElement dicomElement = this.getBeamItem().get(805962001);
        if (dicomElement.countItems() <= n2) {
            throw new IndexOutOfBoundsException("Queried " + Integer.toString(dicomElement.countItems()) + "-point control sequence at index " + Integer.toString(n2));
        }
        float f2 = dicomElement.getDicomObject(n2).getFloat(805962016, Float.NaN);
        if (Float.isNaN(f2)) {
            f2 = dicomElement.getDicomObject(0).getFloat(805962016);
        }
        return new FloatQuantity.AngleDegQuantity(f2);
    }

    @Override
    public FloatQuantity.AngleDegQuantity getPatientSupportAngle() {
        DicomObject dicomObject = this.getFirstControlPoint();
        if (dicomObject == null) {
            return null;
        }
        return new FloatQuantity.AngleDegQuantity(dicomObject.getFloat(805962018));
    }

    @Override
    public DicomPoint3f getIsocenter() {
        float[] fArray;
        DicomObject dicomObject = this.getFirstControlPoint();
        if (dicomObject != null && (fArray = dicomObject.getFloats(805962028)) != null && fArray.length == 3) {
            return new DicomPoint3f(fArray, this.pvi);
        }
        return null;
    }

    @Override
    public DicomPoint3f getSourcePoint() {
        DicomPoint3f dicomPoint3f = this.getIsocenter();
        float f2 = this.getSourceAxisDistance().getValue();
        Vector3f vector3f = this.getCameraVector();
        vector3f.negate();
        vector3f.normalize();
        vector3f.scale(f2);
        dicomPoint3f.add((Tuple3f)vector3f);
        return dicomPoint3f;
    }

    public Vector3f getCameraVector() {
        Pair<Vector3f, Vector3f> pair = AssignRtImageOrientationCommand.computeRtImageIOP(this.getGantryAngle().getValue(), this.getPatientPosition());
        Vector3f vector3f = new Vector3f();
        vector3f.cross((Vector3f)pair.x, (Vector3f)pair.y);
        return vector3f;
    }

    public Vector3f getCameraUpVector() {
        return (Vector3f)AssignRtImageOrientationCommand.computeRtImageIOP((float)this.getGantryAngle().getValue(), (SimpleOrientationHelper.PatientPosition)this.getPatientPosition()).y;
    }

    public Pair<Vector3f, Vector3f> getRtImageOrientationVectors() {
        return AssignRtImageOrientationCommand.computeRtImageIOP(this.getGantryAngle().getValue(), this.getPatientPosition());
    }

    @Override
    public String getRtplanSOPUID() {
        return this.getRtPlan().getString(524312);
    }

    public int getNumberOfControlPoints() {
        return this.getBeamItem().get(805962001).countItems();
    }

    public float[] getCumulativeMetersets() {
        return ArrayUtils.clone((float[])this.getXJaws().cumulativeMetersets);
    }

    public float getFinalCumulativeMeterset() {
        return this.getXJaws().finalMeterset;
    }

    private void parseBolusAndWedgesAndJaws() {
        Collimator.CollimatorJaws collimatorJaws;
        float f2;
        float f3;
        Collimator.CollimatorTimepoint collimatorTimepoint;
        Collimator collimator2;
        DicomElement dicomElement;
        DicomElement dicomElement2;
        DicomElement dicomElement3 = this.getBeamItem().get(806092976);
        if (dicomElement3 != null && dicomElement3.countItems() > 0) {
            this.parseBolusSequence(dicomElement3);
        }
        if ((dicomElement2 = this.getBeamItem().get(805961937)) != null && dicomElement2.countItems() > 0) {
            this.parseWedgeSequence(dicomElement2);
        }
        if ((dicomElement = this.getBeamItem().get(805961910)) != null && dicomElement.countItems() > 0) {
            this.collimators = DicomBeamRecord.parseCollimators(this.getBeamItem());
        }
        Predicate<Collimator> predicate = collimator -> collimator instanceof Collimator.MultiLeafCollimator && collimator.leafOrientation == Collimator.LeafOrientation.X;
        Predicate<Collimator> predicate2 = collimator -> collimator instanceof Collimator.MultiLeafCollimator && collimator.leafOrientation == Collimator.LeafOrientation.Y;
        if (this.getXJaws() == null && this.collimators.stream().anyMatch(predicate)) {
            collimator2 = this.collimators.stream().filter(predicate).findFirst().get();
            collimatorTimepoint = collimator2.getMaxProjectionTimePoint();
            f3 = MathUtils.u(collimatorTimepoint.getLeafJawPositions());
            f2 = MathUtils.s(collimatorTimepoint.getLeafJawPositions());
            collimatorJaws = new Collimator.CollimatorJaws(Collimator.LeafOrientation.X);
            collimatorJaws.setSymmetric(false);
            collimatorJaws.addTimePoint(new Collimator.CollimatorTimepoint(0, new float[]{f2, f3}));
            this.collimators.add(collimatorJaws);
        }
        if (this.getYJaws() == null && this.collimators.stream().anyMatch(predicate2)) {
            collimator2 = this.collimators.stream().filter(predicate2).findFirst().get();
            collimatorTimepoint = collimator2.getMaxProjectionTimePoint();
            f3 = MathUtils.u(collimatorTimepoint.getLeafJawPositions());
            f2 = MathUtils.s(collimatorTimepoint.getLeafJawPositions());
            collimatorJaws = new Collimator.CollimatorJaws(Collimator.LeafOrientation.Y);
            collimatorJaws.setSymmetric(false);
            collimatorJaws.addTimePoint(new Collimator.CollimatorTimepoint(0, new float[]{f2, f3}));
            this.collimators.add(collimatorJaws);
        }
    }

    private void parseFractionGroup() {
        this.referencePoints.clear();
        if (this.getRtPlan().get(805961840) == null) {
            return;
        }
        DicomElement dicomElement = this.getRtPlan().get(805961840);
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            DicomElement dicomElement2 = dicomObject.get(806092804);
            for (int i3 = 0; i3 < dicomElement2.countItems(); ++i3) {
                DicomObject dicomObject2 = dicomElement2.getDicomObject(i3);
                if (dicomObject2.getInt(806092806) != this.refBeamNumber) continue;
                float f2 = dicomObject2.getFloat(805961862);
                float f3 = dicomObject2.getFloat(805961860);
                this.monitorUnits = this.getPrimaryDosimeterUnit() == DosimeterUnit.MINUTE ? this.scaleMinutesToMU(f2) : new FloatQuantity.MonitorUnitQuantity(f2);
                this.beamDose = new FloatQuantity.GrayQuantity(f3);
                float[] fArray = dicomObject2.getFloats(805961858);
                if (fArray == null) continue;
                DicomPoint3f dicomPoint3f = new DicomPoint3f(fArray, this.pvi);
                ReferencePoint referencePoint = new ReferencePoint(dicomPoint3f, this.beamDose);
                for (ReferencePoint referencePoint2 : this.doseReferencePoints) {
                    if (!(referencePoint2.getLocation().distance(referencePoint.getLocation()) < 1.0E-4f)) continue;
                    referencePoint.setId(referencePoint2.getId());
                }
                this.referencePoints.add(referencePoint);
            }
        }
    }

    private FloatQuantity.MonitorUnitQuantity scaleMinutesToMU(float f2) {
        if (this.getDoseRate(0) == null) {
            ay.c((Object)("Dose Rate is undefined for the beam: " + this.getBeamName() + ". Returning NaN."), this);
            return new FloatQuantity.MonitorUnitQuantity(Float.NaN);
        }
        float[] fArray = this.getCumulativeMetersets();
        float f3 = this.getFinalCumulativeMeterset();
        float f4 = 0.0f;
        for (int i2 = 0; i2 < this.getNumberOfControlPoints() - 1; ++i2) {
            float f5 = f2 * (fArray[i2 + 1] - fArray[i2]) / f3;
            f4 += f5 * this.getDoseRate(i2).getValue();
        }
        return new FloatQuantity.MonitorUnitQuantity(f4);
    }

    private void parseBolusSequence(DicomElement dicomElement) {
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            int n2 = dicomObject.getInt(805699716);
            Bolus bolus = new Bolus("", n2, this.rtstSop);
            this.boli.add(bolus);
        }
    }

    private void readMetersets() {
        DicomElement dicomElement = this.getBeamItem().get(805962001);
        for (Collimator collimator : this.collimators) {
            collimator.cumulativeMetersets = new float[dicomElement.countItems()];
            collimator.finalMeterset = this.getBeamItem().getFloat(805961998);
        }
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            Collimator collimator;
            collimator = dicomElement.getDicomObject(i2);
            float f2 = collimator.getFloat(805962036);
            for (Collimator collimator2 : this.collimators) {
                collimator2.cumulativeMetersets[i2] = f2;
            }
        }
    }

    private void parseWedgeSequence(DicomElement dicomElement) {
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            String string = dicomObject.getString(805961939);
            float f2 = dicomObject.getInt(805961941);
            float f3 = dicomObject.getFloat(805961944);
            Wedge wedge = new Wedge(string, new FloatQuantity.AngleDegQuantity(f2), new FloatQuantity.AngleDegQuantity(f3));
            this.wedges.add(wedge);
        }
    }

    public static List<Collimator> parseCollimators(DicomObject dicomObject) {
        Object object;
        Object object2;
        Object object3;
        ArrayList arrayList = Lists.newArrayList();
        HashMap hashMap = Maps.newHashMap();
        DicomElement dicomElement = dicomObject.get(805961910);
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            Object object4;
            DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
            String string = dicomObject2.getString(805961912, "");
            float f2 = dicomObject2.getFloat(805961914, Float.NaN);
            if (string.equals("ASYMX") || string.equals("X")) {
                object4 = new Collimator.CollimatorJaws(Collimator.LeafOrientation.X);
                if (string.startsWith("ASYM")) {
                    ((Collimator.CollimatorJaws)object4).setSymmetric(false);
                }
                object3 = object4;
            } else if (string.equals("ASYMY") || string.equals("Y")) {
                object4 = new Collimator.CollimatorJaws(Collimator.LeafOrientation.Y);
                if (string.startsWith("ASYM")) {
                    ((Collimator.CollimatorJaws)object4).setSymmetric(false);
                }
                object3 = object4;
            } else {
                if (!string.startsWith("MLC")) continue;
                object4 = string.endsWith("X") ? Collimator.LeafOrientation.X : Collimator.LeafOrientation.Y;
                object2 = new Collimator.MultiLeafCollimator((Collimator.LeafOrientation)object4);
                object = dicomObject2.getFloats(805961918);
                if (object != null) {
                    ((Collimator.MultiLeafCollimator)object2).setLeafBoundaries((float[])object);
                }
                object3 = object2;
            }
            if (!Float.isNaN(f2)) {
                object3.setSourceToCollimatorDistance(new FloatQuantity.MMQuantity(f2));
            } else {
                object3.setSourceToCollimatorDistance(new FloatQuantity.MMQuantity(DEFAULT_STC.getValue()));
                object3.usingDefaultSTC = true;
            }
            hashMap.put(string, object3);
            arrayList.add(object3);
        }
        DicomElement dicomElement2 = dicomObject.get(805962001);
        for (int i3 = 0; i3 < dicomElement2.countItems(); ++i3) {
            object3 = dicomElement2.getDicomObject(i3);
            int n2 = object3.getInt(805962002);
            DicomElement dicomElement3 = object3.get(805962010);
            if (dicomElement3 == null) continue;
            for (int i4 = 0; i4 < dicomElement3.countItems(); ++i4) {
                object2 = dicomElement3.getDicomObject(i4);
                object = object2.getString(805961912);
                Collimator collimator = (Collimator)hashMap.get(object);
                if (collimator == null) {
                    collimator = (Collimator)hashMap.get(object = ((String)object).startsWith("ASYM") ? ((String)object).replaceFirst("ASYM", "") : "ASYM" + (String)object);
                    if (collimator == null) continue;
                    ay.c((Object)("Beam with name \"" + dicomObject.getString(805961922) + "\" doesn't consistently describe its collimators. Relaxing the symmetry constraint on collimator jaws..."), DicomBeamRecord.class);
                }
                float[] fArray = object2.getFloats(805962012);
                Collimator.CollimatorTimepoint collimatorTimepoint = new Collimator.CollimatorTimepoint(n2, fArray);
                collimator.addTimePoint(collimatorTimepoint);
            }
        }
        return arrayList;
    }

    @Override
    public FloatQuantity.GrayQuantity getReferenceDose() {
        return this.beamDose;
    }

    @Override
    public FloatQuantity.MonitorUnitQuantity getMonitorUnits() {
        return this.monitorUnits;
    }

    @Override
    public List<ReferencePoint> getReferencePoints() {
        return this.referencePoints;
    }

    @Override
    public String getBeamName() {
        return this.getBeamItem().getString(805961922);
    }

    @Override
    public List<Collimator> getCollimators() {
        return this.collimators;
    }

    @Override
    public Collimator.CollimatorJaws getXJaws() {
        for (Collimator collimator : this.collimators) {
            if (!(collimator instanceof Collimator.CollimatorJaws) || collimator.getLeafOrientation() != Collimator.LeafOrientation.X) continue;
            return (Collimator.CollimatorJaws)collimator;
        }
        return null;
    }

    @Override
    public Collimator.CollimatorJaws getYJaws() {
        for (Collimator collimator : this.collimators) {
            if (!(collimator instanceof Collimator.CollimatorJaws) || collimator.getLeafOrientation() != Collimator.LeafOrientation.Y) continue;
            return (Collimator.CollimatorJaws)collimator;
        }
        return null;
    }

    @Override
    public Collimator.MultiLeafCollimator getFirstMLC() {
        for (Collimator collimator : this.collimators) {
            if (!(collimator instanceof Collimator.MultiLeafCollimator)) continue;
            return (Collimator.MultiLeafCollimator)collimator;
        }
        return null;
    }

    @Override
    public int getFirstMLCIndex() {
        for (int i2 = 0; i2 < this.collimators.size(); ++i2) {
            Collimator collimator = this.collimators.get(i2);
            if (!(collimator instanceof Collimator.MultiLeafCollimator)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public List<Bolus> getBoli() {
        return this.boli;
    }

    @Override
    public List<Wedge> getWedges() {
        return this.wedges;
    }

    @Override
    public Vector3f[] getCollimatorAxes() {
        return this.getCollimatorAxes(0);
    }

    @Override
    public Vector3f[] getCollimatorAxes(int n2) {
        Point3f[] point3fArray = new Point3f[]{this.getSourcePoint(), this.getSourcePoint()};
        point3fArray[0].add((Tuple3f)l.a(this.getCameraUpVector(), this.getCameraVector()));
        point3fArray[1].add((Tuple3f)this.getCameraUpVector());
        l.a a2 = l.a.a((Point3f)this.getIsocenter(), this.getSourcePoint());
        a2.a(Math.toRadians(this.getCollimatorAngle(n2).getValue()), point3fArray);
        Vector3f vector3f = l.a(this.getSourcePoint(), point3fArray[0]);
        Vector3f vector3f2 = l.a(point3fArray[1], (Point3f)this.getSourcePoint());
        vector3f.normalize();
        vector3f2.normalize();
        return new Vector3f[]{vector3f, vector3f2};
    }

    @Override
    public FloatQuantity.MMQuantity getEffectiveSourceCollimatorDistance() {
        if (this.getFirstMLC() != null) {
            return this.getFirstMLC().getSourceToCollimatorDistance();
        }
        OptionalDouble optionalDouble = this.collimators.stream().filter(collimator -> !collimator.isUsingDefaultSourceToCollimatorDistance()).mapToDouble(collimator -> collimator.getSourceToCollimatorDistance().getValue()).min();
        return new FloatQuantity.MMQuantity(optionalDouble.isPresent() ? (float)optionalDouble.getAsDouble() : DEFAULT_STC.getValue());
    }

    @Override
    public DicomPoint3f getCollimatorPosition() {
        DicomPoint3f dicomPoint3f = this.getSourcePoint();
        DicomPoint3f dicomPoint3f2 = this.getIsocenter();
        float f2 = this.getEffectiveSourceCollimatorDistance().getValue();
        float f3 = this.getSourceAxisDistance().getValue();
        Vector3f vector3f = l.a(dicomPoint3f, (Point3f)dicomPoint3f2);
        DicomPoint3f dicomPoint3f3 = dicomPoint3f.a();
        dicomPoint3f3.scaleAdd(f2 / f3, (Tuple3f)vector3f, (Tuple3f)dicomPoint3f);
        return dicomPoint3f3;
    }

    @Override
    public DicomPoint3f[] getCollimatorCorners() {
        return this.getCollimatorCorners(-1);
    }

    public DicomPoint3f[] getCollimatorCorners(int n2) {
        return this.getCollimatorCorners(this.getXJaws().getTimePointByIndex(n2), this.getYJaws().getTimePointByIndex(n2));
    }

    public DicomPoint3f[] getCollimatorCorners(float f2) {
        return this.getCollimatorCorners(this.getXJaws().getTimePointByMeterset(f2), this.getYJaws().getTimePointByMeterset(f2));
    }

    private DicomPoint3f[] getCollimatorCorners(Collimator.CollimatorTimepoint collimatorTimepoint, Collimator.CollimatorTimepoint collimatorTimepoint2) {
        Vector3f[] vector3fArray = this.getCollimatorAxes();
        DicomPoint3f dicomPoint3f = this.getCollimatorPosition();
        float[] fArray = collimatorTimepoint.getLeafJawPositions();
        float[] fArray2 = collimatorTimepoint2.getLeafJawPositions();
        float f2 = this.getEffectiveSourceCollimatorDistance().getValue();
        DicomPoint3f[] dicomPoint3fArray = new DicomPoint3f[4];
        float f3 = f2 / this.getSourceAxisDistance().getValue();
        for (int i2 = 0; i2 < 4; ++i2) {
            dicomPoint3fArray[i2] = dicomPoint3f.a();
            dicomPoint3fArray[i2].scaleAdd(f3 * fArray[i2 % 3 > 0 ? 1 : 0], (Tuple3f)vector3fArray[0], (Tuple3f)dicomPoint3f);
            dicomPoint3fArray[i2].scaleAdd(f3 * fArray2[1 - i2 / 2], (Tuple3f)vector3fArray[1], (Tuple3f)dicomPoint3fArray[i2]);
        }
        return dicomPoint3fArray;
    }

    @Override
    public Integer getRefBeamNumber() {
        return this.refBeamNumber;
    }

    @Override
    @d
    public FloatQuantity.MMQuantity getSourceSurfaceDistance() {
        return this.getSSD();
    }

    @Override
    public String getRtStSOP() {
        return this.rtstSop;
    }

    @Override
    public int getNumberOfFractions() {
        DicomElement dicomElement = this.getRtPlan().get(805961840);
        int n2 = 0;
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            int n3 = dicomObject.getInt(805961848);
            DicomElement dicomElement2 = dicomObject.get(806092804);
            for (int i3 = 0; i3 < dicomElement2.countItems(); ++i3) {
                DicomObject dicomObject2 = dicomElement2.getDicomObject(i3);
                if (dicomObject2.getInt(806092806) != this.getRefBeamNumber().intValue()) continue;
                n2 += n3;
            }
        }
        return n2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ReadHelper readHelper = new ReadHelper();
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.doseReferencePoints = (List)getField.get("doseReferencePoints", null);
        this.pvi = (Point3f.PointVolumeInfo)getField.get("pvi", null);
        this.rtstSop = (String)getField.get("rtstSop", null);
        this.refBeamNumber = getField.get("refBeamNumber", 0);
        Object object = getField.get("beamItemDcm", null);
        if (object instanceof SerializableDicomObject) {
            this.beamItemDcm = (SerializableDicomObject)object;
        } else {
            object = getField.get("beamItem", null);
            if (object instanceof DicomObject) {
                this.setBeamItem((DicomObject)object);
            } else {
                throw new IOException("Couldn't parse beamItem");
            }
        }
        Object object2 = getField.get("rtPlanDcm", null);
        if (object2 instanceof SerializableDicomObject) {
            this.rtPlanDcm = (SerializableDicomObject)object2;
        } else {
            object2 = getField.get("ds", null);
            if (object2 instanceof DicomObject) {
                this.setRtPlan((DicomObject)object2);
            } else {
                throw new IOException("Couldn't parse beamItem");
            }
        }
        this.initialize();
    }

    protected DicomObject getRtPlan() {
        return this.rtPlanDcm == null ? null : this.rtPlanDcm.dob;
    }

    protected void setRtPlan(DicomObject dicomObject) {
        this.rtPlanDcm = dicomObject == null ? null : new SerializableDicomObject(dicomObject);
    }

    protected DicomObject getBeamItem() {
        return this.beamItemDcm == null ? null : this.beamItemDcm.dob;
    }

    protected void setBeamItem(DicomObject dicomObject) {
        this.beamItemDcm = dicomObject == null ? null : new SerializableDicomObject(dicomObject);
    }

    @Override
    public boolean hasValidMLC() {
        Collimator.MultiLeafCollimator multiLeafCollimator = this.getFirstMLC();
        return multiLeafCollimator != null && multiLeafCollimator.getLeafOrientation() != null;
    }

    public boolean isStandardFluenceShaping() {
        DicomElement dicomElement = this.getBeamItem().get(805437520);
        if (dicomElement == null || dicomElement.countItems() == 0) {
            return true;
        }
        return "STANDARD".equalsIgnoreCase(dicomElement.getDicomObject(0).getString(805437521));
    }

    public static enum DosimeterUnit {
        MU,
        MINUTE;

    }
}

