/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtplan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mimvista.dicom.DicomSeries;
import com.mimvista.dicom.DicomSeriesStatic;
import com.mimvista.dicom.JsonDicomSeries;
import com.mimvista.dicom.SerializableDicomObject;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtplan.DicomBeamRecord;
import com.mimvista.dicom.rtplan.ReferencePoint;
import com.mimvista.dicom.rtplan.ReportableRtplanState;
import com.mimvista.dicom.rtplan.RtplanValidator;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.state.ReadHelper;
import com.mimvista.util.MIMSerializable;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.viewer.RTDoseSeriesInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public abstract class DicomRtPlan
implements MIMSerializable {
    private static final long serialVersionUID = 1L;
    protected SerializableDicomObject rtPlanDcm;
    Point3f.PointVolumeInfo pvi;
    String sop;
    String planningImageUID;
    List<DicomBeamRecord> beamRecords = Lists.newArrayList();
    List<ReferencePoint> doseReferencePoints = Lists.newArrayList();
    DoseValue rxDose;
    private boolean isValidated;
    protected List<String> errorMessages = Lists.newArrayList();
    protected List<RTDoseSeriesInfo.RxDose> rxDoseList = Lists.newArrayList();

    public DicomRtPlan(DicomObject dicomObject, Point3f.PointVolumeInfo pointVolumeInfo, String string) {
        this.errorMessages.addAll(RtplanValidator.validateRtplanDicom(dicomObject));
        this.isValidated = this.errorMessages.size() <= 0;
        this.setRtPlan(dicomObject);
        this.pvi = pointVolumeInfo;
        this.sop = this.getRtPlan().getString(524312);
        this.planningImageUID = string;
        DicomElement dicomElement = dicomObject.get(805961904);
        this.parseDoseReferenceSequence();
        String string2 = this.getReferencedRtstructSop();
        if (dicomElement != null) {
            for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                String string3 = dicomObject2.getString(805961924, "");
                String string4 = dicomObject2.getString(805961934, "");
                if (!"TREATMENT".equals(string4)) continue;
                DicomBeamRecord dicomBeamRecord = new DicomBeamRecord(dicomObject, i2, string2, pointVolumeInfo, this.doseReferencePoints);
                this.beamRecords.add(dicomBeamRecord);
            }
        }
    }

    public boolean isValidated() {
        return this.isValidated;
    }

    public void invalidate() {
        this.isValidated = false;
    }

    public String getReferencedRtstructSop() {
        DicomElement dicomElement = this.getRtPlan().get(806092896);
        if (dicomElement == null || dicomElement.countItems() < 1) {
            return null;
        }
        return dicomElement.getDicomObject(0).getString(528725);
    }

    public String getSeriesDescription() {
        return this.getRtPlan().getString(528446, "");
    }

    public String getStudyDescription() {
        return this.getRtPlan().getString(528432);
    }

    public String getPlanLabel() {
        return this.getRtPlan().getString(805961730, "");
    }

    public String getTime() {
        return this.getRtPlan().getString(805961735, "");
    }

    public String getDate() {
        return this.getRtPlan().getString(805961734, "");
    }

    public Date getDateTime() {
        JsonDicomSeries jsonDicomSeries = new JsonDicomSeries(this.getRtPlan());
        return DicomSeriesStatic.findFirstDateTime((DicomSeries)jsonDicomSeries, 805961734);
    }

    public String getPlanningVolumeSeriesUID() {
        return this.planningImageUID;
    }

    private static List<String> getReferencedRtstSOPs(DicomObject dicomObject) {
        ArrayList arrayList = Lists.newArrayList();
        DicomElement dicomElement = dicomObject.get(806092896);
        if (dicomElement != null) {
            for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                String string;
                DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                if (!"1.2.840.10008.5.1.4.1.1.481.3".equals(dicomObject2.getString(528720, "")) || cn.h(string = dicomObject2.getString(528725, ""))) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static List<RTDoseSeriesInfo.RxDose> parseRxDoses(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.get(805961744);
        List<String> list = DicomRtPlan.getReferencedRtstSOPs(dicomObject);
        ArrayList arrayList = Lists.newArrayList();
        if (dicomElement == null) {
            return Lists.newArrayList();
        }
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            RTDoseSeriesInfo.RxDose rxDose;
            Cloneable cloneable;
            Object object;
            DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
            String string = dicomObject2.getString(805961748, "");
            float f2 = dicomObject2.getFloat(805961766, 0.0f);
            if (f2 == 0.0f) continue;
            if (string.equalsIgnoreCase("SITE")) {
                ay.e("We found the SITE Rx dose: " + f2);
                object = new DoseValue();
                ((DoseValue)object).setValueInGy(f2);
                cloneable = new RTDoseSeriesInfo.RxDose((DoseValue)object, RTDoseSeriesInfo.RxType.PRESCRIPTION);
                arrayList.add(cloneable);
                continue;
            }
            if (string.equalsIgnoreCase("POINT") || string.equalsIgnoreCase("VOLUME")) {
                int n2 = dicomObject2.getInt(805699716, -1);
                if (n2 < 0 || list.isEmpty()) continue;
                ay.e("We found the VOLUME/POINT Rx dose: " + f2);
                cloneable = new DoseValue();
                ((DoseValue)cloneable).setValueInGy(f2);
                rxDose = new RTDoseSeriesInfo.RxDose((DoseValue)cloneable, RTDoseSeriesInfo.RxType.PRESCRIPTION, n2);
                for (String string2 : list) {
                    rxDose.a(string2);
                }
                arrayList.add(rxDose);
                continue;
            }
            if (!string.equalsIgnoreCase("COORDINATES") || (object = (Object)dicomObject2.getFloats(805961752, new float[0])) == null || ((Object)object).length != 3) continue;
            ay.e("We found the COORDINATES Rx dose: " + f2);
            cloneable = new DoseValue();
            ((DoseValue)cloneable).setValueInGy(f2);
            rxDose = new RTDoseSeriesInfo.RxDose((DoseValue)cloneable, RTDoseSeriesInfo.RxType.PRESCRIPTION, new Point3f((float[])object));
            arrayList.add(rxDose);
        }
        return arrayList;
    }

    public int getTotalNumberOfFractions() {
        DicomElement dicomElement = this.getRtPlan().get(805961840);
        if (dicomElement == null) {
            throw new RuntimeException("Can't find the number of fractions");
        }
        int n2 = 0;
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            n2 += dicomElement.getDicomObject(i2).getInt(805961848);
        }
        return n2;
    }

    public Point3f.PointVolumeInfo getPVI() {
        return this.pvi;
    }

    public String getSop() {
        return this.sop;
    }

    public ImmutableList<ReportableRtplanState.BeamRecord> getBeamRecords() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(this.beamRecords);
        return ImmutableList.copyOf((Collection)arrayList);
    }

    public DoseValue getRxDose() {
        return this.rxDose;
    }

    public List<RTDoseSeriesInfo.RxDose> getAllRxDoses() {
        return this.rxDoseList;
    }

    public List<String> getErrorMessages() {
        return Lists.newArrayList(this.errorMessages);
    }

    public DicomObject getDicomObject() {
        return this.getRtPlan();
    }

    private final void parseDoseReferenceSequence() {
        DicomElement dicomElement = this.getRtPlan().get(805961744);
        this.doseReferencePoints.clear();
        if (dicomElement == null) {
            return;
        }
        List<RTDoseSeriesInfo.RxDose> list = DicomRtPlan.parseRxDoses(this.getRtPlan());
        for (RTDoseSeriesInfo.RxDose rxDose : list) {
            if (!rxDose.h()) continue;
            this.rxDose = rxDose.c();
        }
        this.rxDoseList = list;
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            RTDoseSeriesInfo.RxDose rxDose;
            rxDose = dicomElement.getDicomObject(i2);
            String string = rxDose.getString(805961748);
            if (!"COORDINATES".equalsIgnoreCase(string)) continue;
            float[] fArray = rxDose.getFloats(805961752);
            DicomPoint3f dicomPoint3f = new DicomPoint3f(fArray, this.pvi);
            ReferencePoint referencePoint = new ReferencePoint(dicomPoint3f, null);
            referencePoint.setId(rxDose.getString(805961750));
            this.doseReferencePoints.add(referencePoint);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ReadHelper readHelper = new ReadHelper();
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        readHelper.a(getField, (Object)this);
        this.rtPlanDcm = ReadHelper.a(getField, "ds", this.rtPlanDcm, SerializableDicomObject.RAW_DICOM_OBJ_CONVERTOR);
    }

    protected DicomObject getRtPlan() {
        return this.rtPlanDcm == null ? null : this.rtPlanDcm.dob;
    }

    protected void setRtPlan(DicomObject dicomObject) {
        this.rtPlanDcm = dicomObject == null ? null : new SerializableDicomObject(dicomObject);
    }
}

