/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtplan;

import com.mimvista.report.codes.Units;
import com.mimvista.report.comprehensive.nodes.ReportNodeFactory;
import java.io.Serializable;

public abstract class FloatQuantity
implements Serializable {
    private static final long serialVersionUID = 1L;
    float value;

    public abstract Units getUnit();

    public FloatQuantity(float f2) {
        this.value = f2;
    }

    public float getValue() {
        return this.value;
    }

    public String toString() {
        return this.value + " " + this.getUnit().a();
    }

    public ReportNodeFactory.MeasuredValue getMeasuredValue() {
        return new ReportNodeFactory.MeasuredValue(Float.valueOf(this.getValue()), this.getUnit().getCode());
    }

    public static class GrayQuantity
    extends FloatQuantity {
        public GrayQuantity(float f2) {
            super(f2);
        }

        @Override
        public Units getUnit() {
            return Units.h;
        }
    }

    public static class MonitorUnitQuantity
    extends FloatQuantity {
        public MonitorUnitQuantity(float f2) {
            super(f2);
        }

        @Override
        public Units getUnit() {
            return Units.m;
        }
    }

    public static class AngleDegQuantity
    extends FloatQuantity {
        public AngleDegQuantity(float f2) {
            super(f2);
        }

        @Override
        public Units getUnit() {
            return Units.l;
        }
    }

    public static class CMQuantity
    extends FloatQuantity {
        public CMQuantity(float f2) {
            super(f2);
        }

        @Override
        public Units getUnit() {
            return Units.a;
        }

        public MMQuantity inMM() {
            return new MMQuantity(this.getValue() * 10.0f);
        }
    }

    public static class MMQuantity
    extends FloatQuantity {
        public MMQuantity(float f2) {
            super(f2);
        }

        @Override
        public Units getUnit() {
            return Units.b;
        }

        public CMQuantity inCM() {
            return new CMQuantity(this.getValue() / 10.0f);
        }
    }

    public static class MuPerMinuteQuantity
    extends FloatQuantity {
        public MuPerMinuteQuantity(float f2) {
            super(f2);
        }

        @Override
        public Units getUnit() {
            return Units.n;
        }
    }

    public static class MVQuantity
    extends EnergyQuantity {
        public MVQuantity(float f2) {
            super(f2);
        }

        @Override
        public Units getUnit() {
            return Units.p;
        }
    }

    public static class MeVQuantity
    extends EnergyQuantity {
        public MeVQuantity(float f2) {
            super(f2);
        }

        @Override
        public Units getUnit() {
            return Units.o;
        }
    }

    public static abstract class EnergyQuantity
    extends FloatQuantity {
        public EnergyQuantity(float f2) {
            super(f2);
        }
    }
}

