/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtplan;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mimvista.dicom.rtplan.Bolus;
import com.mimvista.dicom.rtplan.DicomBeamRecord;
import com.mimvista.dicom.rtplan.FloatQuantity;
import com.mimvista.dicom.rtplan.ReferencePoint;
import com.mimvista.dicom.rtplan.ReportableRtplanState;
import com.mimvista.dicom.rtplan.RtstSessionStateManager;
import com.mimvista.dicom.rtplan.RtstructSessionState;
import com.mimvista.dose.bed.BEDSerializationUtil;
import com.mimvista.internals.Contour;
import com.mimvista.internals.DynamicVolumeRef;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.contourtools.a.c;
import com.mimvista.util.MIMSerializable;
import com.mimvista.util.ay;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToDoubleFunction;

public class RtplanDerivedValuesCalculator
implements MIMSerializable {
    private DynamicVolumeRef volume;
    private Contour wbc;

    public RtplanDerivedValuesCalculator(DynamicVolumeRef dynamicVolumeRef, Contour contour) {
        this.volume = dynamicVolumeRef;
        this.wbc = contour;
    }

    public MemoizedDerivedPlanInfo pullOutValues(ReportableRtplanState reportableRtplanState) {
        MemoizedDerivedPlanInfo memoizedDerivedPlanInfo = new MemoizedDerivedPlanInfo();
        UnmodifiableIterator unmodifiableIterator = reportableRtplanState.getBeamRecords().iterator();
        while (unmodifiableIterator.hasNext()) {
            ReportableRtplanState.BeamRecord beamRecord;
            ReportableRtplanState.BeamRecord beamRecord2 = beamRecord = (ReportableRtplanState.BeamRecord)unmodifiableIterator.next();
            MemoizedBeamInfo memoizedBeamInfo = new MemoizedBeamInfo();
            for (Bolus bolus : beamRecord2.getBoli()) {
                MIMSerializable mIMSerializable = new MemoizedBolusInfo();
                ((MemoizedBolusInfo)mIMSerializable).refRoiNumber = bolus.getRefRoiNumber();
                ((MemoizedBolusInfo)mIMSerializable).pathLength = bolus.getPathLengthInBolus();
                ((MemoizedBolusInfo)mIMSerializable).ssbDistance = bolus.getSourceToBolusDistance();
                ((MemoizedBolusInfo)mIMSerializable).approvalStatus = bolus.getApprovalStatus();
                memoizedBeamInfo.bolusInfo.put(bolus.getRefRoiNumber(), (MemoizedBolusInfo)mIMSerializable);
            }
            int n2 = 0;
            for (MIMSerializable mIMSerializable : beamRecord2.getReferencePoints()) {
                MemoizedRefPointInfo memoizedRefPointInfo = new MemoizedRefPointInfo();
                memoizedRefPointInfo.depth = ((ReferencePoint)mIMSerializable).getDepth();
                memoizedRefPointInfo.pssd = ((ReferencePoint)mIMSerializable).getPSSD();
                memoizedRefPointInfo.index = n2;
                memoizedBeamInfo.refPointInfo.add(memoizedRefPointInfo);
            }
            memoizedBeamInfo.refBeamNumber = beamRecord2.getRefBeamNumber();
            memoizedBeamInfo.ssd = beamRecord.getSourceSurfaceDistance();
            memoizedDerivedPlanInfo.beams.put(memoizedBeamInfo.refBeamNumber, memoizedBeamInfo);
        }
        return memoizedDerivedPlanInfo;
    }

    public static void writeValuesIntoPlan(ReportableRtplanState reportableRtplanState, MemoizedDerivedPlanInfo memoizedDerivedPlanInfo) {
        for (ReportableRtplanState.BeamRecord beamRecord : reportableRtplanState.getBeamRecords()) {
            MIMSerializable mIMSerializable;
            MemoizedBeamInfo memoizedBeamInfo = memoizedDerivedPlanInfo.beams.get(beamRecord.getRefBeamNumber());
            if (memoizedBeamInfo == null) continue;
            for (MIMSerializable mIMSerializable2 : beamRecord.getBoli()) {
                mIMSerializable = memoizedBeamInfo.bolusInfo.get(((Bolus)mIMSerializable2).getRefRoiNumber());
                if (mIMSerializable == null) continue;
                ((Bolus)mIMSerializable2).setPathLengthInBolus(mIMSerializable.pathLength);
                ((Bolus)mIMSerializable2).setSourceToBolusDistance(mIMSerializable.ssbDistance);
                ((Bolus)mIMSerializable2).setApprovalStatus(mIMSerializable.approvalStatus);
            }
            for (int i2 = 0; i2 < beamRecord.getReferencePoints().size(); ++i2) {
                MIMSerializable mIMSerializable2;
                mIMSerializable2 = beamRecord.getReferencePoints().get(i2);
                mIMSerializable = memoizedBeamInfo.refPointInfo.get(i2);
                ((ReferencePoint)mIMSerializable2).setDepth(((MemoizedRefPointInfo)mIMSerializable).depth);
                ((ReferencePoint)mIMSerializable2).setPSSD(((MemoizedRefPointInfo)mIMSerializable).pssd);
            }
            DicomBeamRecord dicomBeamRecord = (DicomBeamRecord)beamRecord;
            dicomBeamRecord.setSSD(memoizedBeamInfo.ssd);
        }
    }

    public void calculateStatsForBeam(DicomBeamRecord dicomBeamRecord) {
        this.calculateBolusStats(dicomBeamRecord);
        this.calculatePointSourceSurfaceDistances(dicomBeamRecord);
        dicomBeamRecord.setSSD(this.calculateSourceToSurfaceDistance(dicomBeamRecord));
    }

    private void calculateBolusStats(ReportableRtplanState.BeamRecord beamRecord) {
        for (Bolus bolus : beamRecord.getBoli()) {
            RtstructSessionState rtstructSessionState = RtstSessionStateManager.getForSession(this.volume.a()).getState(beamRecord.getRtStSOP());
            RtstructSessionState.ContourInfo contourInfo = rtstructSessionState.getContourInfo(bolus.getRefRoiNumber());
            Contour contour = contourInfo.getCompressedContour().a(this.volume.c());
            MetricPoint3f metricPoint3f = beamRecord.getIsocenter().c();
            MetricPoint3f metricPoint3f2 = beamRecord.getSourcePoint().c();
            MetricPoint3f metricPoint3f3 = null;
            MetricPoint3f metricPoint3f4 = null;
            try {
                c c2 = new c(contour, metricPoint3f2, metricPoint3f);
                metricPoint3f3 = c2.a();
                c2 = new c(contour, metricPoint3f, metricPoint3f2);
                metricPoint3f4 = c2.a();
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error computing path points on bolus surface", throwable, this);
            }
            float f2 = Float.NaN;
            float f3 = Float.NaN;
            if (metricPoint3f3 != null) {
                f2 = metricPoint3f2.distance(metricPoint3f3);
            }
            if (metricPoint3f3 != null && metricPoint3f4 != null) {
                f3 = metricPoint3f3.distance(metricPoint3f4);
            }
            bolus.setSourceToBolusDistance(new FloatQuantity.MMQuantity(f2));
            bolus.setPathLengthInBolus(new FloatQuantity.MMQuantity(f3));
            bolus.setApprovalStatus(rtstructSessionState.getApprovalStatus());
        }
    }

    private void calculatePointSourceSurfaceDistances(ReportableRtplanState.BeamRecord beamRecord) {
        for (ReferencePoint referencePoint : beamRecord.getReferencePoints()) {
            MetricPoint3f metricPoint3f4;
            Object object;
            DicomPoint3f dicomPoint3f = referencePoint.getLocation();
            Contour contour2 = this.wbc;
            MetricPoint3f metricPoint3f5 = dicomPoint3f.c();
            MetricPoint3f metricPoint3f6 = beamRecord.getSourcePoint().c();
            MetricPoint3f metricPoint3f7 = null;
            try {
                object = new c(contour2, metricPoint3f6, metricPoint3f5);
                metricPoint3f7 = ((c)object).a();
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error calculating point-source-to-surface distance", throwable, this);
            }
            if (metricPoint3f7 == null) continue;
            object = RtstSessionStateManager.getForSession(this.volume.a()).getState(beamRecord.getRtStSOP());
            Optional<MetricPoint3f> optional = beamRecord.getBoli().stream().map(bolus -> bolus.getRefRoiNumber()).map(((RtstructSessionState)object)::getContourInfo).map(contourInfo -> contourInfo.getCompressedContour().a(this.volume.c())).map(contour -> new c((Contour)contour, metricPoint3f6, metricPoint3f5).a()).filter(metricPoint3f -> metricPoint3f != null).min((metricPoint3f2, metricPoint3f3) -> Float.compare(metricPoint3f2.distance(metricPoint3f6), metricPoint3f3.distance(metricPoint3f6)));
            if (optional.isPresent()) {
                metricPoint3f7 = optional.get();
            }
            if ((metricPoint3f4 = new c(contour2, metricPoint3f6, metricPoint3f7).a(true)) != null && metricPoint3f4.distance(metricPoint3f6) < metricPoint3f7.distance(metricPoint3f6)) {
                metricPoint3f7 = metricPoint3f4;
            }
            referencePoint.setDepth(new FloatQuantity.MMQuantity(metricPoint3f7.distance(metricPoint3f5)));
            referencePoint.setPSSD(new FloatQuantity.MMQuantity(metricPoint3f7.distance(metricPoint3f6)));
        }
    }

    private float getPathLengthInBolus(ReportableRtplanState.BeamRecord beamRecord, MetricPoint3f metricPoint3f) {
        ToDoubleFunction<Bolus> toDoubleFunction;
        if ((double)metricPoint3f.distance(beamRecord.getIsocenter().c()) < 0.001) {
            toDoubleFunction = bolus -> bolus.getPathLengthInBolus().getValue();
        } else {
            RtstructSessionState rtstructSessionState = RtstSessionStateManager.getForSession(this.volume.a()).getState(beamRecord.getRtStSOP());
            toDoubleFunction = bolus -> {
                Contour contour = rtstructSessionState.getContourInfo(bolus.getRefRoiNumber()).getCompressedContour().a(this.volume.c());
                MetricPoint3f metricPoint3f2 = beamRecord.getSourcePoint().c();
                MetricPoint3f metricPoint3f3 = null;
                MetricPoint3f metricPoint3f4 = null;
                try {
                    c c2 = new c(contour, metricPoint3f2, metricPoint3f);
                    metricPoint3f3 = c2.a();
                    c2 = new c(contour, metricPoint3f, metricPoint3f2);
                    metricPoint3f4 = c2.a();
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Error computing path points on bolus surface", throwable, this);
                }
                if (metricPoint3f3 != null && metricPoint3f4 != null) {
                    return metricPoint3f3.distance(metricPoint3f4);
                }
                return Double.NaN;
            };
        }
        float f2 = 0.0f;
        if (!beamRecord.getBoli().isEmpty()) {
            f2 = (float)beamRecord.getBoli().stream().mapToDouble(toDoubleFunction).sum();
        }
        return f2;
    }

    public FloatQuantity.MMQuantity calculateSourceToSurfaceDistance(DicomBeamRecord dicomBeamRecord) {
        float f2 = dicomBeamRecord.getFirstControlPoint().getFloat(805962032, Float.NaN);
        if (!Float.isNaN(f2)) {
            return new FloatQuantity.MMQuantity(f2);
        }
        Contour contour = this.wbc;
        MetricPoint3f metricPoint3f = dicomBeamRecord.getIsocenter().c();
        MetricPoint3f metricPoint3f2 = dicomBeamRecord.getSourcePoint().c();
        MetricPoint3f metricPoint3f3 = null;
        try {
            c c2 = new c(contour, metricPoint3f2, metricPoint3f);
            metricPoint3f3 = c2.a();
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error calculating source-to-surface distance", throwable, this);
        }
        if (metricPoint3f3 == null) {
            return null;
        }
        float f3 = metricPoint3f3.distance(metricPoint3f2) - this.getPathLengthInBolus(dicomBeamRecord, dicomBeamRecord.getIsocenter().c());
        ay.a((Object)("Source-to-Surface Distance: " + f3), this);
        if (!Float.isNaN(f2)) {
            ay.a((Object)("Stored: " + f2 + "mm Computed: " + f3 + "mm Diff: " + (f3 - f2) + "mm"), this);
        }
        return new FloatQuantity.MMQuantity(f3);
    }

    public static class MemoizedDerivedPlanInfo
    implements MIMSerializable {
        Map<Integer, MemoizedBeamInfo> beams = Maps.newHashMap();

        public String serialize() {
            return BEDSerializationUtil.b().toJson((Object)this, MemoizedDerivedPlanInfo.class);
        }

        public static MemoizedDerivedPlanInfo deserialize(String string) {
            return (MemoizedDerivedPlanInfo)BEDSerializationUtil.b().fromJson(string, MemoizedDerivedPlanInfo.class);
        }
    }

    public static class MemoizedBeamInfo
    implements MIMSerializable {
        Map<Integer, MemoizedBolusInfo> bolusInfo = Maps.newHashMap();
        List<MemoizedRefPointInfo> refPointInfo = Lists.newArrayList();
        FloatQuantity.MMQuantity ssd;
        int refBeamNumber;
    }

    public static class MemoizedRefPointInfo
    implements MIMSerializable {
        int index;
        FloatQuantity.MMQuantity pssd;
        FloatQuantity.MMQuantity depth;
    }

    public static class MemoizedBolusInfo
    implements MIMSerializable {
        int refRoiNumber;
        FloatQuantity.MMQuantity pathLength;
        FloatQuantity.MMQuantity ssbDistance;
        String approvalStatus;
    }
}

