/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtplan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.commands.workflow.b;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtplan.Bolus;
import com.mimvista.dicom.rtplan.DicomBeamRecord;
import com.mimvista.dicom.rtplan.DicomRtPlan;
import com.mimvista.dicom.rtplan.ReportableRtplanState;
import com.mimvista.dicom.rtplan.RtplanDerivedValuesCalculator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.internals.CollimatorState;
import com.mimvista.internals.Contour;
import com.mimvista.internals.DynamicVolumeRef;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SimpleContour;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.Session;
import com.mimvista.mui.e;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.OverlayishBase;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.contourtools.o;
import com.mimvista.preferencesNew.PlanReviewPrefs;
import com.mimvista.report.data.c.c;
import com.mimvista.state.SerializedSessionStateObject;
import com.mimvista.state.f;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.d.a;
import com.mimvista.viewer.RTDoseSeriesInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.dcm4che2.data.DicomObject;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class RtplanSessionState
extends DicomRtPlan
implements b,
ReportableRtplanState,
SerializedSessionStateObject<RtplanSessionState>,
Serializable {
    private static final long serialVersionUID = 1L;
    DynamicVolumeRef volume;
    Contour wbc;
    private String workflowName;
    private RtplanDerivedValuesCalculator.MemoizedDerivedPlanInfo derivedPlanInfo;
    ReportableRtplanState.BeamRecord currentlySelectedBeam;
    Map<ReportableRtplanState.BeamRecord, Boolean> beamVisibilityMap;
    transient a<BeamSelectedListener> beamSelectionChangedCallbackManager;
    transient a<BeamVisibilityListener> beamVisibilityChangedCallbackManager;
    transient a<BeamDataListener> beamDataChangedCallbackManager;
    transient a<FinishingTouchListener> finishingTouchesCallbackManager;
    Map<ReportableRtplanState.BeamRecord, DynamicVolumeRef> drrMap;
    Map<ReportableRtplanState.BeamRecord, CollimatorState> collimatorStateMap;
    private boolean alwaysShowingSelectedBeam;
    private boolean showBeamLabelsOnScreen;

    public RtplanSessionState(DynamicVolumeRef dynamicVolumeRef, DicomObject dicomObject) {
        block9: {
            super(dicomObject, new Point3f.PointVolumeInfo(dynamicVolumeRef.c()), dynamicVolumeRef.c().I().ag());
            this.currentlySelectedBeam = null;
            this.beamVisibilityMap = Maps.newHashMap();
            this.beamSelectionChangedCallbackManager = new a(false, true, true, false);
            this.beamVisibilityChangedCallbackManager = new a(false, true, true, false);
            this.beamDataChangedCallbackManager = new a(false, true, true, false);
            this.finishingTouchesCallbackManager = new a(false, true, true, false);
            this.drrMap = Maps.newHashMap();
            this.collimatorStateMap = Maps.newHashMap();
            this.alwaysShowingSelectedBeam = false;
            this.showBeamLabelsOnScreen = PlanReviewPrefs.showBeamLabelsByDefault.getValue();
            this.setRtPlan(dicomObject);
            this.volume = dynamicVolumeRef;
            try {
                this.wbc = this.findWholeBodyContourOverlay().aq();
            }
            catch (Exception exception) {
                if (!this.isValidated()) break block9;
                ay.c((Object)("Couldn't find a whole-body contour for the plan: " + this.getSeriesDescription() + ". Generating one automatically..."), this);
                Iterator iterator = this.volume.b();
                Serializable serializable = com.mimvista.mui.overlays.f.a((ViewController)((Object)iterator), dynamicVolumeRef.c());
                serializable.a(OverlayishBase.InterpretedType.f);
                serializable.c(OverlayishBase.InterpretedType.f.getExternalizedString());
                serializable.n(true);
                int n2 = ((ImageCube)((SimpleImageVolume)((Object)((ViewController)((Object)iterator)).aw())).ad()).e();
                o.a(iterator, (VolumetricContourOverlayish)serializable, false, 0, n2 - 1, null, false);
                HashSet hashSet = Sets.newHashSet();
                for (ReportableRtplanState.BeamRecord serializable2 : this.beamRecords) {
                    for (Bolus bolus : serializable2.getBoli()) {
                        hashSet.add(bolus.getRefRoiNumber());
                    }
                }
                if (!hashSet.isEmpty()) {
                    for (VolumetricContourOverlayish volumetricContourOverlayish : ((ViewController)((Object)iterator)).ba().a(VolumetricContourOverlayish.class, true, false)) {
                        if (!hashSet.contains(volumetricContourOverlayish.i())) continue;
                        serializable.aq().e((SimpleContour)volumetricContourOverlayish.aq());
                    }
                }
                ((ViewController)((Object)iterator)).ba().a((Overlayish)serializable, false);
                this.wbc = serializable.G().aq();
                BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.b, MIMFormat.a(Messages.a("PlanReview", "PR_AUTOGEN_WBC"), serializable.getName()), new Notification.a(dynamicVolumeRef.b()));
                u.b().c(basicNotification);
            }
        }
        RtplanDerivedValuesCalculator rtplanDerivedValuesCalculator = new RtplanDerivedValuesCalculator(this.volume, this.wbc);
        for (Serializable serializable : this.beamRecords) {
            rtplanDerivedValuesCalculator.calculateStatsForBeam((DicomBeamRecord)serializable);
        }
        this.derivedPlanInfo = rtplanDerivedValuesCalculator.pullOutValues(this);
        if (this.getBeamRecords().size() > 0) {
            this.currentlySelectedBeam = (ReportableRtplanState.BeamRecord)this.getBeamRecords().get(0);
            for (Serializable serializable : this.beamRecords) {
                this.beamVisibilityMap.put((ReportableRtplanState.BeamRecord)serializable, true);
            }
        }
    }

    public ReportableRtplanState.BeamRecord getCurrentlySelectedBeam() {
        return this.currentlySelectedBeam;
    }

    @Override
    public void preventLambdas() {
    }

    public List<ReportableRtplanState.BeamRecord> getCurrentlyVisibleBeams() {
        return this.beamVisibilityMap.entrySet().stream().filter(entry -> (Boolean)entry.getValue()).map(entry -> (ReportableRtplanState.BeamRecord)entry.getKey()).collect(Collectors.toList());
    }

    public DynamicVolumeRef getDRR(ReportableRtplanState.BeamRecord beamRecord) {
        return this.drrMap.get(beamRecord);
    }

    public ReportableRtplanState.BeamRecord getBeam(ViewController viewController) {
        for (ReportableRtplanState.BeamRecord beamRecord : this.beamRecords) {
            if (this.drrMap.get(beamRecord) == null || this.drrMap.get(beamRecord).b() != viewController.aT()) continue;
            return beamRecord;
        }
        return null;
    }

    public boolean getBeamVisiblity(ReportableRtplanState.BeamRecord beamRecord) {
        return this.beamVisibilityMap.get(beamRecord);
    }

    public CollimatorState getCollimatorState(ReportableRtplanState.BeamRecord beamRecord) {
        CollimatorState collimatorState = this.collimatorStateMap.get(beamRecord);
        if (collimatorState == null) {
            ay.c((Object)("No collimator state was found for the beam with Beam Number " + beamRecord.getRefBeamNumber() + ". Returning null."), this);
        }
        return collimatorState;
    }

    public boolean isAlwaysShowingSelectedBeam() {
        return this.alwaysShowingSelectedBeam;
    }

    public void setAlwaysShowingSelectedBeam(boolean bl2) {
        this.alwaysShowingSelectedBeam = bl2;
    }

    public boolean isShowBeamLabelsOnScreen() {
        return this.showBeamLabelsOnScreen;
    }

    public void setShowBeamLabelsOnScreen(boolean bl2) {
        this.showBeamLabelsOnScreen = bl2;
    }

    public void setBeamVisiblity(final ReportableRtplanState.BeamRecord beamRecord, final boolean bl2) {
        if (this.beamVisibilityMap.get(beamRecord) == bl2) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                RtplanSessionState.this.beamVisibilityMap.put(beamRecord, bl2);
                RtplanSessionState.this.invokeVisibilityChangedListeners(new BeamVisibilityEvent(beamRecord, bl2));
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void fireOverlayChangedListeners(ReportableRtplanState.BeamRecord beamRecord) {
        SwingUtilities.invokeLater(() -> this.invokeDataChangedListeners(new BeamDataEvent(beamRecord)));
    }

    public void fireSelectionChangedListeners() {
        SwingUtilities.invokeLater(() -> this.invokeSelectionChangedListeners(new BeamSelectedEvent(this.currentlySelectedBeam, null)));
    }

    public void setSelectedBeam(final ReportableRtplanState.BeamRecord beamRecord) {
        if (beamRecord == this.currentlySelectedBeam) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ReportableRtplanState.BeamRecord beamRecord2 = RtplanSessionState.this.getCurrentlySelectedBeam();
                RtplanSessionState.this.currentlySelectedBeam = beamRecord;
                RtplanSessionState.this.invokeSelectionChangedListeners(new BeamSelectedEvent(beamRecord2, beamRecord));
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addVisiblityChangedListener(BeamVisibilityListener beamVisibilityListener) {
        this.beamVisibilityChangedCallbackManager.d(beamVisibilityListener);
    }

    public void removeVisiblityChangedListener(BeamVisibilityListener beamVisibilityListener) {
        this.beamVisibilityChangedCallbackManager.e(beamVisibilityListener);
    }

    public void addSelectionChangedListener(BeamSelectedListener beamSelectedListener) {
        this.beamSelectionChangedCallbackManager.d(beamSelectedListener);
    }

    public void removeSelectionChangedListener(BeamSelectedListener beamSelectedListener) {
        this.beamSelectionChangedCallbackManager.e(beamSelectedListener);
    }

    public void addDataChangedListener(BeamDataListener beamDataListener) {
        this.beamDataChangedCallbackManager.d(beamDataListener);
    }

    public void removeDataChangedListener(BeamDataListener beamDataListener) {
        this.beamDataChangedCallbackManager.e(beamDataListener);
    }

    public void addFinishingTouchListener(FinishingTouchListener finishingTouchListener) {
        this.finishingTouchesCallbackManager.d(finishingTouchListener);
    }

    public void removeDataFinishingTouchListener(FinishingTouchListener finishingTouchListener) {
        this.finishingTouchesCallbackManager.e(finishingTouchListener);
    }

    private void invokeVisibilityChangedListeners(final BeamVisibilityEvent beamVisibilityEvent) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                RtplanSessionState.this.beamVisibilityChangedCallbackManager.b(beamVisibilityListener -> beamVisibilityListener.actionPerformed(beamVisibilityEvent));
                RtplanSessionState.this.finishingTouchesCallbackManager.b(finishingTouchListener -> finishingTouchListener.actionPerformed(new FinishingTouchEvent(beamVisibilityEvent)));
            }
        });
    }

    private void invokeSelectionChangedListeners(final BeamSelectedEvent beamSelectedEvent) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                RtplanSessionState.this.beamSelectionChangedCallbackManager.b(beamSelectedListener -> beamSelectedListener.actionPerformed(beamSelectedEvent));
                RtplanSessionState.this.finishingTouchesCallbackManager.b(finishingTouchListener -> finishingTouchListener.actionPerformed(new FinishingTouchEvent(beamSelectedEvent)));
            }
        });
    }

    private void invokeDataChangedListeners(final BeamDataEvent beamDataEvent) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                RtplanSessionState.this.beamDataChangedCallbackManager.b(beamDataListener -> beamDataListener.actionPerformed(beamDataEvent));
                RtplanSessionState.this.finishingTouchesCallbackManager.b(finishingTouchListener -> finishingTouchListener.actionPerformed(new FinishingTouchEvent(beamDataEvent)));
            }
        });
    }

    public VolumetricContourOverlayish findWholeBodyContourOverlay() {
        List<AbstractContourOverlayish> list = this.volume.c().n().D();
        Optional<AbstractContourOverlayish> optional = list.stream().filter(abstractContourOverlayish -> abstractContourOverlayish.w()).filter(abstractContourOverlayish -> abstractContourOverlayish.z() == OverlayishBase.InterpretedType.f).findFirst();
        if (optional.isPresent()) {
            return optional.get().G();
        }
        List list2 = Lists.newArrayList((Object[])PlanReviewPrefs.wholeBodyContourKeywords.getValue()).stream().map(string -> string.toUpperCase()).collect(Collectors.toList());
        optional = list.stream().filter(abstractContourOverlayish -> abstractContourOverlayish.w()).filter(abstractContourOverlayish -> list2.stream().anyMatch(string -> abstractContourOverlayish.getName().toUpperCase().contains((CharSequence)string))).findFirst();
        if (optional.isPresent()) {
            return optional.get().G();
        }
        throw new RuntimeException("Can't find the whole-body contour for this RTPlan");
    }

    public void addDRR(ReportableRtplanState.BeamRecord beamRecord, ViewController viewController) {
        this.drrMap.put(beamRecord, new DynamicVolumeRef(viewController));
        this.collimatorStateMap.put(beamRecord, new CollimatorState((DicomBeamRecord)beamRecord, this.getSop(), viewController.g()));
        SwingUtilities.invokeLater(() -> e.a((DicomBeamRecord)beamRecord, viewController));
    }

    @Override
    public RtplanSessionState deserialize(Session session) {
        return this;
    }

    @Override
    public String getNameFromWorkflow() {
        return this.workflowName;
    }

    @Override
    public void setNameFromWorkflow(String string) {
        this.workflowName = string;
    }

    public ViewController3D getPlanningVolumeAsRootVc() {
        return this.volume.b().aT().bh();
    }

    public ImageFrame getPlanningVolumeAsImageFrame() {
        return this.volume.c();
    }

    @Override
    public RtplanDerivedValuesCalculator.MemoizedDerivedPlanInfo getMIMDerivedPlanInfo() {
        return this.derivedPlanInfo;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.beamSelectionChangedCallbackManager = new a(false, true, true, false);
        this.beamVisibilityChangedCallbackManager = new a(false, true, true, false);
        this.beamDataChangedCallbackManager = new a(false, true, true, false);
        this.finishingTouchesCallbackManager = new a(false, true, true, false);
        if (this.beamRecords != null && (this.collimatorStateMap == null || this.collimatorStateMap.isEmpty())) {
            this.collimatorStateMap = Maps.newHashMap();
            Session session = f.a().f();
            for (DicomBeamRecord dicomBeamRecord : this.beamRecords) {
                this.collimatorStateMap.put(dicomBeamRecord, new CollimatorState(dicomBeamRecord, this.sop, session));
            }
        }
        if (this.beamRecords != null) {
            RtplanDerivedValuesCalculator.writeValuesIntoPlan(this, this.derivedPlanInfo);
        }
    }

    @Override
    public com.mimvista.report.data.c.e getVolume() {
        throw new NotImplementedException();
    }

    public RtplanSessionStateReportWrapper getWrappedStateForDataProvider(c c2) {
        return new RtplanSessionStateReportWrapper(this, c2);
    }

    @Override
    public boolean isSamePlan(ReportableRtplanState reportableRtplanState) {
        if (reportableRtplanState instanceof RtplanSessionState) {
            RtplanSessionState rtplanSessionState = (RtplanSessionState)reportableRtplanState;
            return rtplanSessionState.sop.equals(this.sop);
        }
        return false;
    }

    private static class RtplanSessionStateReportWrapper
    implements ReportableRtplanState {
        private c planningVolWrapper;
        private RtplanSessionState state;

        public RtplanSessionStateReportWrapper(RtplanSessionState rtplanSessionState, c c2) {
            this.state = rtplanSessionState;
            this.planningVolWrapper = c2;
        }

        @Override
        public com.mimvista.report.data.c.e getVolume() {
            return this.planningVolWrapper;
        }

        @Override
        public String getSeriesDescription() {
            return this.state.getSeriesDescription();
        }

        @Override
        public String getStudyDescription() {
            return this.state.getStudyDescription();
        }

        @Override
        public String getPlanLabel() {
            return this.state.getPlanLabel();
        }

        @Override
        public String getTime() {
            return this.state.getTime();
        }

        @Override
        public String getDate() {
            return this.state.getDate();
        }

        @Override
        public Date getDateTime() {
            return this.state.getDateTime();
        }

        @Override
        public String getNameFromWorkflow() {
            return this.state.getNameFromWorkflow();
        }

        @Override
        public String getPlanningVolumeSeriesUID() {
            return this.state.getPlanningVolumeSeriesUID();
        }

        @Override
        public boolean isValidated() {
            return this.state.isValidated();
        }

        @Override
        public String getSop() {
            return this.state.getSop();
        }

        @Override
        public ImmutableList<ReportableRtplanState.BeamRecord> getBeamRecords() {
            return this.state.getBeamRecords();
        }

        @Override
        public int getTotalNumberOfFractions() {
            return this.state.getTotalNumberOfFractions();
        }

        @Override
        public Point3f.PointVolumeInfo getPVI() {
            return this.state.getPVI();
        }

        @Override
        public String getReferencedRtstructSop() {
            return this.state.getReferencedRtstructSop();
        }

        @Override
        public DoseValue getRxDose() {
            return this.state.getRxDose();
        }

        @Override
        public List<RTDoseSeriesInfo.RxDose> getAllRxDoses() {
            return this.state.getAllRxDoses();
        }

        @Override
        public DicomObject getDicomObject() {
            return this.state.getDicomObject();
        }

        @Override
        public RtplanDerivedValuesCalculator.MemoizedDerivedPlanInfo getMIMDerivedPlanInfo() {
            return this.state.getMIMDerivedPlanInfo();
        }

        @Override
        public boolean isSamePlan(ReportableRtplanState reportableRtplanState) {
            return this.state.isSamePlan(reportableRtplanState);
        }
    }

    public static interface FinishingTouchListener
    extends EventListener {
        public void actionPerformed(FinishingTouchEvent var1);
    }

    public static interface BeamDataListener
    extends EventListener {
        public void actionPerformed(BeamDataEvent var1);
    }

    public static interface BeamVisibilityListener
    extends EventListener {
        public void actionPerformed(BeamVisibilityEvent var1);
    }

    public static interface BeamSelectedListener
    extends EventListener {
        public void actionPerformed(BeamSelectedEvent var1);
    }

    public static class FinishingTouchEvent {
        BeamDataEvent dataEvent = null;
        BeamSelectedEvent selectedEvent = null;
        BeamVisibilityEvent visibilityEvent = null;

        public FinishingTouchEvent(BeamDataEvent beamDataEvent) {
            this.dataEvent = beamDataEvent;
        }

        public FinishingTouchEvent(BeamSelectedEvent beamSelectedEvent) {
            this.selectedEvent = beamSelectedEvent;
        }

        public FinishingTouchEvent(BeamVisibilityEvent beamVisibilityEvent) {
            this.visibilityEvent = beamVisibilityEvent;
        }

        public FinishingTouchEvent() {
        }

        public BeamDataEvent getDataEvent() {
            return this.dataEvent;
        }

        public BeamSelectedEvent getSelectedEvent() {
            return this.selectedEvent;
        }

        public BeamVisibilityEvent getVisibilityEvent() {
            return this.visibilityEvent;
        }
    }

    public static class BeamDataEvent {
        ReportableRtplanState.BeamRecord beam;

        public ReportableRtplanState.BeamRecord getBeam() {
            return this.beam;
        }

        public BeamDataEvent(ReportableRtplanState.BeamRecord beamRecord) {
            this.beam = beamRecord;
        }
    }

    public static class BeamVisibilityEvent {
        ReportableRtplanState.BeamRecord beam;
        boolean newState;

        public ReportableRtplanState.BeamRecord getBeam() {
            return this.beam;
        }

        public boolean getNewState() {
            return this.newState;
        }

        public BeamVisibilityEvent(ReportableRtplanState.BeamRecord beamRecord, boolean bl2) {
            this.beam = beamRecord;
            this.newState = bl2;
        }
    }

    public static class BeamSelectedEvent {
        ReportableRtplanState.BeamRecord previouslySelectedBeam;
        ReportableRtplanState.BeamRecord newSelectedBeam;

        public BeamSelectedEvent(ReportableRtplanState.BeamRecord beamRecord, ReportableRtplanState.BeamRecord beamRecord2) {
            this.previouslySelectedBeam = beamRecord;
            this.newSelectedBeam = beamRecord2;
        }

        public ReportableRtplanState.BeamRecord getPreviouslySelectedBeam() {
            return this.previouslySelectedBeam;
        }

        public ReportableRtplanState.BeamRecord getNewSelectedBeam() {
            return this.newSelectedBeam;
        }
    }
}

