/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtplan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.dicom.rtplan.RtplanSessionState;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.mui.Session;
import com.mimvista.mui.ak;
import com.mimvista.mui.presenters.display.DisplaySidePanel;
import com.mimvista.state.SerializedSessionStateObject;
import com.mimvista.state.SessionStateObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class RtplanStateManager
implements SerializedSessionStateObject<RtplanStateManager>,
SessionStateObject<RtplanStateManager>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, RtplanSessionState> plans;
    private Map<String, List<String>> loadingErrorMessages = Maps.newHashMap();
    private String activePlanSop;

    public RtplanStateManager(Session session) {
        this.plans = Maps.newHashMap();
    }

    public static RtplanStateManager getForSession(Session session) {
        return session.a(RtplanStateManager.class);
    }

    @Override
    public SerializedSessionStateObject<RtplanStateManager> serialize() {
        return this;
    }

    public ImmutableList<RtplanSessionState> getRtplanStates() {
        return ImmutableList.copyOf(this.plans.values());
    }

    public ImmutableList<RtplanSessionState> getValidatedRtplanStates() {
        ArrayList arrayList = Lists.newArrayList();
        for (RtplanSessionState rtplanSessionState : this.plans.values()) {
            if (!rtplanSessionState.isValidated()) continue;
            arrayList.add(rtplanSessionState);
        }
        return ImmutableList.copyOf((Collection)arrayList);
    }

    public ImmutableList<String> getRtplanSops() {
        ImmutableList.Builder builder = ImmutableList.builder();
        return builder.addAll(this.plans.keySet()).build();
    }

    public RtplanSessionState getState(String string) {
        return this.plans.get(string);
    }

    public void addState(RtplanSessionState rtplanSessionState) {
        DisplaySidePanel displaySidePanel;
        this.plans.put(rtplanSessionState.sop, rtplanSessionState);
        ak ak2 = ak.c();
        if (ak2 != null && (displaySidePanel = ak2.s()) != null) {
            displaySidePanel.f();
        }
    }

    public void addErrorMessages(String string, List<String> list) {
        this.loadingErrorMessages.put(string, list);
    }

    public List<String> getErrorMessages(String string) {
        List<String> list = this.loadingErrorMessages.get(string);
        if (list == null) {
            return Lists.newArrayList();
        }
        return list;
    }

    @Override
    public RtplanStateManager deserialize(Session session) {
        return this;
    }

    @Override
    public void preventLambdas() {
    }

    public List<RtplanSessionState> getStatesByPlanningVolume(ImageFrame imageFrame) {
        String string = imageFrame.getUncopiedMutableInfo().ag();
        return this.getStatesByPlanningVolume(string);
    }

    public List<RtplanSessionState> getValidatedStatesByPlanningVolume(ImageFrame imageFrame) {
        String string = imageFrame.getUncopiedMutableInfo().ag();
        return this.getValidatedStatesByPlanningVolume(string);
    }

    public List<RtplanSessionState> getStatesByPlanningVolume(String string) {
        return this.getRtplanStates().stream().filter(rtplanSessionState -> rtplanSessionState.planningImageUID.equals(string)).collect(Collectors.toList());
    }

    public List<RtplanSessionState> getValidatedStatesByPlanningVolume(String string) {
        return this.getRtplanStates().stream().filter(rtplanSessionState -> string.equals(rtplanSessionState.planningImageUID)).filter(rtplanSessionState -> rtplanSessionState.isValidated()).collect(Collectors.toList());
    }

    public RtplanSessionState getStateByDRR(ViewController viewController) {
        Optional<RtplanSessionState> optional = this.getRtplanStates().stream().filter(rtplanSessionState -> rtplanSessionState.getBeam(viewController) != null).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }
}

