/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtplan;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.numerics.MathUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.cn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class RtplanValidator {
    public static List<String> validateRtplanDicom(DicomObject dicomObject) {
        HashSet hashSet = Sets.newHashSet();
        hashSet.addAll(RtplanValidator.checkForIsocentricSetup(dicomObject));
        hashSet.addAll(RtplanValidator.checkForStaticPlanAndOutOfPlaneGantry(dicomObject));
        hashSet.addAll(RtplanValidator.checkForUnsupportedBeamParameters(dicomObject));
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(hashSet);
        return arrayList;
    }

    private static List<String> checkForUnsupportedBeamParameters(DicomObject dicomObject) {
        ArrayList arrayList = Lists.newArrayList();
        DicomElement dicomElement = dicomObject.get(805961904);
        if (dicomElement == null) {
            arrayList.add(Messages.a("PlanReview", "PR_NO_BEAM_SEQUENCE"));
            return arrayList;
        }
        arrayList.addAll(RtplanValidator.checkForPatientSupportRotation(dicomElement));
        arrayList.addAll(RtplanValidator.checkForTableTopPitchAndRoll(dicomElement));
        arrayList.addAll(RtplanValidator.checkForBlocks(dicomElement));
        arrayList.addAll(RtplanValidator.checkForCompensators(dicomElement));
        arrayList.addAll(RtplanValidator.checkForApplicators(dicomElement));
        arrayList.addAll(RtplanValidator.checkForInsufficientMonitorUnitInfo(dicomElement));
        return arrayList;
    }

    private static List<String> checkForIsocentricSetup(DicomObject dicomObject) {
        ArrayList arrayList = Lists.newArrayList();
        DicomElement dicomElement = dicomObject.get(805962112);
        if (dicomElement == null) {
            arrayList.add(Messages.a("PlanReview", "PR_NO_PATIENT_SETUP"));
            return arrayList;
        }
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
            String string = dicomObject2.getString(805962160);
            if (cn.g(string) || "ISOCENTRIC".equalsIgnoreCase(string)) continue;
            arrayList.add(MIMFormat.a(Messages.a("PlanReview", "PR_SETUP_NOT_ISOCENTRIC"), dicomObject2.getString(805962114)));
        }
        return arrayList;
    }

    private static List<String> checkForStaticPlanAndOutOfPlaneGantry(DicomObject dicomObject) {
        ArrayList arrayList = Lists.newArrayList();
        DicomElement dicomElement = dicomObject.get(805961904);
        if (dicomElement == null) {
            arrayList.add(Messages.a("PlanReview", "PR_NO_BEAM_SEQUENCE"));
            return arrayList;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            Double d2 = null;
            DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
            DicomElement dicomElement2 = dicomObject2.get(805962001);
            for (int i3 = 0; i3 < dicomElement2.countItems(); ++i3) {
                float f2;
                DicomObject dicomObject3 = dicomElement2.getDicomObject(i3);
                if (dicomObject3.contains(805962014)) {
                    double d3 = dicomObject3.getDouble(805962014);
                    if (d2 == null) {
                        d2 = d3;
                    } else if (!MathUtils.b(d3, d2, 0.001)) {
                        bl3 = true;
                    }
                }
                if (!dicomObject3.contains(805962058) || MathUtils.b((double)(f2 = dicomObject3.getFloat(805962058)), 0.0, 0.001)) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            arrayList.add(Messages.a("PlanReview", "PR_GANTRY_PITCH"));
        }
        if (bl3) {
            arrayList.add(Messages.a("PlanReview", "PR_NON_STATIC_PLAN"));
        }
        return arrayList;
    }

    private static List<String> checkForPatientSupportRotation(DicomElement dicomElement) {
        ArrayList arrayList = Lists.newArrayList();
        block0: for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            DicomElement dicomElement2 = dicomObject.get(805962001);
            DicomObject dicomObject2 = dicomElement2.getDicomObject(0);
            float f2 = dicomObject2.getFloat(805962018, Float.NaN);
            String string = dicomObject2.getString(805962019, "");
            if (Float.isNaN(f2) || string.isEmpty()) {
                arrayList.add(Messages.a("PlanReview", "PR_NO_PATIENT_SUPPORT_ANGLE"));
                continue;
            }
            if (!MathUtils.b((double)f2, 0.0, 0.01) || !string.equals("NONE")) {
                arrayList.add(Messages.a("PlanReview", "PR_NONZERO_PATIENT_SUPPORT_ANGLE"));
                continue;
            }
            for (int i3 = 1; i3 < dicomElement2.countItems(); ++i3) {
                DicomObject dicomObject3 = dicomElement2.getDicomObject(i3);
                float f3 = dicomObject3.getFloat(805962018, Float.NaN);
                String string2 = dicomObject3.getString(805962019, "");
                if ((Float.isNaN(f3) || f3 == f2) && (string2.isEmpty() || string2.equals(string))) continue;
                arrayList.add(Messages.a("PlanReview", "PR_NONZERO_PATIENT_SUPPORT_ANGLE"));
                continue block0;
            }
        }
        return arrayList;
    }

    private static List<String> checkForTableTopPitchAndRoll(DicomElement dicomElement) {
        ArrayList arrayList = Lists.newArrayList();
        String string = Messages.a("PlanReview", "PR_NONZERO_TABLE_TOP_ROLL");
        String string2 = Messages.a("PlanReview", "PR_NONZERO_TABLE_TOP_PITCH");
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            DicomElement dicomElement2 = dicomObject.get(805962001);
            if (dicomElement2 == null || !dicomElement2.hasDicomObjects()) continue;
            DicomObject dicomObject2 = dicomElement2.getDicomObject(0);
            float f2 = dicomObject2.getFloat(805962052, Float.NaN);
            String string3 = dicomObject2.getString(805962054, "");
            float f3 = dicomObject2.getFloat(805962048, Float.NaN);
            String string4 = dicomObject2.getString(805962050, "");
            if (!Float.isNaN(f2) && !MathUtils.b((double)f2, 0.0, 0.001) || !string3.isEmpty() && !string3.equals("NONE")) {
                arrayList.add(string);
            }
            if (!Float.isNaN(f3) && !MathUtils.b((double)f3, 0.0, 0.001) || !string4.isEmpty() && !string4.equals("NONE")) {
                arrayList.add(string2);
            }
            if (arrayList.contains(string) && arrayList.contains(string2)) {
                return arrayList;
            }
            for (int i3 = 1; i3 < dicomElement2.countItems(); ++i3) {
                DicomObject dicomObject3 = dicomElement2.getDicomObject(i3);
                float f4 = dicomObject3.getFloat(805962052, Float.NaN);
                String string5 = dicomObject3.getString(805962054, "");
                float f5 = dicomObject3.getFloat(805962048, Float.NaN);
                String string6 = dicomObject3.getString(805962050, "");
                if (!Float.isNaN(f4) && !MathUtils.b((double)f2, (double)f4, 0.001) || !string5.isEmpty() && !string5.equals(string3)) {
                    arrayList.add(string);
                }
                if ((Float.isNaN(f5) || MathUtils.b((double)f3, (double)f5, 0.001)) && (string6.isEmpty() || string6.equals(string4))) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private static List<String> checkForBlocks(DicomElement dicomElement) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            int n2 = dicomObject.getInt(805961968);
            if (n2 <= 0) continue;
            arrayList.add(Messages.a("PlanReview", "PR_BLOCKS_FOUND"));
            break;
        }
        return arrayList;
    }

    private static List<String> checkForCompensators(DicomElement dicomElement) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            int n2 = dicomObject.getInt(805961952);
            if (n2 <= 0) continue;
            arrayList.add(Messages.a("PlanReview", "PR_COMPENSATORS_FOUND"));
            return arrayList;
        }
        return arrayList;
    }

    private static List<String> checkForApplicators(DicomElement dicomElement) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            DicomElement dicomElement2 = dicomObject.get(805961991);
            if ("ELECTRON".equals(dicomObject.getString(805961926)) || dicomElement2 == null) continue;
            arrayList.add(Messages.a("PlanReview", "PR_APPLICATOR_FOUND"));
            return arrayList;
        }
        return arrayList;
    }

    private static List<String> checkForInsufficientMonitorUnitInfo(DicomElement dicomElement) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            if (!"MINUTE".equals(dicomObject.getString(805961907, ""))) continue;
            DicomElement dicomElement2 = dicomObject.get(805962001);
            if (Float.isNaN(dicomElement2.getDicomObject(0).getFloat(805962005, Float.NaN))) {
                arrayList.add(Messages.a("PlanReview", "PR_UNSPECIFIED_MU"));
                return arrayList;
            }
            if (dicomElement2.countItems() <= 2) continue;
            boolean bl2 = Float.isNaN(dicomElement2.getDicomObject(1).getFloat(805962005, Float.NaN));
            for (int i3 = 2; i3 < dicomElement2.countItems(); ++i3) {
                if (bl2 == Float.isNaN(dicomElement2.getDicomObject(i3).getFloat(805962005, Float.NaN))) continue;
                arrayList.add(Messages.a("PlanReview", "PR_UNSPECIFIED_MU"));
                return arrayList;
            }
        }
        return arrayList;
    }
}

