/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtplan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mimvista.dicom.rtplan.RtstructSessionState;
import com.mimvista.mui.Session;
import com.mimvista.state.SerializedSessionStateObject;
import com.mimvista.state.SessionStateObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RtstSessionStateManager
implements SessionStateObject<RtstSessionStateManager>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, RtstructSessionState> rtsts = new HashMap<String, RtstructSessionState>();

    public RtstSessionStateManager(Session session) {
    }

    public static RtstSessionStateManager getForSession(Session session) {
        return session.a(RtstSessionStateManager.class);
    }

    public ImmutableList<RtstructSessionState> getRtplanStates() {
        return ImmutableList.copyOf(this.rtsts.values());
    }

    public ImmutableList<String> getRtstSops() {
        ImmutableList.Builder builder = ImmutableList.builder();
        return builder.addAll(this.rtsts.keySet()).build();
    }

    public void addState(RtstructSessionState rtstructSessionState) {
        this.rtsts.put(rtstructSessionState.getSop(), rtstructSessionState);
    }

    public RtstructSessionState getState(String string) {
        return this.rtsts.get(string);
    }

    @Override
    public SerializedSessionStateObject<RtstSessionStateManager> serialize() {
        return new SerializedRtstSessionStateManager(this);
    }

    public static class SerializedRtstSessionStateManager
    implements SerializedSessionStateObject<RtstSessionStateManager> {
        private static final long serialVersionUID = 1L;
        private Map<String, SerializedSessionStateObject<RtstructSessionState>> rtsts = Maps.newHashMap();

        SerializedRtstSessionStateManager(RtstSessionStateManager rtstSessionStateManager) {
            for (RtstructSessionState rtstructSessionState : rtstSessionStateManager.getRtplanStates()) {
                this.rtsts.put(rtstructSessionState.getSop(), rtstructSessionState.serialize());
            }
        }

        @Override
        public void preventLambdas() {
        }

        @Override
        public RtstSessionStateManager deserialize(Session session) {
            RtstSessionStateManager rtstSessionStateManager = new RtstSessionStateManager(session);
            for (SerializedSessionStateObject<RtstructSessionState> serializedSessionStateObject : this.rtsts.values()) {
                RtstructSessionState rtstructSessionState = serializedSessionStateObject.deserialize(session);
                rtstSessionStateManager.addState(rtstructSessionState);
            }
            return rtstSessionStateManager;
        }
    }
}

