/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtplan;

import com.google.common.collect.Maps;
import com.mimvista.internals.casting.cltests.CompressedContourData;
import com.mimvista.mui.Session;
import com.mimvista.mui.overlays.VolumetricContourOverlay;
import com.mimvista.state.SerializedSessionStateObject;
import com.mimvista.state.SessionStateObject;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class RtstructSessionState
implements SerializedSessionStateObject<RtstructSessionState>,
SessionStateObject<RtstructSessionState>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String sop;
    private String approvalStatus = "UNAPPROVED";
    private Map<Integer, ContourInfo> contourDataMap = Maps.newHashMap();

    public RtstructSessionState(String string, List<VolumetricContourOverlay> list) {
        this.sop = string;
        for (VolumetricContourOverlay volumetricContourOverlay : list) {
            CompressedContourData compressedContourData = new CompressedContourData();
            compressedContourData.a(volumetricContourOverlay.aq());
            compressedContourData.a(volumetricContourOverlay.bn_());
            ContourInfo contourInfo = new ContourInfo(volumetricContourOverlay.getName(), volumetricContourOverlay.ba(), compressedContourData);
            this.contourDataMap.put(volumetricContourOverlay.ba(), contourInfo);
        }
    }

    public ContourInfo getContourInfo(int n2) {
        return this.contourDataMap.get(n2);
    }

    public String getSop() {
        return this.sop;
    }

    public Collection<ContourInfo> getAllContourInfos() {
        return this.contourDataMap.values();
    }

    public String getApprovalStatus() {
        return this.approvalStatus;
    }

    public void setApprovalStatus(String string) {
        this.approvalStatus = string;
    }

    @Override
    public void preventLambdas() {
    }

    @Override
    public SerializedSessionStateObject<RtstructSessionState> serialize() {
        return this;
    }

    @Override
    public RtstructSessionState deserialize(Session session) {
        return this;
    }

    public static class ContourInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private int referencedRoiNumber;
        private CompressedContourData data;

        public ContourInfo(String string, int n2, CompressedContourData compressedContourData) {
            this.name = string;
            this.referencedRoiNumber = n2;
            this.data = compressedContourData;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public int getReferencedRoiNumber() {
            return this.referencedRoiNumber;
        }

        public void setReferencedRoiNumber(int n2) {
            this.referencedRoiNumber = n2;
        }

        public CompressedContourData getCompressedContour() {
            return this.data;
        }
    }
}

