/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server;

import com.mimvista.dicom.server.DicomStoreService;
import com.mimvista.rmi.DcmRcvStatus;
import com.mimvista.rmi.TransferDialogInterface;
import com.mimvista.util.bq;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DcmRcvStatusNotifier
extends UnicastRemoteObject
implements DcmRcvStatus {
    public static final int DCMRCV_STATUS_PORT = "true".equals(System.getProperty("junit.test")) ? bq.a() : 17191;
    private DicomStoreService owner;
    private static final long serialVersionUID = 1L;
    private ConcurrentHashMap<TransferDialogInterface, ExecutorService> executorMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, TransferDialogInterface> customerHash = new ConcurrentHashMap();

    protected DcmRcvStatusNotifier(DicomStoreService dicomStoreService) throws RemoteException {
        super(0, DcmRcvStatusNotifier.getClientSockFact(), DcmRcvStatusNotifier.getServerSocketFact());
        this.owner = dicomStoreService;
        try {
            RMIClientSocketFactory rMIClientSocketFactory = DcmRcvStatusNotifier.getClientSockFact();
            RMIServerSocketFactory rMIServerSocketFactory = DcmRcvStatusNotifier.getServerSocketFact();
            LocateRegistry.createRegistry(DCMRCV_STATUS_PORT, rMIClientSocketFactory, rMIServerSocketFactory);
        }
        catch (Exception exception) {
            DicomStoreService.receiveLog.c("Error starting RMI registry", exception);
            return;
        }
        try {
            Naming.rebind("//localhost:" + DCMRCV_STATUS_PORT + "/DcmRcvNotifier", this);
            DicomStoreService.receiveLog.a("Created receive notifier and bound");
        }
        catch (MalformedURLException malformedURLException) {
            DicomStoreService.receiveLog.c("Binding", malformedURLException);
        }
    }

    public static RMIServerSocketFactory getServerSocketFact() {
        return new LocalServerSocketFactory();
    }

    public static RMIClientSocketFactory getClientSockFact() {
        return new LocalClientSocketFactory();
    }

    @Override
    public void subscribe(TransferDialogInterface transferDialogInterface) {
        try {
            Long l2 = transferDialogInterface.getId();
            if (!this.customerHash.containsKey(transferDialogInterface.getId())) {
                DicomStoreService.receiveLog.d("Received customer: " + transferDialogInterface);
                this.customerHash.put(l2, transferDialogInterface);
                this.executorMap.put(transferDialogInterface, Executors.newSingleThreadExecutor());
            }
        }
        catch (RemoteException remoteException) {
            DicomStoreService.receiveLog.c("Remote Exception while subscribing dialog: ", remoteException);
        }
    }

    @Override
    public void redirectIncomingSeries(String string, String string2, int n2, int n3, String string3) throws RemoteException {
        this.owner.redirectIncomingSeries(string, string2, n2, n3, string3);
    }

    public void transferStarted(final String string, final String string2) {
        DicomStoreService.receiveLog.d("Transfer started: " + string + ", " + string2);
        Set<Map.Entry<Long, TransferDialogInterface>> set = this.customerHash.entrySet();
        for (Map.Entry<Long, TransferDialogInterface> entry : set) {
            final Long l2 = entry.getKey();
            final TransferDialogInterface transferDialogInterface = entry.getValue();
            ExecutorService executorService = this.executorMap.get(transferDialogInterface);
            if (executorService == null) continue;
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DicomStoreService.receiveLog.d("notifying started to " + DcmRcvStatusNotifier.getLoggableIdFor(transferDialogInterface));
                        transferDialogInterface.transferStarted(string, string2);
                    }
                    catch (RemoteException remoteException) {
                        DicomStoreService.receiveLog.c("Notify failed", remoteException);
                        DcmRcvStatusNotifier.this.customerHash.remove(l2);
                        DcmRcvStatusNotifier.this.executorMap.remove(transferDialogInterface);
                    }
                }
            });
        }
    }

    public void transferFinished(final String string, final boolean bl2) {
        DicomStoreService.receiveLog.d("Transfer finished: " + string);
        Set<Map.Entry<Long, TransferDialogInterface>> set = this.customerHash.entrySet();
        for (Map.Entry<Long, TransferDialogInterface> entry : set) {
            final Long l2 = entry.getKey();
            final TransferDialogInterface transferDialogInterface = entry.getValue();
            ExecutorService executorService = this.executorMap.get(transferDialogInterface);
            if (executorService == null) continue;
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DicomStoreService.receiveLog.d("notifying finished to " + DcmRcvStatusNotifier.getLoggableIdFor(transferDialogInterface));
                        transferDialogInterface.transferFinished(string, bl2);
                    }
                    catch (RemoteException remoteException) {
                        DicomStoreService.receiveLog.c("Notify failed", remoteException);
                        DcmRcvStatusNotifier.this.customerHash.remove(l2);
                        DcmRcvStatusNotifier.this.executorMap.remove(transferDialogInterface);
                    }
                }
            });
        }
    }

    public void updateText(final String string, final String string2, final String string3) {
        DicomStoreService.receiveLog.d("Transfer update: " + string + ", " + string2);
        Set<Map.Entry<Long, TransferDialogInterface>> set = this.customerHash.entrySet();
        for (Map.Entry<Long, TransferDialogInterface> entry : set) {
            final Long l2 = entry.getKey();
            final TransferDialogInterface transferDialogInterface = entry.getValue();
            ExecutorService executorService = this.executorMap.get(transferDialogInterface);
            if (executorService == null) continue;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        DicomStoreService.receiveLog.d("notifying update to " + DcmRcvStatusNotifier.getLoggableIdFor(transferDialogInterface));
                        transferDialogInterface.updateText(string, string2, string3);
                    }
                    catch (RemoteException remoteException) {
                        DicomStoreService.receiveLog.c("Notify failed", remoteException);
                        DcmRcvStatusNotifier.this.customerHash.remove(l2);
                        DcmRcvStatusNotifier.this.executorMap.remove(transferDialogInterface);
                    }
                }
            };
            executorService.execute(runnable);
        }
    }

    public void seriesArchived(final String string, final String string2) {
        DicomStoreService.receiveLog.d("Notifying of archiving.");
        Set<Map.Entry<Long, TransferDialogInterface>> set = this.customerHash.entrySet();
        for (Map.Entry<Long, TransferDialogInterface> entry : set) {
            final Long l2 = entry.getKey();
            final TransferDialogInterface transferDialogInterface = entry.getValue();
            ExecutorService executorService = this.executorMap.get(transferDialogInterface);
            if (executorService == null) continue;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        DicomStoreService.receiveLog.d("archived notify to " + DcmRcvStatusNotifier.getLoggableIdFor(transferDialogInterface));
                        transferDialogInterface.seriesArchived(string, string2);
                    }
                    catch (RemoteException remoteException) {
                        DicomStoreService.receiveLog.c("Notify failed", remoteException);
                        DcmRcvStatusNotifier.this.customerHash.remove(l2);
                        DcmRcvStatusNotifier.this.executorMap.remove(transferDialogInterface);
                    }
                }
            };
            executorService.execute(runnable);
        }
    }

    public void transferCancelled(final String string) {
        DicomStoreService.receiveLog.d("Transfer cancelled: " + string);
        Set<Map.Entry<Long, TransferDialogInterface>> set = this.customerHash.entrySet();
        for (Map.Entry<Long, TransferDialogInterface> entry : set) {
            final Long l2 = entry.getKey();
            final TransferDialogInterface transferDialogInterface = entry.getValue();
            ExecutorService executorService = this.executorMap.get(transferDialogInterface);
            if (executorService == null) continue;
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DicomStoreService.receiveLog.d("notifying cancel to " + DcmRcvStatusNotifier.getLoggableIdFor(transferDialogInterface));
                        transferDialogInterface.transferCancelled(string);
                    }
                    catch (RemoteException remoteException) {
                        DicomStoreService.receiveLog.c("Notify failed", remoteException);
                        DcmRcvStatusNotifier.this.customerHash.remove(l2);
                        DcmRcvStatusNotifier.this.executorMap.remove(transferDialogInterface);
                    }
                }
            });
        }
    }

    private static String getLoggableIdFor(TransferDialogInterface transferDialogInterface) {
        String string = transferDialogInterface.toString();
        try {
            string = ((RemoteServer)((Object)transferDialogInterface)).getRef().remoteToString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    private static final class LocalClientSocketFactory
    implements Serializable,
    RMIClientSocketFactory {
        private static final long serialVersionUID = 1L;

        private LocalClientSocketFactory() {
        }

        @Override
        public Socket createSocket(String string, int n2) throws IOException {
            return new Socket("localhost", n2);
        }

        public boolean equals(Object object) {
            return object != null && this.getClass().equals(object.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static final class LocalServerSocketFactory
    implements Serializable,
    RMIServerSocketFactory {
        private static final long serialVersionUID = 1L;

        private LocalServerSocketFactory() {
        }

        @Override
        public ServerSocket createServerSocket(int n2) throws IOException {
            return new ServerSocket(n2, 50, InetAddress.getByName("localhost"));
        }

        public boolean equals(Object object) {
            return object != null && this.getClass().equals(object.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

