/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.archive.Archiver;
import com.mimvista.dicom.server.DicomStoreAppEntity;
import com.mimvista.dicom.server.DicomStoreArchivingDelegate;
import com.mimvista.dicom.server.DicomStoreAssociation;
import com.mimvista.dicom.server.DicomStoreService;
import com.mimvista.file.MIMFile;
import com.mimvista.file.j;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.as;
import com.mimvista.util.ay;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class DelayedArchiveTask
implements Runnable {
    private static ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private boolean isSuccessful;
    private List<MIMFile> archivedSeriesFolders = Lists.newArrayList();
    private DicomStoreAppEntity ae;
    private File taskDir;
    private File destinationArchiveFolder;
    private String seriesInstanceUid;
    private Set<Archiver.d> seriesFiles = Sets.newHashSet();
    private List<DicomStoreAssociation> associations = Collections.synchronizedList(new ArrayList());
    private List<Runnable> taskQueuedListeners = Collections.synchronizedList(new ArrayList());
    private List<FuncUtils.m<TaskCompletedEvent>> taskCompletedListeners = Collections.synchronizedList(new ArrayList());
    private ScheduledFuture<?> future;

    DelayedArchiveTask() {
    }

    public static void waitForTasksToComplete(long l2, TimeUnit timeUnit) {
        try {
            executor.shutdown();
            executor.awaitTermination(l2, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        executor = Executors.newSingleThreadScheduledExecutor();
    }

    public synchronized DelayedArchiveTask setAE(DicomStoreAppEntity dicomStoreAppEntity) {
        if (dicomStoreAppEntity == null) {
            throw new NullPointerException("ae cannot be null");
        }
        this.ae = dicomStoreAppEntity;
        return this;
    }

    public synchronized DelayedArchiveTask setSeriesInstanceUid(String string) {
        if (string == null) {
            throw new NullPointerException("uid cannot be null");
        }
        this.seriesInstanceUid = string;
        return this;
    }

    public synchronized String getSeriesInstanceUid() {
        return this.seriesInstanceUid;
    }

    public synchronized DelayedArchiveTask setTaskDir(File file) {
        if (file == null) {
            throw new NullPointerException("taskDir cannot be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("taskDir doesn't exist: " + file);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("taskDir is not a directory: " + file);
        }
        this.taskDir = file;
        return this;
    }

    public synchronized File getTaskDir() {
        return this.taskDir;
    }

    public synchronized DelayedArchiveTask setDestinationArchiveFolder(File file) {
        this.destinationArchiveFolder = file;
        return this;
    }

    public synchronized File getDestinationArchiveFolder() {
        return this.destinationArchiveFolder;
    }

    public synchronized void addSeriesFile(Archiver.d d2) {
        this.seriesFiles.add(d2);
    }

    public DelayedArchiveTask addAssociation(DicomStoreAssociation dicomStoreAssociation) {
        if (dicomStoreAssociation != null) {
            this.associations.add(dicomStoreAssociation);
            dicomStoreAssociation.addArchiveTask(this);
        }
        return this;
    }

    public DelayedArchiveTask addTaskQueuedListener(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("listener cannot be null");
        }
        this.taskQueuedListeners.add(runnable);
        return this;
    }

    public DelayedArchiveTask addTaskCompletedListener(FuncUtils.m<TaskCompletedEvent> m2) {
        if (m2 == null) {
            throw new NullPointerException("listener cannot be null");
        }
        this.taskCompletedListeners.add(m2);
        return this;
    }

    public synchronized void schedule(long l2) {
        this.future = executor.schedule(this, l2, TimeUnit.MILLISECONDS);
    }

    public synchronized boolean cancel() {
        if (this.future != null) {
            return this.future.cancel(false);
        }
        return true;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    public List<MIMFile> getArchivedSeriesFolders() {
        return Collections.unmodifiableList(this.archivedSeriesFolders);
    }

    @Override
    public void run() {
        try {
            DicomStoreService.enqueueHighPrioTask(() -> {
                try {
                    DicomStoreArchivingDelegate dicomStoreArchivingDelegate = DicomStoreService.getInstance().getArchiveDelegate();
                    this.archivedSeriesFolders = dicomStoreArchivingDelegate.archiveOneSeries(this.ae, this.seriesInstanceUid, this.taskDir, this.destinationArchiveFolder, this.seriesFiles);
                    if (this.taskDir.exists() && !this.taskDir.delete()) {
                        ay.d((Object)("Couldn't delete task dir: " + this.taskDir), this);
                    } else {
                        File file = this.taskDir.getParentFile();
                        File[] fileArray = file.listFiles(j.a);
                        if (fileArray != null && fileArray.length == 0 && !file.delete()) {
                            ay.d((Object)("Couldn't delete empty series dir: " + file), this);
                        }
                    }
                    this.isSuccessful = true;
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Error archiving incoming series", throwable, this);
                }
                finally {
                    this.fireTaskCompletedListeners();
                }
            });
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error trying to queue up archive task", throwable, this);
        }
        finally {
            this.fireTaskQueuedListeners();
        }
    }

    private void fireTaskQueuedListeners() {
        for (Runnable runnable : as.c(this.taskQueuedListeners)) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error during DelayedArchiveTask queued listener", throwable, this);
            }
        }
    }

    private void fireTaskCompletedListeners() {
        TaskCompletedEvent taskCompletedEvent = new TaskCompletedEvent(this);
        for (FuncUtils.m<TaskCompletedEvent> m2 : as.c(this.taskCompletedListeners)) {
            try {
                m2.doIt(taskCompletedEvent);
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error during DelayedArchiveTask completion listener", throwable, this);
            }
        }
    }

    public static class TaskCompletedEvent {
        private DelayedArchiveTask task;

        public TaskCompletedEvent(DelayedArchiveTask delayedArchiveTask) {
            this.task = delayedArchiveTask;
        }

        public DelayedArchiveTask getTask() {
            return this.task;
        }
    }
}

