/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server;

import com.google.common.base.Preconditions;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.mimcloud.c.a;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.k;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.PDVInputStream;

public class DicomQRClientDataProxy {
    List<Transfer> transfers = new ArrayList<Transfer>();
    Timer watchdogTimer = null;

    synchronized void registerRequest(String string, String string2, String string3, int n2, int n3) {
        this.transfers.add(new Transfer(string, string2, string3, n2, n3));
        if (this.watchdogTimer == null) {
            this.startWatchdog();
        }
    }

    synchronized boolean expectingAnythingOn(String string) {
        this.cleanList();
        return this.transfers.stream().anyMatch(transfer -> transfer.aeTitle.equals(string));
    }

    synchronized boolean sendData(Association association, String string, String string2, InputStream inputStream) throws IOException {
        this.cleanList();
        Optional<Transfer> optional = this.transfers.stream().filter(transfer -> transfer.aeTitle.equals(association.getCalledAET()) && transfer.seriesUID.equals(string) && !transfer.processedSopUIDs.contains(string2)).findFirst();
        if (!optional.isPresent()) {
            return false;
        }
        return optional.get().sendStream(string2, inputStream);
    }

    private synchronized void cleanList() {
        Iterator<Transfer> iterator = this.transfers.iterator();
        while (iterator.hasNext()) {
            Transfer transfer = iterator.next();
            if (!transfer.isExpired()) continue;
            transfer.cleanup();
            iterator.remove();
        }
    }

    private void startWatchdog() {
        long l2 = TimeUnit.MINUTES.toMillis(5L);
        this.watchdogTimer = new Timer(true);
        this.watchdogTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                DicomQRClientDataProxy.this.cleanList();
            }
        }, l2, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<String, InputStream> peekSeriesUID(PDVInputStream pDVInputStream) throws IOException {
        int n2 = 0x100000;
        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)pDVInputStream, n2);
        bufferedInputStream.mark(n2);
        try {
            DicomObject dicomObject = DicomReader.readStreamIntoDicomObject((InputStream)new a(bufferedInputStream, n2), 0x20000F, true);
            String string = dicomObject.getString(0x20000E);
            Pair<String, InputStream> pair = Pair.get(string, bufferedInputStream);
            return pair;
        }
        finally {
            bufferedInputStream.reset();
        }
    }

    static class Transfer {
        private static final int EXPIRATION_MINUTES = 5;
        final String seriesUID;
        final String aeTitle;
        final String guid;
        final int port;
        int numInstancesRemaining;
        Set<String> processedSopUIDs = Collections.newSetFromMap(new ConcurrentHashMap());
        LocalTime expirationTime;
        Socket sendingSock;
        DataOutputStream dataOut;

        Transfer(String string, String string2, String string3, int n2, int n3) {
            Preconditions.checkNotNull((Object)string);
            this.aeTitle = string;
            Preconditions.checkNotNull((Object)string2);
            this.seriesUID = string2;
            Preconditions.checkNotNull((Object)string3);
            this.guid = string3;
            this.port = n2;
            this.numInstancesRemaining = n3;
            this.resetExpiration();
        }

        synchronized boolean sendStream(String string, InputStream inputStream) throws IOException {
            if (this.sendingSock == null && !this.openSocket()) {
                return false;
            }
            this.resetExpiration();
            this.processedSopUIDs.add(string);
            --this.numInstancesRemaining;
            this.dataOut.writeUTF(string);
            k.a(inputStream, this.dataOut, this::resetExpiration);
            if (this.numInstancesRemaining == 0) {
                this.dataOut.flush();
                this.dataOut.close();
            } else {
                this.resetExpiration();
            }
            return true;
        }

        private boolean openSocket() {
            try {
                this.sendingSock = new Socket("127.0.0.1", this.port);
                this.sendingSock.setSoLinger(false, 0);
                this.sendingSock.setTcpNoDelay(true);
                this.dataOut = new DataOutputStream(this.sendingSock.getOutputStream());
                this.dataOut.writeUTF(this.guid);
                DataInputStream dataInputStream = new DataInputStream(this.sendingSock.getInputStream());
                String string = dataInputStream.readUTF();
                if (!this.seriesUID.equals(string)) {
                    throw new IOException("Did not get proper response series UID response when socket was opened; expected " + this.seriesUID + " but got '" + string + "'.");
                }
                return true;
            }
            catch (IOException iOException) {
                ay.d((Object)"Couldn't open socket for qr transfer", (Throwable)iOException, Transfer.class);
                this.cleanup();
                return false;
            }
        }

        synchronized void cleanup() {
            if (this.sendingSock != null && !this.sendingSock.isClosed()) {
                try {
                    this.sendingSock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        synchronized void resetExpiration() {
            if (!this.isFinishedOrFailed()) {
                this.expirationTime = LocalTime.now().plusMinutes(5L);
            }
        }

        synchronized boolean isExpired() {
            return this.isFinishedOrFailed() || this.expirationTime.isBefore(LocalTime.now());
        }

        private boolean isFinishedOrFailed() {
            return this.numInstancesRemaining == 0 || this.sendingSock != null && this.sendingSock.isClosed();
        }
    }
}

