/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.archive.remote.MIMpacsConfig;
import com.mimvista.dicom.server.DcmStoreAeTitle;
import com.mimvista.dicom.server.DelayedArchiveTask;
import com.mimvista.dicom.server.DicomStoreAssociation;
import com.mimvista.dicom.server.MIMStorageCommitmentSCP;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.util.ay;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.service.DicomService;
import org.dcm4che2.net.service.StorageService;
import org.dcm4che2.net.service.VerificationService;

public class DicomStoreAppEntity
extends NetworkApplicationEntity {
    private static VerificationService vs = new VerificationService();
    private static MIMStorageCommitmentSCP stgCmtSCP = new MIMStorageCommitmentSCP();
    private DcmStoreAeTitle aeTitle;
    private File oldPrearchiveFolder;
    private int commitTimeout = 300000;
    private Map<String, DelayedArchiveTask> taskMap = Maps.newHashMap();

    public DicomStoreAppEntity(NetworkConnection networkConnection, StorageService storageService, DcmStoreAeTitle dcmStoreAeTitle, File file, boolean bl2) {
        this.aeTitle = dcmStoreAeTitle;
        this.setAETitle(dcmStoreAeTitle.getAETitle());
        this.setNetworkConnection(networkConnection);
        this.setAssociationAcceptor(true);
        this.register((DicomService)vs);
        this.register((DicomService)storageService);
        if (bl2) {
            this.register(stgCmtSCP);
        }
        this.oldPrearchiveFolder = Path.joinFile(file, dcmStoreAeTitle.getAETitle(), "prearchive");
        if (!dcmStoreAeTitle.isMimpacsPatientList() || MIMpacsConfig.h() == MIMpacsConfig.PacsType.b) {
            try {
                if (MIMFile.m(dcmStoreAeTitle.getArchiveFolder())) {
                    ay.b((Object)(this.getLogPrefix(networkConnection) + "create archive directory " + dcmStoreAeTitle.getArchiveFolder()), (Object)this);
                }
            }
            catch (IOException iOException) {
                ay.d((Object)(this.getLogPrefix(networkConnection) + "failed to create archive directory " + dcmStoreAeTitle.getArchiveFolder()), (Throwable)iOException, (Object)this);
            }
        }
    }

    File getArchiveDir() throws IOException {
        return this.aeTitle.getArchiveFolderWithEnoughSpace();
    }

    List<File> getAllArchiveDirs() {
        return this.aeTitle.getAllArchiveFolders();
    }

    File getTempDir() throws IOException {
        return this.getTempFolderForArchiveFolder(this.getArchiveDir());
    }

    List<File> getAllPossibleTempDirs() {
        List<File> list = this.getAllArchiveDirs();
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)list.size());
        for (File file : list) {
            arrayList.add(this.getTempFolderForArchiveFolder(file));
        }
        return arrayList;
    }

    private File getTempFolderForArchiveFolder(File file) {
        return Path.joinFile(file, "DICOM_STORE_TEMP", this.aeTitle.getAETitle());
    }

    File getOldPrearchiveDir() {
        return this.oldPrearchiveFolder;
    }

    String getArchiveAlias() {
        return this.aeTitle.getMIMpacsPLAlias();
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("aeTitle", (Object)this.aeTitle).toString();
    }

    void setCommitTimeout(int n2) {
        this.commitTimeout = n2;
    }

    int getCommitTimeout() {
        return this.commitTimeout;
    }

    private String getLogPrefix(NetworkConnection networkConnection) {
        if (networkConnection == null) {
            return "Null NetworkConnection| ";
        }
        return networkConnection.toString() + "| ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelayedArchiveTask getArchiveTask(String string) {
        Map<String, DelayedArchiveTask> map = this.taskMap;
        synchronized (map) {
            return this.taskMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelayedArchiveTask createArchiveTask(DicomStoreAssociation dicomStoreAssociation, String string) throws IOException {
        final DelayedArchiveTask delayedArchiveTask = new DelayedArchiveTask().setAE(this).setSeriesInstanceUid(string).setTaskDir(dicomStoreAssociation.createTaskDir(string)).setDestinationArchiveFolder(dicomStoreAssociation.getDestinationArchiveFolder()).addAssociation(dicomStoreAssociation);
        delayedArchiveTask.addTaskQueuedListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = DicomStoreAppEntity.this.taskMap;
                synchronized (map) {
                    DicomStoreAppEntity.this.taskMap.remove(delayedArchiveTask.getSeriesInstanceUid());
                }
            }
        });
        Map<String, DelayedArchiveTask> map = this.taskMap;
        synchronized (map) {
            this.taskMap.put(string, delayedArchiveTask);
        }
        return delayedArchiveTask;
    }
}

