/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server;

import com.google.common.collect.Lists;
import com.mimvista.archive.Archiver;
import com.mimvista.archive.e;
import com.mimvista.dicom.server.DicomStoreAppEntity;
import com.mimvista.dicom.server.DicomStoreService;
import com.mimvista.dicom.util.FancyArchiveCacheCreator;
import com.mimvista.file.MIMFile;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DicomStoreArchivingDelegate {
    private DicomStoreService dcmRcv;

    public List<MIMFile> archiveOneSeries(DicomStoreAppEntity dicomStoreAppEntity, String string, File file) throws IOException {
        return this.archiveOneSeries(dicomStoreAppEntity, string, file, dicomStoreAppEntity.getArchiveDir(), null);
    }

    public List<MIMFile> archiveOneSeries(DicomStoreAppEntity dicomStoreAppEntity, String string, File file, File file2, Iterable<Archiver.d> iterable) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Archiving files for SeriesUID: " + string);
        stringBuilder.append("\n\tFrom: ");
        stringBuilder.append(file.getAbsolutePath());
        stringBuilder.append("\n\tTo: " + file2.getAbsolutePath());
        if (this.dcmRcv != null) {
            stringBuilder.append("\n\tConnection: ");
            if (this.dcmRcv.getNetworkConnection() != null) {
                stringBuilder.append(this.dcmRcv.getNetworkConnection());
            } else {
                stringBuilder.append("Null NetworkConnection");
            }
        }
        ay.b((Object)stringBuilder, this);
        e e2 = this.createTransferAction(file, file2, dicomStoreAppEntity.getAETitle());
        String string2 = dicomStoreAppEntity.getArchiveAlias();
        if (!cn.h(string2)) {
            e2.setPacsPatientLists(Lists.newArrayList((Object[])new String[]{string2}));
        }
        e2.setSeriesFiles(iterable);
        Set<File> set = e2.performAction().a();
        ArrayList arrayList = Lists.newArrayList();
        for (File file3 : set) {
            arrayList.add(new MIMFile(file3));
        }
        return arrayList;
    }

    protected e createTransferAction(File file, File file2, String string) {
        return new e.a(file, file2, string){

            @Override
            protected void createCacheFile(File file) {
                DicomStoreService.enqueueLowPrioTask(FancyArchiveCacheCreator.createRunnable(file));
            }
        }.setDeleteIncomingFolder(true);
    }

    public void setDicomStoreService(DicomStoreService dicomStoreService) {
        this.dcmRcv = dicomStoreService;
    }
}

