/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mimvista.archive.Archiver;
import com.mimvista.archive.Parser;
import com.mimvista.dicom.server.DelayedArchiveTask;
import com.mimvista.dicom.server.DicomStoreAppEntity;
import com.mimvista.dicom.server.DicomStoreConfigLoader;
import com.mimvista.dicom.server.DicomStoreNetworkConnection;
import com.mimvista.dicom.server.DicomStoreService;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.ay;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.ConfigurationException;
import org.dcm4che2.net.DimseRSP;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.State;
import org.dcm4che2.net.pdu.AAbort;
import org.dcm4che2.net.pdu.AAssociateRJ;
import org.dcm4che2.net.pdu.AAssociateRQ;

public class DicomStoreAssociation
extends Association {
    private DicomStoreService dcmStore = null;
    private MIMFile assocDir = null;
    private File destinationArchiveFolder;
    private Multimap<String, Archiver.d> incomingSeries = HashMultimap.create();
    private List<DelayedArchiveTask> archiveTasks = Collections.synchronizedList(new ArrayList());
    private DicomObject commitResult = null;
    private DicomObject commitInfo = null;
    private HashMap<String, Boolean> SOPInstances = new HashMap();
    private boolean forCommit = false;
    private boolean commitDone = false;
    private String remoteEntityHost;
    private boolean forOpening = false;
    private long timestamp = Calendar.getInstance().getTimeInMillis();
    private String description = null;
    private String uniqueID = null;
    private String hostString = null;
    private String lastPatientName;
    private String lastModality;
    private boolean cancelled = false;
    private boolean completed = false;
    private boolean hadArchiveError = false;
    private int fileCount = 0;
    private static final NumberFormat taskNumberFormat = new DecimalFormat("000000");
    private static int nextTaskNumber = 0;
    private static Object taskNumberLock = new Object();

    static DicomStoreAssociation accept(Socket socket, NetworkConnection networkConnection, DicomStoreService dicomStoreService) throws IOException {
        DicomStoreAssociation dicomStoreAssociation = new DicomStoreAssociation(socket, networkConnection, false, dicomStoreService);
        dicomStoreAssociation.setState(State.STA2);
        dicomStoreAssociation.startARTIM(networkConnection.getRequestTimeout());
        return dicomStoreAssociation;
    }

    private DicomStoreAssociation(Socket socket, NetworkConnection networkConnection, boolean bl2, DicomStoreService dicomStoreService) throws IOException {
        super(socket, networkConnection, bl2);
        this.dcmStore = dicomStoreService;
        Date date = new Date(this.timestamp);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
        this.description = simpleDateFormat.format((Object)date);
        this.description = this.description + "_";
        Socket socket2 = this.getSocket();
        String string = socket2.getInetAddress().toString();
        string = string.substring(string.indexOf(47) + 1);
        this.description = this.description + string;
        this.description = this.description + "[" + socket2.getPort() + "-" + socket2.getLocalPort() + "]";
    }

    String description() {
        return this.description;
    }

    public void setArchiveErrorFlag(boolean bl2) {
        this.hadArchiveError = bl2;
    }

    public boolean getArchiveErrorFlag() {
        return this.hadArchiveError;
    }

    public void setLastPatientName(String string) {
        this.lastPatientName = string;
    }

    public String getLastPatientName() {
        return this.lastPatientName;
    }

    public void setLastModality(String string) {
        this.lastModality = string;
    }

    public String getLastModality() {
        return this.lastModality;
    }

    DicomStoreAppEntity getAE() {
        return (DicomStoreAppEntity)this.ae;
    }

    MIMFile getAssocDir() {
        return this.assocDir;
    }

    void setAssocDir(MIMFile mIMFile) {
        this.assocDir = mIMFile;
    }

    public void setForOpening(boolean bl2) {
        this.forOpening = bl2;
    }

    public boolean isForOpening() {
        return this.forOpening;
    }

    File getDestinationArchiveFolder() throws IOException {
        if (this.destinationArchiveFolder == null) {
            this.destinationArchiveFolder = this.getAE().getArchiveDir();
        }
        return this.destinationArchiveFolder;
    }

    File getAeTempDir() throws IOException {
        return Path.joinFile(this.getDestinationArchiveFolder(), "DICOM_STORE_TEMP", this.getAE().getAETitle());
    }

    File getAePrearchiveDir() throws IOException {
        return new File(this.getAeTempDir(), "prearchive");
    }

    String getUniqueID() {
        if (this.uniqueID == null) {
            this.uniqueID = "assoc" + this.timestamp;
        }
        return this.uniqueID;
    }

    String getHostString() {
        if (this.hostString == null) {
            this.hostString = this.associateRQ.getCallingAET() + "-" + this.getSocket().getInetAddress().toString();
        }
        return this.hostString;
    }

    void addSeriesFile(String string, Archiver.d d2) {
        this.incomingSeries.put((Object)string, (Object)d2);
    }

    void addSOPInstance(String string) {
        this.SOPInstances.put(string, false);
    }

    boolean sentSOPInstance(String string) {
        return this.SOPInstances.containsKey(string);
    }

    boolean isCommitRequested() {
        return this.forCommit;
    }

    void commit(DicomObject dicomObject) throws IOException {
        this.forCommit = true;
        this.commitInfo = dicomObject;
        this.completed = true;
        this.dcmStore.getStatusNotifier().transferFinished(this.getUniqueID(), this.completed);
        ay.b((Object)(this.getLogPrefix() + "commit received dicom files"), (Object)this);
        this.dcmStore.archiveFiles(this.incomingSeries, this, true);
    }

    void updateCommitStatus(File file) {
        if (this.forCommit) {
            ay.b((Object)(this.getLogPrefix() + "Scanning series directory " + file.getAbsolutePath()), (Object)this);
            List<File> list = this.getAllDcmFiles(file);
            for (File file2 : list) {
                String string;
                String string2 = file2.getName();
                int n2 = string2.indexOf(".dcm");
                if (n2 <= 0 || !this.sentSOPInstance(string = string2.substring(0, n2))) continue;
                this.SOPInstances.put(string, true);
            }
        }
    }

    private List<File> getAllDcmFiles(File file) {
        File[] fileArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                arrayList.addAll(this.getAllDcmFiles(file2));
                continue;
            }
            if (!file2.isFile() || !file2.getName().toLowerCase().endsWith(".dcm")) continue;
            arrayList.add(file2);
        }
        return arrayList;
    }

    synchronized void generateCommitResult() {
        this.commitResult = new BasicDicomObject();
        this.commitResult.putString(528789, VR.UI, this.commitInfo.getString(528789));
        DicomElement dicomElement = this.commitInfo.get(528793);
        DicomElement dicomElement2 = null;
        DicomElement dicomElement3 = null;
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            BasicDicomObject basicDicomObject;
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            String string = dicomObject.getString(528725);
            String string2 = dicomObject.getString(528720);
            if (string2 == null) {
                ay.d((Object)(this.getLogPrefix() + "Missing ReferencedSOPClassUID in Storage Commit Request"), (Object)this);
                this.commitResult = null;
                break;
            }
            if (string == null) {
                ay.d((Object)(this.getLogPrefix() + "Missing ReferencedSOPInstanceUID in Storage Commit Request"), (Object)this);
                this.commitResult = null;
                break;
            }
            Boolean bl2 = this.SOPInstances.get(string);
            if (bl2 == null) {
                ay.d((Object)(this.getLogPrefix() + "Missing commit result of SOP instance " + string), (Object)this);
                this.commitResult = null;
                break;
            }
            if (bl2.booleanValue()) {
                ay.a((Object)(this.getLogPrefix() + "SOP Instance " + string + " is committed"), (Object)this);
                if (dicomElement2 == null) {
                    dicomElement2 = this.commitResult.putSequence(528793);
                }
                basicDicomObject = new BasicDicomObject();
                basicDicomObject.putString(528720, VR.UI, string2);
                basicDicomObject.putString(528725, VR.UI, string);
                dicomElement2.addDicomObject((DicomObject)basicDicomObject);
                continue;
            }
            ay.d((Object)(this.getLogPrefix() + "Failed to commit SOP Instance " + string), (Object)this);
            if (dicomElement3 == null) {
                dicomElement3 = this.commitResult.putSequence(528792);
            }
            basicDicomObject = new BasicDicomObject();
            basicDicomObject.putString(528720, VR.UI, string2);
            basicDicomObject.putString(528725, VR.UI, string);
            basicDicomObject.putInt(528791, VR.US, 272);
            dicomElement3.addDicomObject((DicomObject)basicDicomObject);
        }
        ((Object)((Object)this)).notifyAll();
    }

    synchronized DicomObject waitForArchived() {
        long l2;
        int n2 = this.getAE().getCommitTimeout();
        long l3 = System.currentTimeMillis();
        long l4 = 0L;
        while (this.commitResult == null && (l4 = (long)n2 - ((l2 = System.currentTimeMillis()) - l3)) > 0L) {
            try {
                ((Object)((Object)this)).wait(l4);
            }
            catch (InterruptedException interruptedException) {
                ay.d((Object)(this.getLogPrefix() + "Skip the exception occuring in the waiting for the archive result: "), (Throwable)interruptedException, (Object)this);
            }
        }
        return this.commitResult;
    }

    void setCommitDone() {
        this.commitDone = true;
    }

    private void commitResponseInNewAssociation() {
        ay.b((Object)(this.getLogPrefix() + "Setup remote AE configuration"), (Object)this);
        if (this.remoteEntityHost == null) {
            ay.d((Object)(this.getLogPrefix() + "Failed to notify remote AE with storage commitment result due to missing its address"), (Object)this);
            return;
        }
        NetworkApplicationEntity networkApplicationEntity = new NetworkApplicationEntity();
        NetworkConnection networkConnection = new NetworkConnection();
        networkApplicationEntity.setInstalled(true);
        networkApplicationEntity.setAssociationAcceptor(true);
        networkApplicationEntity.setNetworkConnection(new NetworkConnection[]{networkConnection});
        String string = this.associateAC.getCallingAET();
        networkApplicationEntity.setAETitle(string);
        networkConnection.setHostname(this.remoteEntityHost);
        int n2 = this.dcmStore.getStorageCommitSCUPort(string);
        networkConnection.setPort(n2);
        NewThreadExecutor newThreadExecutor = new NewThreadExecutor("StgCmtSCP");
        String string2 = "[Address:" + this.remoteEntityHost + ", Port:" + n2 + ", AE Title:" + string + "]";
        ay.b((Object)(this.getLogPrefix() + "Connecting to remote AE" + string2 + " ..."), (Object)this);
        Association association = null;
        try {
            association = this.ae.connect(networkApplicationEntity, (Executor)newThreadExecutor);
        }
        catch (ConfigurationException configurationException) {
            ay.d((Object)(this.getLogPrefix() + "Failed to establish association: "), (Throwable)configurationException, (Object)this);
            return;
        }
        catch (IOException iOException) {
            ay.d((Object)(this.getLogPrefix() + "Failed to establish association: "), (Throwable)iOException, (Object)this);
            return;
        }
        catch (InterruptedException interruptedException) {
            ay.d((Object)(this.getLogPrefix() + "Failed to establish association: "), (Throwable)interruptedException, (Object)this);
            return;
        }
        ay.b((Object)(this.getLogPrefix() + "DICOM Association is established"), (Object)this);
        ay.b((Object)(this.getLogPrefix() + "Notifying remote AE with storage commitment result ..."), (Object)this);
        try {
            ay.b((Object)(this.getLogPrefix() + "Sending N-Event-Report request ..."), (Object)this);
            DimseRSP dimseRSP = association.nevent("1.2.840.10008.1.20.1", "1.2.840.10008.1.20.1.1", this.commitResult.get(528792) == null ? 1 : 2, this.commitResult, "1.2.840.10008.1.2");
            ay.b((Object)(this.getLogPrefix() + "N-Event-Report request is sent"), (Object)this);
            if (dimseRSP.next()) {
                DicomObject dicomObject = dimseRSP.getCommand();
                ay.b((Object)(this.getLogPrefix() + "Received N-Event-Report response with status code: 0x" + Integer.toHexString(dicomObject.getInt(2304))), (Object)this);
                ay.b((Object)(this.getLogPrefix() + "Notified remote AE with storage commitment result"), (Object)this);
            }
        }
        catch (IOException iOException) {
            ay.d((Object)(this.getLogPrefix() + "Failed to notify remote AE with storage commitment result: "), (Throwable)iOException, (Object)this);
        }
        catch (InterruptedException interruptedException) {
            ay.d((Object)(this.getLogPrefix() + "Failed to notify remote AE with storage commitment result: "), (Throwable)interruptedException, (Object)this);
        }
        ay.b((Object)(this.getLogPrefix() + "Releasing association to remote AE..."), (Object)this);
        try {
            association.release(false);
        }
        catch (InterruptedException interruptedException) {
            ay.d((Object)(this.getLogPrefix() + "Exception occured during the releasing of association: "), (Throwable)interruptedException, (Object)this);
        }
        ay.b((Object)(this.getLogPrefix() + "Released association to remote AE"), (Object)this);
    }

    public void run() {
        DicomStoreNetworkConnection dicomStoreNetworkConnection = (DicomStoreNetworkConnection)this.getConnector();
        dicomStoreNetworkConnection.addAssociation();
        ay.b((Object)(this.getLogPrefix() + "wait for A-ASSOCIATE-RQ"), (Object)this);
        try {
            super.run();
        }
        catch (Throwable throwable) {
            ay.d((Object)(this.getLogPrefix() + "Unexpected exception ocurred in Association " + this.description + " : "), throwable, (Object)this);
        }
        try {
            if (this.forCommit) {
                if (!this.commitDone) {
                    if (this.waitForArchived() != null) {
                        ay.b((Object)(this.getLogPrefix() + "Start to send back storage commitment result via a new association"), (Object)this);
                        this.commitResponseInNewAssociation();
                    } else {
                        ay.d((Object)(this.getLogPrefix() + "Timeout occurred when waiting for Storage Commitment Result"), (Object)this);
                    }
                }
                return;
            }
            if (this.assocDir != null) {
                if (!this.cancelled) {
                    if (this.completed) {
                        ay.b((Object)(this.getLogPrefix() + "remote AE's transfer is completed"), (Object)this);
                    } else {
                        ay.c((Object)(this.getLogPrefix() + "remote AE's transfer may be incomplete"), (Object)this);
                    }
                    ay.b((Object)(this.getLogPrefix() + "archive received dicom files"), (Object)this);
                    try {
                        this.dcmStore.archiveFiles(this.incomingSeries, this, false);
                        this.dcmStore.getStatusNotifier().updateText(this.getUniqueID(), String.format("%s %s - %d %s", Parser.formatName(this.getLastPatientName()), this.getLastModality(), this.fileCount, this.fileCount == 1 ? "file" : "files"), this.getHostString());
                        if (this.getArchiveErrorFlag()) {
                            ay.c((Object)(this.getLogPrefix() + "The archive error flag is set for " + this.getUniqueID()), (Object)this);
                        }
                        this.dcmStore.getStatusNotifier().transferFinished(this.getUniqueID(), this.completed && !this.getArchiveErrorFlag());
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)"An error occurred while archiving a series", throwable, (Object)this);
                        this.dcmStore.getStatusNotifier().transferFinished(this.getUniqueID(), false);
                    }
                } else {
                    ay.c((Object)(this.getLogPrefix() + "don't need to archive dicom files"), (Object)this);
                    this.dcmStore.getStatusNotifier().transferCancelled(this.getUniqueID());
                }
            } else {
                ay.b((Object)(this.getLogPrefix() + "no dicom files received to store"), (Object)this);
            }
        }
        finally {
            dicomStoreNetworkConnection.removeAssociation();
        }
    }

    protected void onAAssociateRQ(AAssociateRQ aAssociateRQ) throws IOException {
        ay.b((Object)(this.getLogPrefix() + "received A-ASSOCIATE-RQ"), (Object)this);
        this.associateRQ = aAssociateRQ;
        this.name = aAssociateRQ.getCallingAET() + '(' + this.serialNo + ")";
        this.startARTIM(((DicomStoreNetworkConnection)this.connector).getReceiveTimeout());
        this.setState(State.STA3);
        try {
            ay.b((Object)"start negotiation with remote AE", (Object)this);
            if ((aAssociateRQ.getProtocolVersion() & 1) == 0) {
                ay.c((Object)(this.getLogPrefix() + "remote AE's protocol version is not supported: version " + Integer.toString(aAssociateRQ.getProtocolVersion())), (Object)this);
                throw new AAssociateRJ(1, 2, 2);
            }
            if (!aAssociateRQ.getApplicationContext().equals("1.2.840.10008.3.1.1.1")) {
                ay.c((Object)(this.getLogPrefix() + "remote AE's application context name is not supported: " + aAssociateRQ.getApplicationContext()), (Object)this);
                throw new AAssociateRJ(1, 1, 2);
            }
            String string = DicomStoreConfigLoader.preProcessAETitles(aAssociateRQ.getCalledAET());
            if (string.length() == 0) {
                ay.c((Object)(this.getLogPrefix() + "remote AE's called AE Title is not recongnized: " + aAssociateRQ.getCalledAET()), (Object)this);
                throw new AAssociateRJ(1, 1, 7);
            }
            aAssociateRQ.setCalledAET(string);
            NetworkApplicationEntity networkApplicationEntity = this.getConnector().getDevice().getNetworkApplicationEntity(aAssociateRQ.getCalledAET());
            if (networkApplicationEntity == null) {
                ay.c((Object)(this.getLogPrefix() + "remote AE's called AE Title is not supported: " + string), (Object)this);
                throw new AAssociateRJ(1, 1, 7);
            }
            if (!this.getConnector().checkConnectionCountWithinLimit() || this.dcmStore.isArchiverCongested()) {
                ay.c((Object)(this.getLogPrefix() + "connection limit is exceeded"), (Object)this);
                throw new AAssociateRJ(2, 3, 1);
            }
            this.setApplicationEntity(networkApplicationEntity);
            this.associateAC = networkApplicationEntity.negotiate((Association)this, aAssociateRQ);
            this.processAC();
            this.maxOpsInvoked = this.associateAC.getMaxOpsPerformed();
            this.maxPDULength = this.minZeroAsMax(aAssociateRQ.getMaxPDULength(), networkApplicationEntity.getMaxPDULengthSend());
            ay.b((Object)(this.getLogPrefix() + "negotiation with remote AE is successful"), (Object)this);
            this.setState(State.STA6);
            this.encoder.write(this.associateAC);
            ay.b((Object)(this.getLogPrefix() + "The new association is established"), (Object)this);
            this.updateIdleTimeout();
            this.reaper.register((Association)this);
            networkApplicationEntity.addToPool((Association)this);
            SocketAddress socketAddress = this.getSocket().getRemoteSocketAddress();
            if (socketAddress != null && socketAddress instanceof InetSocketAddress) {
                this.remoteEntityHost = ((InetSocketAddress)socketAddress).getHostName();
            }
        }
        catch (AAssociateRJ aAssociateRJ) {
            ay.c((Object)(this.getLogPrefix() + "failed to negotiate with remote AE: "), (Throwable)aAssociateRJ, (Object)this);
            this.setState(State.STA13);
            this.encoder.write(aAssociateRJ);
            ay.c((Object)(this.getLogPrefix() + "failed to establish the new association"), (Object)this);
        }
    }

    protected void receivedAbort(AAbort aAbort) {
        ay.c((Object)(this.getLogPrefix() + "received A-ABORT"), (Object)this);
        super.receivedAbort(aAbort);
        this.cancelled = true;
        ay.c((Object)(this.getLogPrefix() + "current association is aborted"), (Object)this);
    }

    protected void receivedReleaseRQ() throws IOException {
        this.completed = true;
        ay.b((Object)(this.getLogPrefix() + "received A-RELEASE-RQ"), (Object)this);
        super.receivedReleaseRQ();
        ay.b((Object)(this.getLogPrefix() + "current association is released"), (Object)this);
    }

    protected void checkIdle(long l2) {
        try {
            super.checkIdle(l2);
        }
        catch (Throwable throwable) {
            ay.d((Object)(this.getLogPrefix() + "Unexpected exception ocurred in the checkIdle of Association " + this.description + " : "), throwable, (Object)this);
        }
    }

    int incrementFileCount() {
        return ++this.fileCount;
    }

    void addArchiveTask(DelayedArchiveTask delayedArchiveTask) {
        this.archiveTasks.add(delayedArchiveTask);
        delayedArchiveTask.addTaskCompletedListener(new FuncUtils.m<DelayedArchiveTask.TaskCompletedEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doIt(DelayedArchiveTask.TaskCompletedEvent taskCompletedEvent) {
                boolean bl2 = taskCompletedEvent.getTask().isSuccessful();
                DicomStoreAssociation.this.setArchiveErrorFlag(bl2);
                if (bl2) {
                    for (MIMFile mIMFile : taskCompletedEvent.getTask().getArchivedSeriesFolders()) {
                        DicomStoreAssociation.this.updateCommitStatus(mIMFile);
                    }
                }
                List list = DicomStoreAssociation.this.archiveTasks;
                synchronized (list) {
                    DicomStoreAssociation.this.archiveTasks.remove(taskCompletedEvent.getTask());
                    if (DicomStoreAssociation.this.forCommit && DicomStoreAssociation.this.archiveTasks.isEmpty()) {
                        DicomStoreAssociation.this.generateCommitResult();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNextTaskNumber() {
        Object object = taskNumberLock;
        synchronized (object) {
            int n2 = nextTaskNumber++;
            if (nextTaskNumber >= 1000000) {
                nextTaskNumber = 0;
            }
            return n2;
        }
    }

    public File createTaskDir(String string) throws IOException {
        File file = new File(this.getAePrearchiveDir(), string);
        File file2 = new File(file, taskNumberFormat.format(DicomStoreAssociation.getNextTaskNumber()));
        while (file2.exists()) {
            file2 = new File(file, taskNumberFormat.format(DicomStoreAssociation.getNextTaskNumber()));
        }
        if (!file2.mkdirs()) {
            ay.d((Object)("Failed to create new task dir: " + file2), (Object)this);
        }
        return file2;
    }
}

