/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.dicom.server.DcmStoreAeTitle;
import com.mimvista.dicom.server.DicomStoreConfigReader;
import com.mimvista.dicom.server.DicomStoreDevice;
import com.mimvista.dicom.server.NetworkApplicationEntityFactory;
import com.mimvista.preferencesNew.DicomStorePrefs;
import com.mimvista.util.ay;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.dcm4che2.data.UID;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.service.StorageService;

public class DicomStoreConfigLoader {
    private static final String[] NATIVE_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.2.840.10008.1.2"};
    private static final String[] NATIVE_LE_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    private static final String[] NON_RETIRED_TS = new String[]{"1.2.840.10008.1.2.4.80", "1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.57", "1.2.840.10008.1.2.4.90", "1.2.840.10008.1.2.1.99", "1.2.840.10008.1.2.5", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.2.840.10008.1.2", "1.2.840.10008.1.2.4.50", "1.2.840.10008.1.2.4.51", "1.2.840.10008.1.2.4.81", "1.2.840.10008.1.2.4.91", "1.2.840.10008.1.2.4.100"};
    private static final String[] NON_RETIRED_LE_TS = new String[]{"1.2.840.10008.1.2.4.80", "1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.57", "1.2.840.10008.1.2.4.90", "1.2.840.10008.1.2.1.99", "1.2.840.10008.1.2.5", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2", "1.2.840.10008.1.2.4.50", "1.2.840.10008.1.2.4.51", "1.2.840.10008.1.2.4.81", "1.2.840.10008.1.2.4.91", "1.2.840.10008.1.2.4.100"};
    private static ImmutableSet<String> storageSops = null;
    private static final ImmutableSet<String> extraBonusSupportedSops = ImmutableSet.of((Object)"1.2.840.10008.1.9");
    private String[] tsuids;
    private String configFileName;
    private DicomStoreConfigReader reader;
    private Map<String, Integer> remotePortsMap;
    private NetworkConnection nc;
    private StorageService dcmRcv;
    private DicomStoreDevice device;

    public DicomStoreConfigLoader() {
        boolean bl2 = DicomStorePrefs.nativeTransferSyntaxesOnly.getValue();
        if (bl2) {
            this.tsuids = NATIVE_TS;
        } else {
            String[] stringArray = DicomStorePrefs.disallowedTransferSyntaxes.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : NON_RETIRED_TS) {
                arrayList.add(string);
            }
            for (String string : stringArray) {
                if (arrayList.remove(string = string.trim())) {
                    ay.b((Object)("DISALLOWING TRANSFER SYNTAX::: " + DicomStoreConfigLoader.uidName(string) + " (" + string + ")"), this);
                    continue;
                }
                try {
                    if (!arrayList.remove(UID.forName((String)string))) continue;
                    ay.b((Object)("DISALLOWING TRANSFER SYNTAX::: " + string + " (" + UID.forName((String)string) + ") "), this);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ay.d((Object)("Attempting to disallow unknown transfer syntax: " + string), (Throwable)illegalArgumentException, this);
                }
            }
            this.tsuids = arrayList.toArray(new String[0]);
        }
    }

    public void setNetworkConnection(NetworkConnection networkConnection) {
        this.nc = networkConnection;
    }

    public void setStorageService(StorageService storageService) {
        this.dcmRcv = storageService;
    }

    public void setDevice(DicomStoreDevice dicomStoreDevice) {
        this.device = dicomStoreDevice;
    }

    public boolean load() {
        DicomStoreConfigReader dicomStoreConfigReader = new DicomStoreConfigReader();
        if (!dicomStoreConfigReader.validateConfigs()) {
            return false;
        }
        try {
            Collection<NetworkApplicationEntity> collection = this.getAeTitlesFromConfig(dicomStoreConfigReader);
            boolean bl2 = dicomStoreConfigReader.isPromiscuous();
            ay.b((Object)("Receive promiscuously: " + (bl2 ? "yes" : "no")), this);
            this.device.setNetworkApplicationEntity(collection.toArray(new NetworkApplicationEntity[0]), bl2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ay.d((Object)fileNotFoundException, DicomStoreConfigLoader.class);
            return false;
        }
        this.remotePortsMap = dicomStoreConfigReader.getRemotePortMap();
        this.reader = dicomStoreConfigReader;
        return true;
    }

    public DicomStoreConfigReader getConfigReader() {
        if (this.reader == null) {
            this.reader = new DicomStoreConfigReader();
        }
        return this.reader;
    }

    private Collection<NetworkApplicationEntity> getAeTitlesFromConfig(DicomStoreConfigReader dicomStoreConfigReader) throws FileNotFoundException {
        DcmStoreAeTitle dcmStoreAeTitle2;
        ArrayList<NetworkApplicationEntity> arrayList = new ArrayList<NetworkApplicationEntity>();
        NetworkApplicationEntityFactory networkApplicationEntityFactory = this.getAeFactory();
        for (DcmStoreAeTitle dcmStoreAeTitle2 : dicomStoreConfigReader.getAdditionalAeTitles()) {
            arrayList.add(networkApplicationEntityFactory.buildAe(dcmStoreAeTitle2, dicomStoreConfigReader));
        }
        DcmStoreAeTitle dcmStoreAeTitle3 = (DcmStoreAeTitle)DicomStorePrefs.defaultAETitle.getValue();
        dcmStoreAeTitle2 = networkApplicationEntityFactory.buildAe(dcmStoreAeTitle3, dicomStoreConfigReader);
        arrayList.add((NetworkApplicationEntity)dcmStoreAeTitle2);
        return arrayList;
    }

    public Integer getRemotePortForAETitle(String string) {
        return this.remotePortsMap.get(string);
    }

    public NetworkApplicationEntityFactory getAeFactory() {
        return new NetworkApplicationEntityFactory(this.nc, this.dcmRcv, this.tsuids);
    }

    public static String preProcessAETitles(String string) {
        if ((string = string.trim().toUpperCase()).length() > 16) {
            return "";
        }
        char[] cArray = string.toCharArray();
        boolean bl2 = false;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (Character.isLetterOrDigit(cArray[i2]) || cArray[i2] == '-' || cArray[i2] == '.' || cArray[i2] == '_') continue;
            cArray[i2] = 95;
            bl2 = true;
        }
        return bl2 ? new String(cArray) : string;
    }

    private static String uidName(String string) {
        for (Field field : UID.class.getFields()) {
            try {
                if (!UID.forName((String)field.getName()).equals(string)) continue;
                return field.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "UNKNOWN";
    }

    public static ImmutableSet<String> getAllStandardStorageSopClassUids() {
        if (storageSops == null) {
            HashSet hashSet = Sets.newHashSet();
            try {
                for (Field field : UID.class.getFields()) {
                    Object object;
                    if ((field.getModifiers() & 8) == 0 || (object = field.get(null)) == null || !(object instanceof String)) continue;
                    String string = (String)object;
                    String string2 = field.getName();
                    String string3 = string2.toLowerCase(Locale.ENGLISH);
                    if (string3.contains("storagecommitment") || !string.startsWith("1.2.840.10008.5.1.4.1.1") && !string3.contains("storage")) continue;
                    hashSet.add(string);
                }
            }
            catch (Throwable throwable) {
                ay.d((Object)"UI reflect error.", throwable, DicomStoreConfigLoader.class);
            }
            storageSops = ImmutableSet.copyOf((Collection)hashSet);
        }
        return storageSops;
    }

    public static String[] getSupportedSopUids() {
        HashSet hashSet = Sets.newHashSet();
        hashSet.addAll(DicomStoreConfigLoader.getAllStandardStorageSopClassUids());
        hashSet.addAll(extraBonusSupportedSops);
        hashSet.addAll(Lists.newArrayList((Object[])DicomStorePrefs.additionalSupportedSopClasses.getValue()));
        return hashSet.toArray(new String[0]);
    }
}

