/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.mimvista.archive.remote.MIMpacsConfig;
import com.mimvista.archive.remote.RemoteQueryServer;
import com.mimvista.dicom.server.DcmStoreAeTitle;
import com.mimvista.dicom.server.DicomStoreConfigLoader;
import com.mimvista.dicom.server.gui.WindowsServiceControl;
import com.mimvista.file.PathUtils;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.metabase.s;
import com.mimvista.osdep.GetOSPath;
import com.mimvista.preferencesNew.DicomLocationsPrefs;
import com.mimvista.preferencesNew.DicomStorePrefs;
import com.mimvista.preferencesNew.MimpacsPrefs;
import com.mimvista.preferencesNew.g;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.service.SimpleServiceControl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class DicomStoreConfigReader {
    public static final int MAX_AE_TITLE_LENGTH = 16;
    private Map<String, DcmStoreAeTitle> aeTitleMap = new HashMap<String, DcmStoreAeTitle>();
    private Map<String, Integer> remotePortsMap = new HashMap<String, Integer>();

    public boolean validateConfigs() {
        try {
            PathUtils.checkArchivePath(this.getTempFolder());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ay.d((Object)"DICOM store temp path failed validation", (Throwable)illegalArgumentException, this);
            return false;
        }
        TreeSet treeSet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        Collection<DcmStoreAeTitle> collection = this.getAllNonRemoteAeTitles();
        for (DcmStoreAeTitle dcmStoreAeTitle : collection) {
            try {
                this.checkAeTitle(dcmStoreAeTitle);
            }
            catch (Exception exception) {
                ay.d((Object)"aeTitle failed validation", (Throwable)exception, this);
                return false;
            }
            if (!treeSet.add(dcmStoreAeTitle.getAETitle())) {
                ay.d((Object)("Multiple AE titles configured with the same AE title: " + dcmStoreAeTitle.getAETitle() + ". Discovered with : " + dcmStoreAeTitle), this);
                return false;
            }
            ay.b((Object)("Validated Application Entity: " + dcmStoreAeTitle), this);
        }
        this.loadRemoteAeTitlesIntoMemory();
        this.loadAeTitlesIntoMemory(collection);
        return true;
    }

    public void checkAeTitle(DcmStoreAeTitle dcmStoreAeTitle) {
        Preconditions.checkArgument((!cn.g(DicomStoreConfigLoader.preProcessAETitles(dcmStoreAeTitle.getAETitle())) ? 1 : 0) != 0, (Object)"AE title doesn't have a valid name");
        if (!dcmStoreAeTitle.isMimpacsPatientList()) {
            File file = dcmStoreAeTitle.getArchiveFolder();
            Preconditions.checkArgument((file != null ? 1 : 0) != 0, (String)"Failed to get the archive path for AE title: %s", (Object[])new Object[]{dcmStoreAeTitle});
            if (!LicenseTransformer.isDevelopment()) {
                try {
                    PathUtils.checkArchivePath(file);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Invalid archive folder for AE: " + dcmStoreAeTitle, illegalArgumentException);
                }
            }
            file.mkdirs();
        }
    }

    public void loadAeTitlesIntoMemory(Collection<DcmStoreAeTitle> collection) {
        this.aeTitleMap.clear();
        for (DcmStoreAeTitle dcmStoreAeTitle : collection) {
            this.aeTitleMap.put(dcmStoreAeTitle.getAETitle().toUpperCase(), dcmStoreAeTitle);
        }
    }

    public Collection<DcmStoreAeTitle> getAllNonRemoteAeTitles() {
        Collection<DcmStoreAeTitle> collection = this.getAdditionalAeTitles();
        collection.add((DcmStoreAeTitle)DicomStorePrefs.defaultAETitle.getValue());
        return collection;
    }

    public Collection<DcmStoreAeTitle> getAdditionalAeTitles() {
        return DicomStorePrefs.additionalAETitles.getValue();
    }

    public void addAdditionalAeTitle(DcmStoreAeTitle dcmStoreAeTitle, boolean bl2) {
        this.checkAeTitle(dcmStoreAeTitle);
        if (bl2) {
            this.loadAeTitlesIntoMemory(this.getAllNonRemoteAeTitles());
        }
        Preconditions.checkArgument((!this.aeTitleMap.containsKey(dcmStoreAeTitle.getAETitle().toUpperCase()) ? 1 : 0) != 0, (String)"Attempted to add a duplicate AE title: %s", (Object[])new Object[]{dcmStoreAeTitle});
        DicomStorePrefs.additionalAETitles.addValue(dcmStoreAeTitle);
        this.aeTitleMap.put(dcmStoreAeTitle.getAETitle().toUpperCase(), dcmStoreAeTitle);
    }

    public void removeAllExtraAETitles() {
        Iterator iterator = ((ArrayList)DicomStorePrefs.additionalAETitles.getValue()).iterator();
        while (iterator.hasNext()) {
            DcmStoreAeTitle dcmStoreAeTitle = (DcmStoreAeTitle)iterator.next();
            DicomStorePrefs.additionalAETitles.removeValue(dcmStoreAeTitle);
        }
    }

    public Map<String, Integer> getRemotePortMap() {
        if (this.remotePortsMap == null || this.remotePortsMap.isEmpty()) {
            this.loadRemoteAeTitlesIntoMemory();
        }
        return this.remotePortsMap;
    }

    public void loadRemoteAeTitlesIntoMemory() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Object object = DicomStorePrefs.remoteAETitles.getValue();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            com.mimvista.preferencesNew.s s2 = (com.mimvista.preferencesNew.s)iterator.next();
            String string = s2.getAeTitle();
            int n2 = s2.getPort();
            hashMap.put(string, n2);
        }
        this.remotePortsMap = hashMap;
    }

    public int getFileBufferSize() {
        return DicomStorePrefs.fileBufferSize.getValue();
    }

    public int getTaskQueueThreshold() {
        return DicomStorePrefs.queueThreshold.getValue();
    }

    public int getTaskQueueWaitTime() {
        return DicomStorePrefs.queueWaitTime.getValue();
    }

    public int getAssociationReaperPeriod() {
        return DicomStorePrefs.reaper.getValue();
    }

    public int getPortNumber() {
        return DicomStorePrefs.port.getValue();
    }

    public void setPortNumber(int n2) {
        if (n2 < 1 || n2 > 65535) {
            ay.d((Object)("Attempting to set invalid port number: " + n2), this);
            throw new IllegalArgumentException();
        }
        if (n2 < 256) {
            ay.c((Object)("Attempting to set DICOM store to run on reserved port: " + n2 + ", but allowing anyway."), this);
        }
        DicomStorePrefs.port.setValue(n2);
    }

    public int getMaxAssociations() {
        return DicomStorePrefs.maxAssociations.getValue();
    }

    public void setMaxAssociations(int n2) {
        ay.b((Object)("Setting DICOM store max associations to: " + n2), this);
        DicomStorePrefs.maxAssociations.setValue(n2);
    }

    public int getAssocationRequestTimeout() {
        return DicomStorePrefs.associationRequestTimeout.getValue();
    }

    public int getDataReceiveTimeout() {
        return DicomStorePrefs.dataReceiveTimeout.getValue();
    }

    public int getSocketCloseDelay() {
        return DicomStorePrefs.socketCloseDelay.getValue();
    }

    public boolean getTcpNoDelay() {
        return DicomStorePrefs.tcpNoDelay.getValue();
    }

    public int getDefaultStorageCommitPort() {
        return DicomStorePrefs.defaultStorageCommitPort.getValue();
    }

    public long getArchiveDelay() {
        return DicomStorePrefs.archiveDelay.getValue();
    }

    public File getTempFolder() {
        return DicomStorePrefs.tempPath.getValue();
    }

    public boolean isPromiscuous() {
        return DicomStorePrefs.promiscuousReceiver.getValue();
    }

    public void setPromiscuous(boolean bl2) {
        DicomStorePrefs.promiscuousReceiver.setValue(bl2);
    }

    public int getHeapSize() {
        if (GetOSPath.isWindows()) {
            WindowsServiceControl windowsServiceControl = new WindowsServiceControl(SimpleServiceControl.MimService.a);
            String string = windowsServiceControl.readValueFromServiceConfig("vm.heapsize.preferred");
            if (cn.g(string)) {
                string = "512";
            }
            return Integer.valueOf(string);
        }
        return DicomStorePrefs.heapSize.getValue();
    }

    public void setHeapSize(int n2) {
        if (n2 <= 0) {
            ay.d((Object)("Attempting to set negative heap size: " + n2), this);
            throw new IllegalArgumentException();
        }
        if (n2 <= 512 || n2 >= 4096) {
            ay.c((Object)("Setting heap size to a possibly bad value: " + n2 + ", but carry on."), this);
        }
        if (GetOSPath.isWindows()) {
            WindowsServiceControl windowsServiceControl = new WindowsServiceControl(SimpleServiceControl.MimService.a);
            try {
                windowsServiceControl.addPropertyToServiceConfig("vm.heapsize.preferred", String.valueOf(n2));
            }
            catch (IOException iOException) {
                ay.d((Object)"Exception setting heapsize for dcmstore service!", (Throwable)iOException, DicomStoreConfigReader.class);
            }
        } else {
            DicomStorePrefs.heapSize.setValue(n2);
        }
    }

    private File getMIMpacsArchivePathForAlias(String string, File file) {
        File file2;
        block4: {
            MIMpacsConfig.PacsType pacsType;
            block3: {
                pacsType = this.getStorageServerMode();
                file2 = null;
                if (pacsType != MIMpacsConfig.PacsType.a) break block3;
                String string2 = MIMpacsConfig.m();
                if (cn.g(string2)) break block4;
                file2 = new File(string2);
                break block4;
            }
            if (pacsType == MIMpacsConfig.PacsType.b) {
                Object object = MimpacsPrefs.simpleRPLs.getValue();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    g.b b2 = (g.b)iterator.next();
                    String string3 = b2.getPatientListName();
                    File file3 = b2.getPatientListPath();
                    if (!string.equals(string3) || file3 == null) continue;
                    file2 = file3;
                    break;
                }
            }
        }
        if (file2 == null && file != null && !file.getPath().isEmpty()) {
            return file;
        }
        return file2;
    }

    private MIMpacsConfig.PacsType getStorageServerMode() {
        MIMpacsConfig.PacsType pacsType = MIMpacsConfig.h();
        if (!MIMpacsConfig.PacsType.a(pacsType)) {
            return pacsType;
        }
        try {
            RemoteQueryServer remoteQueryServer = s.a("127.0.0.1", MIMpacsConfig.f);
            if (remoteQueryServer.isRunningInStorageServerMode()) {
                return MIMpacsConfig.PacsType.a;
            }
            return MIMpacsConfig.PacsType.b;
        }
        catch (Exception exception) {
            return MIMpacsConfig.PacsType.c;
        }
    }

    public static String getIdentifierForAeTitle(String string) {
        DicomLocationsPrefs.a a2 = DicomLocationsPrefs.a.getServerHost();
        return a2.getHost() + " " + a2.getPort() + " " + string;
    }

    public static void main(String[] stringArray) {
    }

    private void printAeTitleInfo() {
        for (DcmStoreAeTitle dcmStoreAeTitle : this.getAllNonRemoteAeTitles()) {
            System.out.println(dcmStoreAeTitle);
        }
    }

    public static class DicomStoreServiceConfigNames {
        public static final String AE_TITLE_NAME_INDEXED = "AE TITLE";
        public static final String ARCHIVE_ALIAS = "ARCHIVE ALIAS";
        public static final String ARCHIVE_ALIAS_INDEXED = "ARCHIVE ALIAS";
        public static final String ARCHIVE_DELAY = "ARCHIVE DELAY";
        public static final String ARCHIVE_PATH = "ARCHIVE PATH";
        public static final String ASSOCATION_REQUEST_TIMEOUT = "ASSOCIATION REQUEST TIMEOUT";
        public static final String CALLED_AETS = "CALLED-AETS";
        public static final String COMMIT_SUPPORT = "COMMIT SUPPORT";
        public static final String COMMIT_TIMEOUT = "COMMIT TIMEOUT";
        public static final String DATA_RECEIVE_TIMEOUT = "DATA RECEIVE TIMEOUT";
        public static final String DEFAULT_STORAGE_COMMIT_PORT = "DEFAULT STORAGE COMMIT PORT";
        public static final String FILE_BUFFER_SIZE = "FILE BUFFER SIZE";
        public static final String HEAP_SIZE = "HEAP SIZE";
        public static final String IDLE_TIMEOUT = "IDLE TIMEOUT";
        public static final String MAX_ASSOCIATIONS = "MAX ASSOCIATIONS";
        public static final String MAX_CLIENTS = "MAX CLIENTS";
        public static final String MAX_OPS_PERFORMED = "MAX OPS PERFORMED";
        public static final String NATIVE_TS_ONLY = "NATIVE TRANSFER SYNTAXES ONLY";
        public static final String NUMBER_PATIENT_LISTS = "NUMBER OF PATIENT LISTS";
        public static final String NUMBER_REMOTE_AES = "NUMBER OF REMOTE AES";
        public static final String PACK_PDV = "PACK PDV";
        public static final String PATIENT_LIST_NAME_INDEXED = "PATIENT LIST NAME";
        public static final String PATIENT_LIST_PATH_INDEXED = "PATIENT LIST PATH";
        public static final String PDU_RECEIVE_SIZE = "PDU RECEIVE SIZE";
        public static final String PDU_SEND_SIZE = "PDU SEND SIZE";
        public static final String PORT = "PORT";
        public static final String PROMISCUOUS_MODE = "PROMISCUOUS RECEIVER";
        public static final String REAPER = "REAPER";
        public static final String SOCKET_CLOSE_DELAY = "SOCKET CLOSE DELAY";
        public static final String TCP_NO_DELAY = "TCP NO DELAY";
        public static final String TEMP_PATH = "TEMP PATH";
        public static final String QUEUE_THRESHOLD = "QUEUE THRESHOLD";
        public static final String QUEUE_WAIT_TIME = "QUEUE WAIT TIME";
    }

    public static class DefaultDicomStoreConfigs {
        public static final String ARCHIVE_ALIAS = "";
        public static final long ARCHIVE_DELAY = 1000L;
        public static final String ARCHIVE_PATH = GetOSPath.convertPath("C:\\MIM_DATA\\ARCHIVE");
        public static final int ASSOC_REQ_TIMEOUT = 5000;
        public static final String CALLED_AETITLE = "AE_MIM";
        public static final int DATA_RECV_TIMEOUT = 30000;
        public static final int FILE_BUFFER_SIZE = 8096;
        public static final int HEAP_SIZE = 512;
        public static final int MAX_ASSOCIATIONS = 8;
        public static final int PATIENT_LIST_COUNT = 0;
        public static final int PORT = 4008;
        public static final boolean PROMISCUOUS_MODE = true;
        public static final boolean MCA_PROMISCUOUS_MODE = false;
        public static final int QUEUE_THRESHOLD = 100;
        public static final int QUEUE_WAIT_TIME = 500;
        public static final int REAPER_PERIOD = 10000;
        public static final int SOCK_CLOSE_DELAY = 50;
        public static final boolean TCP_NO_DELAY = true;
        public static final String TEMP_PATH = GetOSPath.convertPath("C:\\MIM_DATA\\SERVER");
    }
}

