/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server;

import com.mimvista.dicom.server.DicomStoreAssociation;
import com.mimvista.dicom.server.DicomStoreService;
import com.mimvista.util.ay;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.dcm4che2.net.NetworkConnection;

class DicomStoreNetworkConnection
extends NetworkConnection {
    private DicomStoreService dcmStore = null;
    private int receiveTimeout = 30000;
    private volatile boolean stopped = false;
    private volatile int aliveAssocCount = 0;
    private Object lock = new Object();

    DicomStoreNetworkConnection(DicomStoreService dicomStoreService) {
        this.dcmStore = dicomStoreService;
    }

    public synchronized void bind(final Executor executor) throws IOException {
        if (this.getDevice() == null) {
            throw new IllegalStateException("Device not initalized");
        }
        if (!this.isListening()) {
            throw new IllegalStateException("Only initiates associations - " + (Object)((Object)this));
        }
        if (this.server != null) {
            throw new IllegalStateException("Already listening - " + this.server);
        }
        this.server = this.isTLS() ? this.createTLSServerSocket() : new ServerSocket();
        this.server.bind(this.getEndPoint(), this.backlog);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                SocketAddress socketAddress = DicomStoreNetworkConnection.this.server.getLocalSocketAddress();
                ay.b((Object)("Start listening on " + socketAddress), this);
                DicomStoreNetworkConnection.this.stopped = false;
                try {
                    while (true) {
                        Socket socket = DicomStoreNetworkConnection.this.server.accept();
                        DicomStoreNetworkConnection.this.setSocketOptions(socket);
                        if (!DicomStoreNetworkConnection.this.checkConnection(socket)) continue;
                        DicomStoreAssociation dicomStoreAssociation = DicomStoreAssociation.accept(socket, DicomStoreNetworkConnection.this, DicomStoreNetworkConnection.this.dcmStore);
                        executor.execute((Runnable)((Object)dicomStoreAssociation));
                    }
                }
                catch (Throwable throwable) {
                    while (DicomStoreNetworkConnection.this.aliveAssocCount != 0) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            ay.d((Object)interruptedException, this);
                        }
                    }
                    DicomStoreNetworkConnection.this.stopped = true;
                    ay.b((Object)("Stop listening on " + socketAddress), this);
                    return;
                }
            }
        });
    }

    public boolean checkConnectionCountWithinLimit() {
        if (this.maxScpAssociations == 0) {
            return true;
        }
        return super.checkConnectionCountWithinLimit();
    }

    void setReceiveTimeout(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this.receiveTimeout = n2;
    }

    int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAssociation() {
        Object object = this.lock;
        synchronized (object) {
            ++this.aliveAssocCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAssociation() {
        Object object = this.lock;
        synchronized (object) {
            --this.aliveAssocCount;
        }
    }

    void waitForExit() {
        this.unbind();
        while (!this.stopped) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                ay.d((Object)interruptedException, (Object)this);
            }
        }
    }
}

