/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server;

import com.google.common.collect.Multimap;
import com.mimvista.ExternallyVisible;
import com.mimvista.archive.Archiver;
import com.mimvista.archive.Parser;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.server.DcmRcvStatusNotifierWrapper;
import com.mimvista.dicom.server.DelayedArchiveTask;
import com.mimvista.dicom.server.DicomQRClientDataProxy;
import com.mimvista.dicom.server.DicomStoreAppEntity;
import com.mimvista.dicom.server.DicomStoreArchivingDelegate;
import com.mimvista.dicom.server.DicomStoreAssociation;
import com.mimvista.dicom.server.DicomStoreConfigLoader;
import com.mimvista.dicom.server.DicomStoreDevice;
import com.mimvista.dicom.server.DicomStoreNetworkConnection;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.file.j;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.cm;
import com.mimvista.util.co;
import com.mimvista.util.logging.a.c;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.DicomServiceException;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.PDVInputStream;
import org.dcm4che2.net.service.StorageService;

@ExternallyVisible
public class DicomStoreService
extends StorageService {
    private static DicomStoreService instance;
    public static final String TEMP_FOLDER_NAME = "DICOM_STORE_TEMP";
    private Executor executor = Executors.newCachedThreadPool();
    private DicomStoreDevice device;
    private DicomQRClientDataProxy qrProxy = new DicomQRClientDataProxy();
    private int fileBufferSize = 8096;
    public static final int ARCHIVE_DELAY = 1000;
    public static final c receiveLog;
    private static final boolean RUNNING_IN_BONUS_MODE;
    private static ThreadPoolExecutor workQueue;
    private NetworkConnection nc = new DicomStoreNetworkConnection(this);
    private DicomStoreConfigLoader configLoader;
    private DcmRcvStatusNotifierWrapper statusNotifier;
    private DicomStoreArchivingDelegate archivingDelegate;
    private static char[] SECRET;
    private String keyStoreURL = "resource:tls/test_sys_2.p12";
    private char[] keyStorePassword = SECRET;
    private char[] keyPassword;
    private String trustStoreURL = "resource:tls/mesa_certs.jks";
    private char[] trustStorePassword = SECRET;

    public static DicomStoreService getInstance() {
        return instance;
    }

    public DicomStoreService() {
        this(!RUNNING_IN_BONUS_MODE);
    }

    public DicomStoreService(boolean bl2) {
        this(new DicomStoreArchivingDelegate(), new DicomStoreConfigLoader(), new DicomStoreDevice("DCMRCV"), bl2);
    }

    public DicomStoreService(DicomStoreArchivingDelegate dicomStoreArchivingDelegate, DicomStoreConfigLoader dicomStoreConfigLoader, DicomStoreDevice dicomStoreDevice, boolean bl2) {
        super(DicomStoreConfigLoader.getSupportedSopUids());
        instance = this;
        this.configLoader = dicomStoreConfigLoader;
        this.device = dicomStoreDevice;
        this.initializeConfigDaemon();
        CommandUtils.setIncludeUIDinRSP((boolean)true);
        this.initializeTaskQueue();
        this.initializeDevice();
        this.initializeNetworkConnection();
        if (!this.initializeNetworkApplicationEntities()) {
            throw new RuntimeException("Failed to initialize network applications");
        }
        this.archivingDelegate = dicomStoreArchivingDelegate;
        this.archivingDelegate.setDicomStoreService(this);
        this.fileBufferSize = dicomStoreConfigLoader.getConfigReader().getFileBufferSize();
        this.statusNotifier = new DcmRcvStatusNotifierWrapper(this, !bl2);
    }

    public final void setHostname(String string) {
        this.nc.setHostname(string);
    }

    public final void setPort(int n2) {
        this.nc.setPort(n2);
    }

    public DicomStoreConfigLoader getConfigLoader() {
        return this.configLoader;
    }

    public DicomStoreArchivingDelegate getArchiveDelegate() {
        return this.archivingDelegate;
    }

    public boolean start() {
        try {
            this.device.startListening(this.executor);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DICOM Server started on port " + this.nc.getPort() + " on following interfaces: ");
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    stringBuilder.append("\n\t");
                    stringBuilder.append(inetAddress.getHostAddress());
                }
            }
            ay.b((Object)stringBuilder, (Object)this);
            this.archiveTempFolderContents();
            return true;
        }
        catch (IOException iOException) {
            ay.d((Object)"DICOM Server failed to start", (Throwable)iOException, (Object)this);
            return false;
        }
    }

    public void stop() {
        ay.a((Object)"About to shut down daemon", (Object)this);
        ay.a((Object)"Wait for Exit", (Object)this);
        ((DicomStoreNetworkConnection)this.nc).waitForExit();
        DelayedArchiveTask.waitForTasksToComplete(5L, TimeUnit.SECONDS);
        if (!workQueue.isShutdown()) {
            try {
                CountDownLatch countDownLatch = new CountDownLatch(1);
                workQueue.execute(new PriorityRunnable(5, () -> {
                    ay.e("Queue drained!");
                    countDownLatch.countDown();
                    workQueue.shutdown();
                }));
                countDownLatch.await();
                if (!workQueue.isShutdown()) {
                    workQueue.shutdown();
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                ay.d((Object)"Tried to submit a task to a shutdown workQueue", (Throwable)rejectedExecutionException, (Object)this);
            }
            catch (InterruptedException interruptedException) {
                ay.d((Object)"Interrupted while waiting for workQueue shutdown", (Throwable)interruptedException, (Object)this);
            }
        }
        ay.a((Object)"Wait for queue to be terminated", (Object)this);
        int n2 = 0;
        block5: while (true) {
            try {
                do {
                    workQueue.shutdown();
                    if (workQueue.awaitTermination(1L, TimeUnit.SECONDS)) break block5;
                } while (++n2 != 10);
                ay.c((Object)"Timed out waiting for DICOM store service workQueue to finish processing.", (Object)this);
            }
            catch (InterruptedException interruptedException) {
                ay.d((Object)"Error waiting on shutting down Thread", (Throwable)interruptedException, (Object)this);
                continue;
            }
            break;
        }
        ay.a((Object)"We are finally done with the test!", (Object)this);
    }

    private void archiveTempFolderContents() {
        for (DicomStoreAppEntity dicomStoreAppEntity : this.device.getDicomStoreAppEntities()) {
            File file = dicomStoreAppEntity.getOldPrearchiveDir();
            if (file.exists()) {
                this.handlePrearchiveContents(dicomStoreAppEntity, file);
            }
            for (File file2 : dicomStoreAppEntity.getAllPossibleTempDirs()) {
                File file3 = new File(file2, "prearchive");
                if (!file3.exists()) continue;
                this.handlePrearchiveContents(dicomStoreAppEntity, file3);
            }
        }
    }

    private void handlePrearchiveContents(DicomStoreAppEntity dicomStoreAppEntity, File file) {
        boolean bl2 = false;
        File[] fileArray = file.listFiles(j.a);
        if (fileArray == null) {
            ay.d((Object)("STARTUP_ARCHIVING: Cannot list contents of prearchive folder: " + file), (Object)this);
            return;
        }
        if (fileArray.length == 0) {
            return;
        }
        for (File file2 : fileArray) {
            File[] fileArray2 = file2.listFiles(j.a);
            if (fileArray2 == null) {
                ay.d((Object)("STARTUP_ARCHIVING: Cannot list contents of series folder: " + file2), (Object)this);
                continue;
            }
            if (fileArray2.length == 0 && !MIMFile.a(file2)) {
                ay.d((Object)("STARTUP_ARCHIVING: Couldn't delete empty series folder: " + file2), (Object)this);
            }
            for (File file3 : fileArray2) {
                bl2 = true;
                DicomStoreService.enqueueHighPrioTask(() -> {
                    File[] fileArray = file3.listFiles(j.b(new String[]{".dcm"}));
                    if (fileArray == null) {
                        ay.d((Object)("STARTUP_ARCHIVING: Cannot list contents of task folder: " + file3), (Object)this);
                        return;
                    }
                    try {
                        File[] fileArray2;
                        if (fileArray.length > 0) {
                            fileArray2 = file2.getName();
                            this.archivingDelegate.archiveOneSeries(dicomStoreAppEntity, (String)fileArray2, file3);
                        }
                        if (!MIMFile.a(file3)) {
                            ay.d((Object)("STARTUP_ARCHIVING: Couldn't delete task folder: " + file3), (Object)this);
                        }
                        if ((fileArray2 = file2.listFiles(j.a)) != null && fileArray2.length == 0 && !MIMFile.a(file2)) {
                            ay.d((Object)("STARTUP_ARCHIVING: Couldn't delete empty series folder: " + file2), (Object)this);
                        }
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)"STARTUP_ARCHIVING: Error during startup archiving", throwable, (Object)this);
                    }
                });
            }
        }
        if (bl2) {
            DicomStoreService.enqueueHighPrioTask(() -> {
                String string = String.format("STARTUP_ARCHIVING: Finished archiving %d series from AE prearchive dir: %s", fileArray.length, file.getAbsolutePath());
                ay.b((Object)string, (Object)this);
            });
        }
    }

    private void initializeTaskQueue() {
        PriorityBlockingQueue<Runnable> priorityBlockingQueue = new PriorityBlockingQueue<Runnable>(11, (runnable, runnable2) -> {
            PriorityRunnable priorityRunnable = (PriorityRunnable)runnable;
            PriorityRunnable priorityRunnable2 = (PriorityRunnable)runnable2;
            if (priorityRunnable.priority != priorityRunnable2.priority) {
                return priorityRunnable.priority - priorityRunnable2.priority;
            }
            return Long.valueOf(priorityRunnable.taskId).compareTo(priorityRunnable2.taskId);
        });
        workQueue = new ThreadPoolExecutor(1, 1, 500L, TimeUnit.MILLISECONDS, priorityBlockingQueue);
    }

    private void initializeDevice() {
        int n2 = this.configLoader.getConfigReader().getAssociationReaperPeriod();
        ay.b((Object)("DICOM Store device association reaper period: " + n2 + "ms"), (Object)this);
        this.device.setNetworkConnection(this.nc);
        this.device.setAssociationReaperPeriod(n2);
    }

    private void initializeNetworkConnection() {
        int n2 = this.configLoader.getConfigReader().getPortNumber();
        int n3 = this.configLoader.getConfigReader().getMaxAssociations();
        int n4 = this.configLoader.getConfigReader().getAssocationRequestTimeout();
        int n5 = this.configLoader.getConfigReader().getDataReceiveTimeout();
        int n6 = this.configLoader.getConfigReader().getSocketCloseDelay();
        boolean bl2 = this.configLoader.getConfigReader().getTcpNoDelay();
        StringBuilder stringBuilder = new StringBuilder("Initializing DICOM Store Service NetworkConnection:");
        stringBuilder.append("\n\tPort: ");
        stringBuilder.append(n2);
        stringBuilder.append(", Max Associations: ");
        stringBuilder.append(n3);
        stringBuilder.append("\n\tAssociation Request Timeout: ");
        stringBuilder.append(n4);
        stringBuilder.append(" ms, Data Receive Timeout: ");
        stringBuilder.append(n5);
        stringBuilder.append(" ms, Socket Close Delay: ");
        stringBuilder.append(n6);
        stringBuilder.append(" ms, TCP No Delay: ");
        stringBuilder.append(bl2 ? "yes" : "no");
        ay.b((Object)stringBuilder, (Object)this);
        this.nc.setPort(n2);
        this.nc.setMaxScpAssociations(n3);
        this.nc.setRequestTimeout(n4);
        ((DicomStoreNetworkConnection)this.nc).setReceiveTimeout(n5);
        this.nc.setSocketCloseDelay(n6);
        this.nc.setTcpNoDelay(bl2);
    }

    private void initializeConfigDaemon() {
        this.configLoader.setNetworkConnection(this.nc);
        this.configLoader.setStorageService(this);
        this.configLoader.setDevice(this.device);
    }

    private boolean initializeNetworkApplicationEntities() {
        return this.configLoader.load();
    }

    DcmRcvStatusNotifierWrapper getStatusNotifier() {
        return this.statusNotifier;
    }

    int getStorageCommitSCUPort(String string) {
        Integer n2 = this.configLoader.getRemotePortForAETitle(string);
        if (n2 != null) {
            return n2;
        }
        return this.configLoader.getConfigReader().getDefaultStorageCommitPort();
    }

    private void throttleIfNecessary() {
        int n2 = 10;
        int n3 = this.getCongestionIndex(0, false, false);
        if (n3 >= 10) {
            co.a(MathUtils.a(n3 * 10, 100, 2000));
        }
    }

    public void redirectIncomingSeries(String string, String string2, int n2, int n3, String string3) {
        this.qrProxy.registerRequest(string, string2, string3, n3, n2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onCStoreRQ(Association association, int n2, DicomObject dicomObject, PDVInputStream pDVInputStream, String string, DicomObject dicomObject2) throws IOException, DicomServiceException {
        try {
            void var10_17;
            MIMFile mIMFile;
            Object object;
            this.throttleIfNecessary();
            DicomStoreAssociation dicomStoreAssociation = (DicomStoreAssociation)association;
            String string2 = dicomObject.getString(4096);
            dicomStoreAssociation.addSOPInstance(string2);
            PDVInputStream pDVInputStream2 = pDVInputStream;
            if (this.qrProxy.expectingAnythingOn(association.getCalledAET())) {
                Pair<String, InputStream> pair = DicomQRClientDataProxy.peekSeriesUID(pDVInputStream);
                object = (String)pair.x;
                InputStream inputStream = (InputStream)pair.y;
                if (this.qrProxy.sendData(association, (String)object, string2, inputStream)) {
                    dicomStoreAssociation.setForOpening(true);
                    return;
                }
            }
            if ((mIMFile = dicomStoreAssociation.getAssocDir()) == null) {
                MIMFile mIMFile2 = this.createAssociationTempdir(association, dicomStoreAssociation);
                if (!dicomStoreAssociation.isForOpening()) {
                    this.getStatusNotifier().transferStarted(dicomStoreAssociation.getUniqueID(), dicomStoreAssociation.getHostString());
                }
            }
            object = new File((File)var10_17, string2 + ".dcm");
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, this.fileBufferSize);
            try (Object object2 = new DicomOutputStream((OutputStream)bufferedOutputStream);){
                void var9_13;
                String string3 = dicomObject.getString(2);
                BasicDicomObject basicDicomObject = new BasicDicomObject();
                basicDicomObject.initFileMetaInformation(string3, string2, string);
                object2.writeFileMetaInformation((DicomObject)basicDicomObject);
                cm.a((InputStream)var9_13, (OutputStream)object2);
            }
            object2 = new DicomReader.FilteredTagInputHandler();
            ((DicomReader.FilteredTagInputHandler)object2).setSkipLargePrivateTags(1024);
            var15_22 = DicomReader.readFileIntoDicomObject((File)object, new DicomReader.StopBeforeContentInputHandler(2145386512, (DicomInputHandler)object2));
            if (var15_22 == null) {
                throw new IOException("Couldn't read a DicomObject out of the incoming stream!");
            }
            int n3 = dicomStoreAssociation.incrementFileCount();
            dicomStoreAssociation.setLastPatientName(var15_22.getString(0x100010, "Unknown Patient"));
            dicomStoreAssociation.setLastModality(var15_22.getString(524384, "Unknown Modality"));
            FuncUtils.a(() -> {
                String string = String.format("%s %s - %d %s", Parser.formatName(dicomStoreAssociation.getLastPatientName()), dicomStoreAssociation.getLastModality(), n3, n3 == 1 ? "file" : "files");
                this.getStatusNotifier().updateText(dicomStoreAssociation.getUniqueID(), string, dicomStoreAssociation.getHostString());
            }, 500L);
            String string4 = var15_22.getString(0x20000E);
            if (string4 == null) {
                throw new IOException("Failed to get the SeriesInstanceUID from the file " + ((File)object).getName());
            }
            File file = new File((File)var10_17, string4);
            if (!file.exists()) {
                if (!file.mkdirs()) throw new FileNotFoundException("Failed to create series temp directory: " + file.getAbsolutePath());
                ay.b((Object)(association.getLogPrefix() + "create series temp directory: " + file.getAbsolutePath()), (Object)this);
            } else if (!file.isDirectory()) {
                throw new FileNotFoundException(file.getAbsolutePath() + " is not a valid directory");
            }
            File file2 = new File(file, ((File)object).getName());
            if (file2.exists() && !file2.delete()) {
                String string5 = association.getLogPrefix() + "failed to delete old file " + file2.getAbsolutePath();
                ay.d((Object)string5, (Object)this);
                throw new IOException(string5);
            }
            MIMFile.b((File)object, file2);
            dicomStoreAssociation.addSeriesFile(string4, new Archiver.d(file2, (DicomObject)var15_22, true));
            return;
        }
        catch (IOException iOException) {
            ay.d((Object)(association.getLogPrefix() + "failed to process C-STORE-RQ: "), (Throwable)iOException, (Object)this);
            if (iOException.getMessage() == null) throw new DicomServiceException(dicomObject, 272);
            throw new DicomServiceException(dicomObject, 272, iOException.getMessage());
        }
        catch (ClassCastException classCastException) {
            ay.d((Object)(association.getLogPrefix() + "failed to process C-STORE-RQ: "), (Throwable)classCastException, (Object)this);
            if (classCastException.getMessage() == null) throw new DicomServiceException(dicomObject, 272);
            throw new DicomServiceException(dicomObject, 272, classCastException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MIMFile createAssociationTempdir(Association association, DicomStoreAssociation dicomStoreAssociation) throws IOException, FileNotFoundException {
        MIMFile mIMFile = new MIMFile(dicomStoreAssociation.getAeTempDir(), PathUtils.safeFilename(dicomStoreAssociation.description()));
        if (!mIMFile.exists()) {
            if (!mIMFile.mkdirs()) throw new FileNotFoundException("Failed to create current association's temp directory: " + mIMFile.getAbsolutePath());
            ay.b((Object)(association.getLogPrefix() + "created current association's temp directory: " + mIMFile.getAbsolutePath()), (Object)this);
        } else if (!mIMFile.isDirectory()) {
            throw new FileNotFoundException(mIMFile.getAbsolutePath() + " is not a valid directory");
        }
        dicomStoreAssociation.setAssocDir(mIMFile);
        return mIMFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void archiveFiles(Multimap<String, Archiver.d> multimap, DicomStoreAssociation dicomStoreAssociation, boolean bl2) throws IOException {
        DicomStoreAppEntity dicomStoreAppEntity = dicomStoreAssociation.getAE();
        for (String string : multimap.keySet()) {
            Collection collection = multimap.get((Object)string);
            DelayedArchiveTask delayedArchiveTask = null;
            DicomStoreAppEntity dicomStoreAppEntity2 = dicomStoreAppEntity;
            synchronized (dicomStoreAppEntity2) {
                delayedArchiveTask = dicomStoreAppEntity.getArchiveTask(string);
                boolean bl3 = false;
                if (delayedArchiveTask == null || !delayedArchiveTask.cancel()) {
                    delayedArchiveTask = dicomStoreAppEntity.createArchiveTask(dicomStoreAssociation, string);
                } else {
                    bl3 = true;
                    delayedArchiveTask.addAssociation(dicomStoreAssociation);
                }
                for (Archiver.d d2 : collection) {
                    if (!d2.d.exists()) {
                        dicomStoreAssociation.setArchiveErrorFlag(true);
                        throw new IOException("A file was added to an association that doesn't exist on disk: " + d2);
                    }
                    File file = new File(delayedArchiveTask.getTaskDir(), d2.d.getName());
                    if (file.exists()) {
                        file.delete();
                    }
                    MIMFile.b(d2.d, file);
                    d2.d = file;
                    delayedArchiveTask.addSeriesFile(d2);
                }
                MIMFile mIMFile = new MIMFile(dicomStoreAssociation.getAssocDir(), string);
                if (!mIMFile.delete()) {
                    ay.d((Object)("Couldn't delete the temp association folder for an incoming series: " + mIMFile), (Object)this);
                }
                long l2 = DicomStoreService.getInstance().getConfigLoader().getConfigReader().getArchiveDelay();
                ay.b((Object)((bl3 ? "Rescheduling" : "Scheduling") + " a " + l2 + "ms delay archive task " + delayedArchiveTask.getTaskDir()), (Object)this);
                delayedArchiveTask.schedule(l2);
            }
        }
        if (!dicomStoreAssociation.getAssocDir().delete()) {
            ay.d((Object)("Couldn't delete the association folder: " + dicomStoreAssociation.getAssocDir()), (Object)this);
        }
    }

    public int getCongestionIndex(int n2, boolean bl2, boolean bl3) {
        BlockingQueue<Runnable> blockingQueue = workQueue.getQueue();
        int n3 = 0;
        int n4 = 0;
        Runnable[] runnableArray = blockingQueue.toArray(new Runnable[0]);
        int n5 = runnableArray.length;
        for (int i2 = 0; i2 < n5; ++i2) {
            Runnable runnable = runnableArray[i2];
            if (runnable instanceof PriorityRunnable && ((PriorityRunnable)runnable).priority > 0) {
                ++n4;
                continue;
            }
            ++n3;
        }
        int n6 = n3 + (bl2 ? n4 / 4 : 0);
        int n7 = n5 = n6 > n2 ? 1 : 0;
        if (bl3) {
            String string = String.format("Archiver congestion index: %d (%d high, %d low, %d threshold) -- %s", n6, n3, n4, n2, n5 != 0 ? "CONGESTED" : "NOT CONGESTED");
            ay.a((Object)string, (Object)this);
        }
        return n6;
    }

    public boolean isArchiverCongested() {
        int n2 = this.configLoader.getConfigReader().getTaskQueueThreshold();
        int n3 = this.getCongestionIndex(n2, true, true);
        boolean bl2 = n3 > n2;
        return bl2;
    }

    NetworkConnection getNetworkConnection() {
        return this.nc;
    }

    static void enqueueHighPrioTask(Runnable runnable) {
        workQueue.execute(new PriorityRunnable(0, runnable));
    }

    static void enqueueLowPrioTask(Runnable runnable) {
        workQueue.execute(new PriorityRunnable(1, runnable));
    }

    public final void setTlsWithoutEncyrption() {
        this.nc.setTlsWithoutEncyrption();
    }

    public final void setTls3DES_EDE_CBC() {
        this.nc.setTls3DES_EDE_CBC();
    }

    public final void setTlsAES_128_CBC() {
        this.nc.setTlsAES_128_CBC();
    }

    public final void disableSSLv2Hello() {
        this.nc.disableSSLv2Hello();
    }

    public final void setTlsNeedClientAuth(boolean bl2) {
        this.nc.setTlsNeedClientAuth(bl2);
    }

    public final void setKeyStoreURL(String string) {
        this.keyStoreURL = string;
    }

    public final void setKeyStorePassword(String string) {
        this.keyStorePassword = string.toCharArray();
    }

    public final void setKeyPassword(String string) {
        this.keyPassword = string.toCharArray();
    }

    public final void setTrustStorePassword(String string) {
        this.trustStorePassword = string.toCharArray();
    }

    public final void setTrustStoreURL(String string) {
        this.trustStoreURL = string;
    }

    public void initTLS() throws GeneralSecurityException, IOException {
        KeyStore keyStore = DicomStoreService.loadKeyStore(this.keyStoreURL, this.keyStorePassword);
        KeyStore keyStore2 = DicomStoreService.loadKeyStore(this.trustStoreURL, this.trustStorePassword);
        this.device.initTLS(keyStore, this.keyPassword != null ? this.keyPassword : this.keyStorePassword, keyStore2);
    }

    private static KeyStore loadKeyStore(String string, char[] cArray) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(DicomStoreService.toKeyStoreType(string));
        try (InputStream inputStream = DicomStoreService.openFileOrURL(string);){
            keyStore.load(inputStream, cArray);
        }
        return keyStore;
    }

    private static InputStream openFileOrURL(String string) throws IOException {
        if (string.startsWith("resource:")) {
            return DicomStoreService.class.getClassLoader().getResourceAsStream(string.substring(9));
        }
        try {
            return new URL(string).openStream();
        }
        catch (MalformedURLException malformedURLException) {
            return new FileInputStream(string);
        }
    }

    private static String toKeyStoreType(String string) {
        return string.endsWith(".p12") || string.endsWith(".P12") ? "PKCS12" : "JKS";
    }

    static {
        receiveLog = ay.b((Object)"DcmRcvLog");
        String string = System.getProperty("extraDcmStoreConfigFile");
        RUNNING_IN_BONUS_MODE = string != null;
        SECRET = new char[]{'s', 'e', 'c', 'r', 'e', 't'};
    }

    private static class PriorityRunnable
    implements Runnable {
        private static final AtomicLong nextTaskId = new AtomicLong(0L);
        int priority;
        final long taskId = nextTaskId.getAndIncrement();
        private final Runnable runMe;

        public PriorityRunnable(int n2, Runnable runnable) {
            this.priority = n2;
            this.runMe = runnable;
        }

        @Override
        public void run() {
            this.runMe.run();
        }
    }
}

