/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server;

import com.mimvista.dicom.server.DicomStoreAssociation;
import com.mimvista.util.ay;
import java.io.IOException;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.DicomServiceException;
import org.dcm4che2.net.DimseRSPHandler;
import org.dcm4che2.net.service.DicomService;
import org.dcm4che2.net.service.NActionSCP;

class MIMStorageCommitmentSCP
extends DicomService
implements NActionSCP {
    MIMStorageCommitmentSCP() {
        super("1.2.840.10008.1.20.1");
    }

    public void naction(Association association, int n2, DicomObject dicomObject, DicomObject dicomObject2) throws DicomServiceException, IOException {
        DicomObject dicomObject3 = CommandUtils.mkRSP((DicomObject)dicomObject, (int)0);
        this.onNActionRQ(association, n2, dicomObject, dicomObject2, dicomObject3);
        association.writeDimseRSP(n2, dicomObject3);
        this.onNActionRSP(association, n2, dicomObject, dicomObject2, dicomObject3);
    }

    void onNActionRQ(Association association, int n2, DicomObject dicomObject, DicomObject dicomObject2, DicomObject dicomObject3) throws DicomServiceException {
        int n3 = dicomObject.getInt(4104);
        if (n3 != 1) {
            ay.d((Object)(this.getLogPrefix(association) + "Received unrecongnized action type: " + Integer.toString(n3)), (Object)this);
            dicomObject3.putInt(2304, VR.US, 277);
            dicomObject3.putInt(4104, VR.US, n3);
            return;
        }
        String string = dicomObject2.getString(528789);
        if (string == null) {
            ay.d((Object)(this.getLogPrefix(association) + "Missing Transcation UID in Storage Commitment Request"), (Object)this);
            dicomObject3.putInt(2304, VR.US, 530);
            return;
        }
        DicomElement dicomElement = dicomObject2.get(528793);
        if (dicomElement == null || dicomElement.countItems() == 0) {
            ay.d((Object)(this.getLogPrefix(association) + "Missing Referenced SOP Instance(s) in Storage Commitment Request"), (Object)this);
            dicomObject3.putInt(2304, VR.US, 530);
            return;
        }
        DicomStoreAssociation dicomStoreAssociation = (DicomStoreAssociation)association;
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject4 = dicomElement.getDicomObject(i2);
            String string2 = dicomObject4.getString(528725);
            String string3 = dicomObject4.getString(528720);
            if (string2 == null || string3 == null) {
                ay.d((Object)(this.getLogPrefix(association) + "Missing SOP Class UID and/or SOP Instance UID of " + Integer.toString(i2) + "th Referenced SOP Instance in Storage Commitment Request"), (Object)this);
                dicomObject3.putInt(2304, VR.US, 530);
                return;
            }
            if (dicomStoreAssociation.sentSOPInstance(string2)) continue;
            ay.c((Object)(this.getLogPrefix(association) + "SOP instance " + string2 + "is not received"), (Object)this);
            dicomObject3.putInt(2304, VR.US, 277);
            DicomElement dicomElement2 = dicomObject3.putSequence(528793);
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            basicDicomObject.putString(528720, VR.UI, string3);
            basicDicomObject.putString(528725, VR.UI, string2);
            dicomElement2.addDicomObject((DicomObject)basicDicomObject);
            return;
        }
        try {
            dicomStoreAssociation.commit(dicomObject2);
        }
        catch (Throwable throwable) {
            throw new DicomServiceException(dicomObject, 272, throwable.getMessage());
        }
    }

    void onNActionRSP(Association association, int n2, DicomObject dicomObject, DicomObject dicomObject2, DicomObject dicomObject3) {
        if (dicomObject3.getInt(2304) != 0) {
            return;
        }
        DicomStoreAssociation dicomStoreAssociation = (DicomStoreAssociation)association;
        DicomObject dicomObject4 = dicomStoreAssociation.waitForArchived();
        if (dicomObject4 == null) {
            ay.c((Object)(this.getLogPrefix(association) + "Timeout occurred when waiting for Storage Commitment Result"), (Object)this);
            return;
        }
        DimseRSPHandler dimseRSPHandler = new DimseRSPHandler(){

            public void onDimseRSP(Association association, DicomObject dicomObject, DicomObject dicomObject2) {
                ay.b((Object)(MIMStorageCommitmentSCP.this.getLogPrefix(association) + "Received N-EVENT-REPORT Response with status code: 0x" + Integer.toHexString(dicomObject.getInt(2304)).toUpperCase()), (Object)this);
                ((DicomStoreAssociation)association).setCommitDone();
            }
        };
        try {
            dicomStoreAssociation.nevent("1.2.840.10008.1.20.1", "1.2.840.10008.1.20.1.1", dicomObject4.get(528792) == null ? 1 : 2, dicomObject4, "1.2.840.10008.1.2", dimseRSPHandler);
        }
        catch (IOException iOException) {
            ay.d((Object)(this.getLogPrefix(association) + "Failed to send back storage commitment result via current association: "), iOException);
        }
        catch (InterruptedException interruptedException) {
            ay.d((Object)(this.getLogPrefix(association) + "Failed to send back storage commitment result via current association: "), interruptedException);
        }
    }

    public String getLogPrefix(Association association) {
        if (association == null) {
            return "Null Association| ";
        }
        return association.getLogPrefix();
    }
}

