/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server;

import com.mimvista.dicom.network.DICOMTransferUtil;
import com.mimvista.dicom.server.DcmStoreAeTitle;
import com.mimvista.dicom.server.DicomStoreAppEntity;
import com.mimvista.dicom.server.DicomStoreConfigLoader;
import com.mimvista.dicom.server.DicomStoreConfigReader;
import com.mimvista.preferencesNew.DicomStorePrefs;
import com.mimvista.util.ay;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.service.StorageService;

public class NetworkApplicationEntityFactory {
    private static final String[] ONLY_DEF_TS = new String[]{"1.2.840.10008.1.2"};
    public static final boolean DEF_COMMIT_SUPPORT = false;
    private static final int DEF_IDLE_TIMEOUT = 60000;
    private static final int DEF_MAX_RECV_PDU_SIZE = 16384;
    private static final int DEF_MAX_SEND_PDU_SIZE = 16384;
    private static final boolean DEF_PACK_PDV = false;
    private static final int DEF_MAX_OPS_PERFORMED = 0;
    private static final int DEF_COMMIT_TIMEOUT = 300000;
    private NetworkConnection nc;
    private StorageService dcmRcv;
    private String[] tsuids;
    private int idleTimeout;
    private int recvSize;
    private int sndSize;
    private boolean packPDV;
    private int maxOps;
    private int commitTimeout;
    private boolean commitSupport;
    private TransferCapability[] tc;

    public NetworkApplicationEntityFactory(NetworkConnection networkConnection, StorageService storageService, String[] stringArray) {
        this.nc = networkConnection;
        this.dcmRcv = storageService;
        this.tsuids = stringArray;
        this.refresh();
    }

    public NetworkApplicationEntity buildAe(DcmStoreAeTitle dcmStoreAeTitle, DicomStoreConfigReader dicomStoreConfigReader) {
        DicomStoreAppEntity dicomStoreAppEntity = new DicomStoreAppEntity(this.nc, this.dcmRcv, dcmStoreAeTitle, dicomStoreConfigReader.getTempFolder(), this.commitSupport);
        dicomStoreAppEntity.setIdleTimeout(this.idleTimeout);
        dicomStoreAppEntity.setMaxPDULengthReceive(this.recvSize);
        dicomStoreAppEntity.setMaxPDULengthSend(this.sndSize);
        dicomStoreAppEntity.setPackPDV(this.packPDV);
        dicomStoreAppEntity.setMaxOpsPerformed(this.maxOps);
        dicomStoreAppEntity.setCommitTimeout(this.commitTimeout);
        dicomStoreAppEntity.setTransferCapability(this.tc);
        return dicomStoreAppEntity;
    }

    public void refresh() {
        this.idleTimeout = DicomStorePrefs.idleTimeout.getValue();
        this.recvSize = DicomStorePrefs.pduReceiveSize.getValue();
        this.sndSize = DicomStorePrefs.pduSendSize.getValue();
        this.packPDV = DicomStorePrefs.packPdv.getValue();
        this.maxOps = DicomStorePrefs.maxOpsPerformed.getValue();
        this.commitTimeout = DicomStorePrefs.commitTimeout.getValue();
        this.commitSupport = DicomStorePrefs.commitSupport.getValue();
        this.tc = this.getTransferCapability(this.commitSupport);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Refresh NetworkApplicationEntityFactory:");
        stringBuilder.append("\n\tIdle Timeout: ");
        stringBuilder.append(this.idleTimeout);
        stringBuilder.append(" ms, PDU Receive Size: ");
        stringBuilder.append(this.recvSize);
        stringBuilder.append(" bytes, PDU Send Size: ");
        stringBuilder.append(this.sndSize);
        stringBuilder.append(" bytes\n\tPack PDV: ");
        stringBuilder.append(this.packPDV ? "yes" : "no");
        stringBuilder.append(", Max Operations Performed: ");
        stringBuilder.append(this.maxOps);
        stringBuilder.append(", Commit Timeout: ");
        stringBuilder.append(this.commitTimeout);
        stringBuilder.append(" ms");
        stringBuilder.append(", Commit Support: ");
        stringBuilder.append(this.commitSupport ? "yes" : "no");
        ay.b((Object)stringBuilder, this);
    }

    private TransferCapability[] getTransferCapability(boolean bl2) {
        int n2 = bl2 ? 1 : 0;
        TransferCapability[] transferCapabilityArray = new TransferCapability[DicomStoreConfigLoader.getSupportedSopUids().length + 1 + n2];
        transferCapabilityArray[0] = new TransferCapability("1.2.840.10008.1.1", ONLY_DEF_TS, "SCP");
        for (int i2 = 0; i2 < DicomStoreConfigLoader.getSupportedSopUids().length; ++i2) {
            transferCapabilityArray[i2 + 1] = DICOMTransferUtil.getTransferCapabilityForSOPClassUID(DicomStoreConfigLoader.getSupportedSopUids()[i2], this.tsuids, "SCP");
        }
        if (bl2) {
            transferCapabilityArray[DicomStoreConfigLoader.getSupportedSopUids().length + n2] = new TransferCapability("1.2.840.10008.1.20.1", ONLY_DEF_TS, "SCP");
        }
        return transferCapabilityArray;
    }
}

