/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server.gui;

import com.mimvista.LocalLicense.ProcessInfoBlob;
import com.mimvista.dicom.server.gui.ServiceControl;
import com.mimvista.dicom.server.gui.ServiceException;
import com.mimvista.util.ay;
import com.mimvista.util.service.SimpleServiceControl;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class LinuxServiceControl
extends ServiceControl {
    boolean hasLoggedSetupQueryFail = false;

    LinuxServiceControl(SimpleServiceControl.MimService mimService) {
        super(mimService);
    }

    @Override
    public boolean wasInstalledByThisApp() throws ServiceException {
        return true;
    }

    @Override
    public SimpleServiceControl.MimServiceState getServerStatusCode() throws ServiceException {
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "/etc/init.d/" + this.type.i() + " status";
        if (!new File("/etc/init.d/" + this.type.i()).exists()) {
            if (!this.hasLoggedSetupQueryFail) {
                ay.b((Object)"We don't support to setup and query status from MIM Services under development of Linux.", this);
                this.hasLoggedSetupQueryFail = true;
            }
            return SimpleServiceControl.MimServiceState.a;
        }
        ProcessInfoBlob processInfoBlob = null;
        try {
            ay.a((Object)("Quering service running status: " + string), this);
            processInfoBlob = this.execute(string);
            if (processInfoBlob.c()) {
                throw new TimeoutException();
            }
            if (processInfoBlob != null) {
                ay.a((Object)("Return value: " + processInfoBlob.d()), this);
                if (processInfoBlob.d() == 0) {
                    return SimpleServiceControl.MimServiceState.d;
                }
            }
        }
        catch (Exception exception) {
            throw new ServiceException(exception);
        }
        string = "/sbin/chkconfig --list";
        try {
            processInfoBlob = this.execute(string);
            if (processInfoBlob != null && processInfoBlob.d() == 0) {
                for (String string2 : processInfoBlob.a()) {
                    if (string2.indexOf(this.type.i()) < 0 || string2.indexOf(":on") <= 0) continue;
                    ay.b((Object)("Service is installed: " + string2), this);
                    return SimpleServiceControl.MimServiceState.b;
                }
            }
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        return SimpleServiceControl.MimServiceState.a;
    }

    @Override
    public void atomicallyRestartService() throws ServiceException {
        throw new RuntimeException("This method is not implemented on Linux.");
    }

    @Override
    protected String[] getServiceControlCommand(SimpleServiceControl.MimServiceCommand mimServiceCommand) {
        String string = "/etc/init.d/" + this.type.i();
        boolean bl2 = true;
        if (new File("/usr/sbin/update-rc.d").canExecute()) {
            bl2 = false;
        }
        if (mimServiceCommand == SimpleServiceControl.MimServiceCommand.a) {
            string = string + " start";
        } else if (mimServiceCommand == SimpleServiceControl.MimServiceCommand.b) {
            string = string + " stop";
        } else if (mimServiceCommand == SimpleServiceControl.MimServiceCommand.d) {
            string = bl2 ? "/sbin/chkconfig " + this.type.i() + " off" : "/usr/sbin/update-rc.d  -f " + this.type.i() + " remove";
        } else if (mimServiceCommand == SimpleServiceControl.MimServiceCommand.c) {
            string = bl2 ? "/sbin/chkconfig " + this.type.i() + " on" : "/usr/sbin/update-rc.d -f " + this.type.i() + " defaults";
        }
        return this.tokenizeLikeRuntimeExecDoes(string);
    }

    @Override
    public boolean isAutoStart() {
        return false;
    }
}

