/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server.gui;

import com.mimvista.LocalLicense.Admin;
import com.mimvista.LocalLicense.ProcessInfoBlob;
import com.mimvista.dicom.server.gui.ServiceControl;
import com.mimvista.dicom.server.gui.ServiceException;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.license.LocalLicenseDialog;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.properties.services.r;
import com.mimvista.util.MIMContext;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.ay;
import com.mimvista.util.service.SimpleServiceControl;
import com.mimvista.util.u;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import xmlwise.Plist;
import xmlwise.XmlParseException;

public class MacServiceControl
extends ServiceControl {
    private boolean wasInstalledByThisApp = false;

    public MacServiceControl(SimpleServiceControl.MimService mimService) {
        super(mimService);
    }

    @Override
    public boolean isAutoStart() {
        MIMFile mIMFile = new MIMFile("/Library/LaunchDaemons" + MIMFile.separatorChar + this.type.e() + ".plist");
        if (!(mIMFile.exists() && mIMFile.isFile() && mIMFile.canRead())) {
            return false;
        }
        try {
            Map map = Plist.load((File)mIMFile);
            Object v2 = map.get("RunAtLoad");
            if (v2 != null) {
                return Boolean.parseBoolean(v2.toString());
            }
        }
        catch (XmlParseException xmlParseException) {
            ay.d((Object)("Unable to read plist for service " + this.type.e()), (Throwable)xmlParseException, this);
        }
        catch (IOException iOException) {
            ay.d((Object)("Unable to read plist for service " + this.type.e()), (Throwable)iOException, this);
        }
        return false;
    }

    @Override
    public String getServiceBinaryPath() {
        MIMFile mIMFile = new MIMFile("/Library/LaunchDaemons" + MIMFile.separatorChar + this.type.e() + ".plist");
        if (!(mIMFile.exists() && mIMFile.isFile() && mIMFile.canRead())) {
            return null;
        }
        try {
            Map map = Plist.load((File)mIMFile);
            Object v2 = map.get("ProgramArguments");
            ArrayList arrayList = (ArrayList)v2;
            for (String string : arrayList) {
                if (!string.startsWith("/Library/Frameworks/")) continue;
                return new File(string).getCanonicalPath();
            }
        }
        catch (XmlParseException xmlParseException) {
            ay.d((Object)("Unable to read plist for service " + this.type.e()), (Throwable)xmlParseException, this);
        }
        catch (IOException iOException) {
            ay.d((Object)("Unable to read plist for service " + this.type.e()), (Throwable)iOException, this);
        }
        catch (ClassCastException classCastException) {
            ay.d((Object)("Unable to read plist for service " + this.type.e()), (Throwable)classCastException, this);
        }
        return null;
    }

    @Override
    protected ProcessInfoBlob executeServiceCommands(SimpleServiceControl.MimServiceCommand mimServiceCommand, String string) throws ServiceException {
        String string2 = this.getRunnableCommandForThisService(mimServiceCommand);
        return this.runElevatedCommand(mimServiceCommand.toString(), string, string2);
    }

    private ProcessInfoBlob runElevatedCommand(final String string, String string2, String string3) throws ServiceException {
        final CommandRunner commandRunner = new CommandRunner();
        commandRunner.cmd = string3;
        commandRunner.errMsgPrefix = string2;
        Runnable runnable = null;
        if (commandRunner.cmd.indexOf(91) > -1) {
            runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    commandRunner.status(CommandStatus.RUNNING);
                    String string = commandRunner.cmd.replaceAll("\\[", " ");
                    try {
                        ProcessBuilder processBuilder = new ProcessBuilder(string.split(" "));
                        if (LicenseTransformer.isDevelopment()) {
                            File file = new File(MIMContext.x() ? PathUtils.getMIMcloudAssistantInstallPathForMacOS() : (MIMContext.j() ? PathUtils.getMIMviewerInstallPathForMacOS() : PathUtils.getMIMInstallPathForMacOS()));
                            processBuilder.directory(file);
                        }
                        commandRunner.proc = processBuilder.start();
                        commandRunner.proc.waitFor();
                        commandRunner.status(CommandStatus.SUCCESS);
                    }
                    catch (Throwable throwable) {
                        if (!LicenseTransformer.isDevelopment()) {
                            ay.d((Object)("Error running:\n\tCOMMAND: " + string + "\n\tOUTPUT: " + (commandRunner.proc != null ? Integer.valueOf(commandRunner.proc.exitValue()) : "")), throwable, this);
                        }
                        commandRunner.e = new ServiceException(throwable);
                        commandRunner.status(CommandStatus.FAIL);
                    }
                    finally {
                        commandRunner.latch.b();
                    }
                }
            };
        } else {
            Admin admin = LocalLicenseDialog.a();
            if (admin != null) {
                try {
                    ay.b((Object)("Admin Service running elevated command(s): " + string + ": " + commandRunner.cmd), this);
                    return admin.executeElevatedCommand(commandRunner.cmd, new File(".").getAbsolutePath());
                }
                catch (Exception exception) {
                    ay.b((Object)"Couldn't run elevated command via mimadmin", (Throwable)exception, this);
                }
            }
            runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    commandRunner.status(CommandStatus.RUNNING);
                    Object object = null;
                    ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("AppleScript");
                    try {
                        ay.b((Object)("Running mac shellscript command(s): " + string + ": " + commandRunner.cmd), this);
                        object = scriptEngine.eval("do shell script \"" + commandRunner.cmd + "\" with administrator privileges");
                        commandRunner.status(CommandStatus.SUCCESS);
                    }
                    catch (Throwable throwable) {
                        if (LicenseTransformer.isDevelopment()) {
                            ay.d((Object)("Error eval script: " + commandRunner.cmd + ": " + throwable.getMessage()), this);
                        } else {
                            ay.d((Object)("Error eval script:\n\tSCRIPT: " + commandRunner.cmd + "\n\tOUTPUT: " + String.valueOf(object)), throwable, this);
                        }
                        commandRunner.e = new ServiceException(throwable);
                        commandRunner.status(CommandStatus.FAIL);
                    }
                    finally {
                        commandRunner.latch.b();
                    }
                }
            };
        }
        commandRunner.t = new Thread(runnable, "Execute MacServiceControl Command");
        commandRunner.dar = new u(MacServiceControl.getServiceControlTimeoutMS(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (commandRunner.status().finished()) {
                    return;
                }
                if (commandRunner.proc != null) {
                    CommandRunner commandRunner2 = commandRunner;
                    synchronized (commandRunner2) {
                        commandRunner.proc.destroy();
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        ay.d((Object)interruptedException, this);
                    }
                }
                if (!commandRunner.status().finished()) {
                    commandRunner.e = new ServiceException(commandRunner.errMsgPrefix);
                    ay.d((Object)"Timed out waiting for service control process.", this);
                    commandRunner.t.interrupt();
                }
                commandRunner.latch.b();
            }
        });
        commandRunner.run();
        return new ProcessInfoBlob(commandRunner.proc);
    }

    private String getRunnableCommandForThisService(SimpleServiceControl.MimServiceCommand mimServiceCommand) {
        return MIMFormat.a(mimServiceCommand.b(), this.type.e(), this.type.f(), this.type.i(), mimServiceCommand.b());
    }

    @Override
    public boolean wasInstalledByThisApp() throws ServiceException {
        this.getServerStatusCode();
        return this.wasInstalledByThisApp;
    }

    @Override
    public void atomicallyRestartService() throws ServiceException {
        File file;
        String string = this.getRunnableCommandForThisService(SimpleServiceControl.MimServiceCommand.b);
        String string2 = this.getRunnableCommandForThisService(SimpleServiceControl.MimServiceCommand.a);
        try (PrintWriter printWriter = null;){
            file = File.createTempFile("restarter", ".sh");
            printWriter = new PrintWriter(file);
            printWriter.println(string);
            printWriter.println("sleep 1s");
            printWriter.println(string2);
            printWriter.println("rm -f '" + file.getAbsolutePath() + "'");
        }
        ProcessInfoBlob processInfoBlob = this.runElevatedCommand("RESTART", "", "bash -e " + file.getAbsolutePath());
        ay.a((Object)("return value: " + processInfoBlob.d()), this);
        ay.a((Object)"Output:", this);
        for (String string3 : processInfoBlob.a()) {
            ay.a((Object)string3, this);
        }
        ay.a((Object)"Error:", this);
        for (String string3 : processInfoBlob.b()) {
            ay.a((Object)string3, this);
        }
    }

    @Override
    public SimpleServiceControl.MimServiceState getServerStatusCode() throws ServiceException {
        Object object;
        ProcessInfoBlob processInfoBlob = this.executeServiceCommands(SimpleServiceControl.MimServiceCommand.e, r.b.b("BASESERVER_STATUS_FAIL"));
        int n2 = processInfoBlob.d();
        if (n2 == 0) {
            object = processInfoBlob.a().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (string.indexOf("OpenSCManager failed - Access is denied") <= -1) continue;
                return SimpleServiceControl.MimServiceState.f;
            }
        }
        if (((BigInteger)(object = BigInteger.valueOf(n2))).testBit(4)) {
            ay.c((Object)("Unable to get the status of service: " + this.getName()), this);
            return SimpleServiceControl.MimServiceState.f;
        }
        boolean bl2 = this.wasInstalledByThisApp = !((BigInteger)object).testBit(2);
        if (((BigInteger)object).testBit(1)) {
            return SimpleServiceControl.MimServiceState.d;
        }
        if (((BigInteger)object).testBit(0)) {
            return SimpleServiceControl.MimServiceState.b;
        }
        return SimpleServiceControl.MimServiceState.a;
    }

    @Override
    protected String[] getServiceControlCommand(SimpleServiceControl.MimServiceCommand mimServiceCommand) {
        return this.tokenizeLikeRuntimeExecDoes(mimServiceCommand.b());
    }

    class CommandRunner {
        String cmd = null;
        Thread t = null;
        Process proc = null;
        ServiceException e = null;
        String errMsgPrefix = null;
        u dar = null;
        CommandStatus status = CommandStatus.NONE;
        FuncUtils.f latch = null;

        CommandRunner() {
        }

        synchronized void status(CommandStatus commandStatus) {
            this.status = commandStatus;
        }

        synchronized CommandStatus status() {
            return this.status;
        }

        void run() throws ServiceException {
            this.latch = new FuncUtils.f();
            this.t.start();
            this.dar.b();
            this.latch.a();
            if (this.e != null) {
                throw this.e;
            }
        }
    }

    static enum CommandStatus {
        NONE,
        RUNNING,
        SUCCESS,
        FAIL;


        boolean finished() {
            return this == SUCCESS || this == FAIL;
        }
    }
}

