/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server.gui;

import com.mimvista.LocalLicense.ProcessInfoBlob;
import com.mimvista.archive.remote.MIMpacsConfig;
import com.mimvista.archive.remote.RemoteQueryServer;
import com.mimvista.dicom.server.gui.AdminContainedServiceControl;
import com.mimvista.dicom.server.gui.LinuxServiceControl;
import com.mimvista.dicom.server.gui.MacServiceControl;
import com.mimvista.dicom.server.gui.ServiceException;
import com.mimvista.dicom.server.gui.WindowsServiceControl;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.license.LocalLicenseDialog;
import com.mimvista.license.g;
import com.mimvista.metabase.s;
import com.mimvista.osdep.GetOSPath;
import com.mimvista.osdep.b;
import com.mimvista.preferencesNew.ConfigPrefs;
import com.mimvista.properties.services.r;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.ay;
import com.mimvista.util.service.SimpleServiceControl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class ServiceControl
extends SimpleServiceControl {
    private static Map<SimpleServiceControl.MimService, String> logFileTable = new HashMap<SimpleServiceControl.MimService, String>();
    private static Map<SimpleServiceControl.MimService, String> failureFileTable;
    protected SimpleServiceControl.MimService type;
    protected String windowsWorkingDir = "";
    protected boolean forceDirectCommand = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFailureReason(SimpleServiceControl.MimService mimService, String string) {
        ay.d((Object)string, (Object)mimService);
        String string2 = failureFileTable.get((Object)mimService);
        if (string2 == null) {
            return;
        }
        File file = new File(Path.getServiceLogPath(), string2);
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string);
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            ay.d((Object)("Error setting failure reason for " + (Object)((Object)mimService) + ": "), (Throwable)iOException, ServiceControl.class);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void clearFailureReason(SimpleServiceControl.MimService mimService) {
        String string = failureFileTable.get((Object)mimService);
        if (string == null) {
            return;
        }
        File file = new File(Path.getServiceLogPath(), string);
        if (file.exists() && !file.delete()) {
            ay.d((Object)("Failed to clear failure reason for " + (Object)((Object)mimService)), ServiceControl.class);
        }
    }

    public static ServiceControl getInstance(SimpleServiceControl.MimService mimService) {
        if (mimService.c()) {
            return new AdminContainedServiceControl(mimService);
        }
        if (GetOSPath.isWindows()) {
            return new WindowsServiceControl(mimService);
        }
        if (GetOSPath.isMacOs()) {
            return new MacServiceControl(mimService);
        }
        if (GetOSPath.isLinux()) {
            return new LinuxServiceControl(mimService);
        }
        throw new IllegalArgumentException("Unrecognized os platform");
    }

    protected ServiceControl(SimpleServiceControl.MimService mimService) {
        this.type = mimService;
    }

    public void startService() throws ServiceException {
        this.executeServiceChange(SimpleServiceControl.MimServiceCommand.a, r.b.b("BASESERVER_START_FAIL"));
    }

    public void stopService() throws ServiceException {
        this.executeServiceChange(SimpleServiceControl.MimServiceCommand.b, r.b.b("BASESERVER_STOP_FAIL"));
    }

    public void uninstallService() throws ServiceException {
        this.stopService();
        this.executeServiceChange(SimpleServiceControl.MimServiceCommand.d, r.b.b("BASESERVER_UNINSTALL_FAILURE"));
    }

    public void installService() throws ServiceException {
        this.executeServiceChange(SimpleServiceControl.MimServiceCommand.c, r.b.b("BASESERVER_INSTALL_FAILURE"));
    }

    public void setManualStart() throws ServiceException {
        this.executeServiceChange(SimpleServiceControl.MimServiceCommand.f, "");
    }

    public void setAutomaticStart() throws ServiceException {
        this.executeServiceChange(SimpleServiceControl.MimServiceCommand.g, "");
    }

    public abstract SimpleServiceControl.MimServiceState getServerStatusCode() throws ServiceException;

    public String getServiceBinaryPath() throws ServiceException {
        return null;
    }

    public abstract boolean isAutoStart();

    public abstract void atomicallyRestartService() throws ServiceException;

    public abstract boolean wasInstalledByThisApp() throws ServiceException;

    public void setStartDir(String string) {
        this.windowsWorkingDir = string;
    }

    private void executeServiceChange(SimpleServiceControl.MimServiceCommand mimServiceCommand, String string) throws ServiceException {
        if (!this.needToExecuteCommand(mimServiceCommand)) {
            return;
        }
        ProcessInfoBlob processInfoBlob = this.executeServiceCommands(mimServiceCommand, string);
        if (this.needToExecuteCommand(mimServiceCommand)) {
            this.serviceChangeFailed(mimServiceCommand, string, processInfoBlob);
        }
    }

    public void createRedirectInisForInstall(MIMFile mIMFile) {
    }

    public void setForceDirectCommand(boolean bl2) {
        this.forceDirectCommand = bl2;
    }

    private boolean needToExecuteCommand(SimpleServiceControl.MimServiceCommand mimServiceCommand) throws ServiceException {
        SimpleServiceControl.MimServiceState mimServiceState = this.getServerStatusCode();
        switch (mimServiceCommand) {
            case a: {
                return mimServiceState != SimpleServiceControl.MimServiceState.d;
            }
            case b: {
                return mimServiceState == SimpleServiceControl.MimServiceState.d;
            }
            case c: {
                return mimServiceState == SimpleServiceControl.MimServiceState.a;
            }
            case d: {
                return mimServiceState != SimpleServiceControl.MimServiceState.a;
            }
        }
        return true;
    }

    protected String[] getCmdString(SimpleServiceControl.MimServiceCommand mimServiceCommand) {
        String[] stringArray = this.getServiceControlCommand(mimServiceCommand);
        boolean bl2 = b.a();
        MIMFile mIMFile = new MIMFile("./bin/jre_64");
        boolean bl3 = mIMFile.exists();
        if (mimServiceCommand == SimpleServiceControl.MimServiceCommand.c && !(bl3 |= g.a()) && bl2) {
            ay.a((Object)"Installing 32 bit service since we don't seem to have a 64 bit JRE...", this);
        }
        String string = (bl2 &= bl3) ? "64" : "32";
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = MIMFormat.a(stringArray[i2], this.type.e(), this.type.f(), this.type.i(), string);
        }
        return stringArray;
    }

    protected ProcessInfoBlob executeServiceCommands(SimpleServiceControl.MimServiceCommand mimServiceCommand, String string) throws ServiceException {
        try {
            ProcessInfoBlob processInfoBlob = this.execute(this.getCmdString(mimServiceCommand));
            if (processInfoBlob.c()) {
                throw new ServiceException(string + " timeout");
            }
            return processInfoBlob;
        }
        catch (IOException iOException) {
            ay.d((Object)string, (Throwable)iOException, this);
            throw new ServiceException(string + ":\n" + iOException.toString());
        }
    }

    protected ProcessInfoBlob execute(String ... stringArray) throws IOException {
        boolean bl2;
        ProcessInfoBlob processInfoBlob;
        block6: {
            processInfoBlob = null;
            bl2 = this.forceDirectCommand;
            if (!bl2) {
                try {
                    processInfoBlob = stringArray.length == 1 ? LocalLicenseDialog.a(true, false).executeElevatedCommand(stringArray[0], null) : LocalLicenseDialog.a(true, false).executeElevatedCommand(stringArray, null);
                }
                catch (ConnectException connectException) {
                    bl2 = true;
                    if (!g.a()) {
                        ay.d((Object)("Couldn't connect to MIMadmin, attempting to run cmd directly (" + Arrays.toString(stringArray) + ")"), this);
                    }
                }
                catch (Exception exception) {
                    bl2 = true;
                    if (g.a()) break block6;
                    ay.d((Object)("MIMadmin problem, attempting to run cmd directly (" + Arrays.toString(stringArray) + ")"), (Throwable)exception, this);
                }
            }
        }
        if (bl2) {
            Runtime runtime = Runtime.getRuntime();
            processInfoBlob = stringArray.length == 1 ? new ProcessInfoBlob(runtime.exec(stringArray[0]), ServiceControl.getServiceControlTimeoutMS()) : new ProcessInfoBlob(runtime.exec(stringArray), ServiceControl.getServiceControlTimeoutMS());
        }
        return processInfoBlob;
    }

    public boolean isDevService() {
        return false;
    }

    protected void serviceChangeFailed(SimpleServiceControl.MimServiceCommand mimServiceCommand, String string, ProcessInfoBlob processInfoBlob) throws ServiceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getErrorInformation() {
        String string = logFileTable.get((Object)this.type);
        if (string == null) {
            return null;
        }
        File file = new File(Path.getServiceLogPath(), string);
        if (!file.exists()) {
            return null;
        }
        BufferedReader bufferedReader = null;
        FileInputStream fileInputStream = null;
        String string2 = null;
        String string3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            int n2;
            fileInputStream = new FileInputStream(file);
            long l2 = file.length() - 102400L;
            if (l2 < 0L) {
                l2 = 0L;
            }
            if ((l2 = fileInputStream.skip(l2)) > 0L) {
                while ((n2 = fileInputStream.read()) != -1 && n2 != 10) {
                }
            }
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
            n2 = 0;
            for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
                string2 = (String)arrayList.get(i2);
                if (n2 != 0) {
                    if (string2.startsWith("INFO")) {
                        string3 = string2 + "\n" + string3;
                        continue;
                    }
                    break;
                }
                if (!string2.startsWith("INFO")) continue;
                n2 = 1;
                string3 = string2;
            }
        }
        catch (IOException iOException) {
            ay.d((Object)("Error acquiring error information for " + (Object)((Object)this.type) + ": "), (Throwable)iOException, this);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            } else if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFailureReason() {
        String string = failureFileTable.get((Object)this.type);
        if (string == null) {
            return null;
        }
        File file = new File(Path.getServiceLogPath(), string);
        if (!file.exists()) {
            return null;
        }
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = bufferedReader.readLine();
            if (string3 != null) {
                string2 = string3;
            }
        }
        catch (IOException iOException) {
            ay.d((Object)("Error acquiring failure reason for " + (Object)((Object)this.type) + ": "), (Throwable)iOException, this);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string2;
    }

    protected String[] tokenizeLikeRuntimeExecDoes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    protected abstract String[] getServiceControlCommand(SimpleServiceControl.MimServiceCommand var1);

    public String getName() {
        return this.type.h();
    }

    public boolean pingIfMimpacs() {
        if (this.type == SimpleServiceControl.MimService.d) {
            try {
                RemoteQueryServer remoteQueryServer = s.a("127.0.0.1", MIMpacsConfig.g());
                remoteQueryServer.hello();
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static int getServiceControlTimeoutMS() {
        return ConfigPrefs.serviceControlTimeoutMs.getValue();
    }

    static {
        logFileTable.put(SimpleServiceControl.MimService.a, "dcmstore/wrapper.log");
        logFileTable.put(SimpleServiceControl.MimService.b, "dcmquery/wrapper.log");
        logFileTable.put(SimpleServiceControl.MimService.c, "license/wrapper.log");
        logFileTable.put(SimpleServiceControl.MimService.d, "pacs/wrapper.log");
        logFileTable.put(SimpleServiceControl.MimService.e, "mobile/wrapper.log");
        logFileTable.put(SimpleServiceControl.MimService.f, "automator/wrapper.log");
        logFileTable.put(SimpleServiceControl.MimService.g, "mimcloud_express/wrapper.log");
        logFileTable.put(SimpleServiceControl.MimService.j, "oisintegration/wrapper.log");
        failureFileTable = new HashMap<SimpleServiceControl.MimService, String>();
        failureFileTable.put(SimpleServiceControl.MimService.d, "pacs/failure.log");
    }
}

