/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server.gui;

import com.mimvista.file.Path;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class ServiceLogViewer
extends JDialog {
    public static Messages props = Messages.a("Dicom");
    private static final long serialVersionUID = 1L;
    private static final int MAX_LENGTH = 131071;
    public static final String STORESERVER = "Store Server";
    public static final String QUERYSERVER = "Query Server";
    public static final String PACSSERVER = "MIMpacs Server";
    public static final String HTTPDSERVER = "Web Admin";
    public static final String AUTOMATORDSERVER = "Automator";
    public static final String METABASE = "Metabase";
    public static final String LICENSESERVER = "License Server";
    private JTable table = null;
    private JTextField textField = null;
    private DefaultTableModel logTableModel = null;
    private List<Integer> list = new ArrayList<Integer>();
    private HashMap<ServiceLog, List<File>> logHash = new HashMap();
    private JComboBox box;
    private String serviceLogPath = Path.getServiceLogPath();

    public ServiceLogViewer(Dialog dialog, String string) {
        super(dialog, true);
        ServiceLog serviceLog = ServiceLog.getItemByName(string);
        this.initDialog(dialog);
        this.initCombox(serviceLog);
        this.initContentPanel();
        this.initLogFiles();
        this.addTableData(serviceLog);
    }

    private void initDialog(Dialog dialog) {
        this.setTitle(props.getProperty("SERVICELOG_TITLE"));
        this.setSize(new Dimension(700, 605));
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(dialog);
    }

    private void initContentPanel() {
        Vector<String> vector = new Vector<String>();
        vector.add(props.getProperty("SERVICELOG_TYPE"));
        vector.add(props.getProperty("SERVICELOG_MESSAGE"));
        this.logTableModel = new DefaultTableModel(vector, 24){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(10));
        box.add(this.box);
        this.textField = new JTextField(10);
        this.textField.setMaximumSize(new Dimension(150, 30));
        JLabel jLabel = new JLabel(props.getProperty("SERVICELOG_KEYWORD"));
        JButton jButton = new JButton(props.getProperty("SERVICELOG_SEARCH"), (ImageIcon)ImageManipulator.c("checkmark_green", 18));
        jButton.addActionListener(this.getSearchBtnListener());
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.setBorder(BorderFactory.createEtchedBorder(1));
        jPanel.add(jLabel);
        jPanel.add(this.textField);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(jPanel);
        box.add(jPanel2);
        this.table = new JTable(this.logTableModel);
        this.table.setAutoResizeMode(0);
        this.table.setDefaultRenderer(Object.class, new ColorTableCellRenderer());
        this.table.setGridColor(new Color(221, 221, 221));
        this.table.addMouseListener(this.getTableMouseListener());
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().getColumnModel().getColumn(0).setPreferredWidth(80);
        this.table.getTableHeader().getColumnModel().getColumn(1).setPreferredWidth(580);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(800, 428));
        jScrollPane.setMaximumSize(new Dimension(800, 428));
        jScrollPane.setBorder(BorderFactory.createTitledBorder(props.getProperty("SERVICELOG_LOGS")));
        JButton jButton2 = new JButton(props.getProperty("SERVICELOG_CLOSE"), (ImageIcon)ImageManipulator.c("x_red", 18));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServiceLogViewer.this.dispose();
            }
        });
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        box2.add(jButton2);
        box2.add(Box.createRigidArea(new Dimension(30, 40)));
        JPanel jPanel3 = (JPanel)this.getContentPane();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)box, "North");
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)box2, "South");
    }

    private void initCombox(ServiceLog serviceLog) {
        this.box = new JComboBox<ServiceLog>(ServiceLog.values());
        this.box.setSelectedItem((Object)serviceLog);
        this.box.setPreferredSize(new Dimension(150, 30));
        this.box.setMaximumSize(new Dimension(150, 30));
        this.box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ServiceLogViewer.this.list.clear();
                ServiceLogViewer.this.addTableData((ServiceLog)((Object)itemEvent.getItem()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTableData(ServiceLog serviceLog) {
        int n2;
        for (n2 = this.logTableModel.getRowCount() - 1; n2 >= 0; --n2) {
            this.logTableModel.removeRow(n2);
        }
        this.logTableModel.fireTableDataChanged();
        n2 = 131071;
        int n3 = 0;
        List<File> list = this.logHash.get((Object)serviceLog);
        for (File file : list) {
            if (!file.isFile() || !file.canRead()) continue;
            n2 = (int)(131071L > file.length() ? file.length() : 131071L);
            n3 = (int)file.length() - n2;
            RandomAccessFile randomAccessFile = null;
            FileChannel fileChannel = null;
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                fileChannel = randomAccessFile.getChannel();
                fileChannel.position(n3);
                ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
                fileChannel.read(byteBuffer);
                byteBuffer.flip();
                this.addTableDataFromBuff(byteBuffer);
                byteBuffer.clear();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (randomAccessFile == null) continue;
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (this.logTableModel.getRowCount() < 30) {
            for (int i2 = this.logTableModel.getRowCount(); i2 < 30; ++i2) {
                this.logTableModel.addRow(new Vector());
            }
        }
        this.logTableModel.fireTableDataChanged();
    }

    private void addTableDataFromBuff(ByteBuffer byteBuffer) {
        String string = System.getProperty("line.separator");
        while (byteBuffer.hasRemaining() && byteBuffer.get() != 10) {
        }
        while (byteBuffer.hasRemaining()) {
            String string2 = this.readLineFromByteBuffer(byteBuffer);
            if (string2 == null) continue;
            string2 = string2.replace(string, "");
            Vector<String> vector = new Vector<String>();
            if ("".equals(string2)) continue;
            if (string2.matches("^INFO.+")) {
                vector.add("INFO");
            } else if (string2.matches("^DEBUG.+")) {
                vector.add("DEBUG");
            } else if (string2.matches("^STATUS.+")) {
                vector.add("STATUS");
            } else if (string2.matches("^WARN.+")) {
                vector.add("WARN");
            } else if (string2.matches("^ERROR.+")) {
                vector.add("ERROR");
            } else if (string2.matches("^FATAL.+")) {
                vector.add("FATAL");
            } else {
                vector.add("OTHER");
            }
            vector.add(string2);
            this.logTableModel.addRow(vector);
        }
    }

    private String readLineFromByteBuffer(ByteBuffer byteBuffer) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        while (byteBuffer.hasRemaining()) {
            byte by2 = byteBuffer.get();
            arrayList.add(by2);
            if (by2 != 10) continue;
            break;
        }
        byte[] byArray = new byte[arrayList.size()];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (Byte)arrayList.get(i2);
        }
        return new String(byArray);
    }

    private MouseListener getTableMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() != 2 || mouseEvent.getButton() != 1) {
                    return;
                }
                int n2 = ServiceLogViewer.this.table.getSelectedRow();
                if (n2 != -1) {
                    String string = (String)ServiceLogViewer.this.table.getValueAt(n2, 1);
                    if (ServiceLogViewer.this.table.getValueAt(n2, 0) == null) {
                        return;
                    }
                    int n3 = string.length() / 80;
                    String string2 = "";
                    for (int i2 = 0; i2 < n3; ++i2) {
                        string2 = string2 + string.substring(i2 * 80, (i2 + 1) * 80) + "\n";
                    }
                    string2 = string2 + string.substring(n3 * 80, string.length());
                    JOptionPane.showMessageDialog(ServiceLogViewer.this, string2, (String)ServiceLogViewer.this.table.getValueAt(n2, 0), 1);
                }
            }
        };
    }

    private ActionListener getSearchBtnListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ServiceLogViewer.this.textField.getText().trim().toLowerCase();
                ServiceLogViewer.this.list.clear();
                if (string == null || string.equals("")) {
                    ServiceLogViewer.this.table.updateUI();
                    return;
                }
                for (int i2 = 0; i2 < ServiceLogViewer.this.logTableModel.getRowCount() && ServiceLogViewer.this.logTableModel.getValueAt(i2, 0) != null; ++i2) {
                    String string2 = (String)ServiceLogViewer.this.logTableModel.getValueAt(i2, 1);
                    if (string2.toLowerCase().indexOf(string) == -1) continue;
                    ServiceLogViewer.this.list.add(i2);
                }
                ServiceLogViewer.this.table.updateUI();
                JOptionPane.showMessageDialog(ServiceLogViewer.this, MIMFormat.a(props.getProperty("SERVICELOG_RESULT_MSG"), ServiceLogViewer.this.list.size()), props.getProperty("SERVICELOG_RESULT"), 1);
            }
        };
    }

    private void initLogFiles() {
        for (ServiceLog serviceLog : ServiceLog.values()) {
            File[] fileArray;
            this.logHash.put(serviceLog, new ArrayList());
            File file = new File(this.serviceLogPath, serviceLog.getPath());
            if (!file.exists() || !file.isDirectory()) continue;
            for (File file2 : fileArray = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().endsWith(".log");
                }
            })) {
                this.logHash.get((Object)serviceLog).add(file2);
            }
        }
    }

    public static void main(String[] stringArray) {
        MIMLookAndFeel.M();
        ServiceLogViewer serviceLogViewer = new ServiceLogViewer((Dialog)new JDialog(), PACSSERVER);
        serviceLogViewer.setVisible(true);
    }

    private class ColorTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private ColorTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (n3 == 0) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            String string = (String)jTable.getValueAt(n2, 0);
            Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            Font font = component.getFont().deriveFont(11);
            component.setFont(font);
            if (string == null) {
                if (!bl2) {
                    component.setBackground(Color.WHITE);
                } else {
                    component.setBackground(new Color(170, 170, 170));
                }
                return component;
            }
            if (string.equals("INFO")) {
                component.setForeground(new Color(0, 0, 153));
            } else if (string.equals("DEBUG")) {
                component.setForeground(SystemColor.DARK_GRAY);
            } else if (string.equals("STATUS")) {
                component.setForeground(new Color(102, 102, 102));
            } else if (string.equals("WARN")) {
                component.setForeground(new Color(153, 153, 0));
            } else if (string.equals("ERROR")) {
                component.setForeground(Color.RED);
            } else if (string.equals("FATAL")) {
                component.setForeground(new Color(102, 0, 102));
            } else {
                component.setForeground(Color.BLACK);
            }
            if (!bl2) {
                if (ServiceLogViewer.this.list.contains(n2)) {
                    component.setBackground(Color.YELLOW);
                } else {
                    component.setBackground(Color.WHITE);
                }
            } else {
                component.setBackground(new Color(170, 170, 170));
            }
            return component;
        }
    }

    static enum ServiceLog {
        STORE("Store Server", "services/dcmstore"),
        QUERY("Query Server", "services/dcmquery"),
        PACS("MIMpacs Server", "services/pacs"),
        HTTPD("Web Admin", "services/webadmin"),
        AUTOMATOR("Automator", "services/automator"),
        LICENSE("License Server", "services/license");

        private String name;
        private String path;

        private ServiceLog(String string2, String string3) {
            this.name = string2;
            this.path = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public static ServiceLog getItemByName(String string) {
            for (ServiceLog serviceLog : ServiceLog.values()) {
                if (!serviceLog.name.equals(string)) continue;
                return serviceLog;
            }
            return PACS;
        }

        public String toString() {
            return this.getName();
        }
    }
}

