/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.server.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.LocalLicense.ProcessInfoBlob;
import com.mimvista.dicom.server.gui.ServiceControl;
import com.mimvista.dicom.server.gui.ServiceException;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.file.PathUtils;
import com.mimvista.install.InstallerBackend;
import com.mimvista.license.g;
import com.mimvista.osdep.service.WindowsServiceUtils;
import com.mimvista.properties.bh;
import com.mimvista.properties.bq;
import com.mimvista.properties.services.r;
import com.mimvista.util.MIMContext;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.ca;
import com.mimvista.util.cn;
import com.mimvista.util.service.SimpleServiceControl;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WindowsServiceControl
extends ServiceControl {
    private static final String VM_HEAPSIZE_PREFERRED = "vm.heapsize.preferred";

    public WindowsServiceControl(SimpleServiceControl.MimService mimService) {
        super(mimService);
    }

    @Override
    protected void serviceChangeFailed(SimpleServiceControl.MimServiceCommand mimServiceCommand, String string, ProcessInfoBlob processInfoBlob) throws ServiceException {
        Object object;
        ay.d((Object)("Failed to execute the following service command:\n'" + String.join((CharSequence)" ", this.getCmdString(mimServiceCommand)) + "'\nForceDirect: " + this.forceDirectCommand), this);
        String string2 = null;
        if (mimServiceCommand == SimpleServiceControl.MimServiceCommand.a) {
            string2 = this.getFailureReason();
        }
        if (string2 == null) {
            string2 = this.getErrorInformation();
        }
        if (processInfoBlob.a().size() > 0) {
            object = "";
            for (String string3 : processInfoBlob.a()) {
                object = (String)object + string3 + "\n";
            }
            ay.a((Object)("Dumping std out from failed service proc:\n" + (String)object), this);
        }
        if (processInfoBlob.b().size() > 0) {
            object = "";
            for (String string3 : processInfoBlob.b()) {
                object = (String)object + string3 + "\n";
            }
            ay.a((Object)("Dumping std err from failed service proc:\n" + (String)object), this);
        }
        if (string2 == null) {
            string2 = "";
            for (String string4 : processInfoBlob.a()) {
                string2 = string2 + string4;
            }
            if (string2.length() == 0) {
                string2 = null;
            }
        }
        if (string2 == null) {
            string2 = r.b.b("BASESERVER_UNKNOWN_ERROR");
        }
        throw new ServiceException(string + ":\n" + string2);
    }

    public static String getInstallLocFromRegLine(String string) {
        if (string.indexOf("ImagePath") == -1) {
            return null;
        }
        int n2 = string.indexOf("\"");
        if (n2 < 0) {
            String string2 = "REG_EXPAND_SZ\t";
            int n3 = string.indexOf(string2);
            int n4 = string.indexOf(".exe");
            if (n4 < 0 || n3 < 0) {
                return null;
            }
            string = string.substring(n3 + string2.length(), n4 + 4);
        } else {
            string = string.substring(n2 + 1);
            string = string.substring(0, string.indexOf("\""));
        }
        return string;
    }

    public String getInstallLocation() {
        Object object;
        String string = null;
        ProcessInfoBlob processInfoBlob = null;
        IOException iOException = null;
        try {
            String string2;
            object = WindowsServiceUtils.g(this.type.f());
            processInfoBlob = this.execute((String)object);
            Iterator<String> iterator = processInfoBlob.a().iterator();
            while (iterator.hasNext() && (string = WindowsServiceControl.getInstallLocFromRegLine(string2 = iterator.next())) == null) {
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (string == null) {
            object = "Couldn't determine install loc...";
            if (iOException != null) {
                ay.d(object, (Throwable)iOException, this);
            } else {
                ay.d(object, this);
            }
        }
        return string;
    }

    @Override
    public boolean isDevService() {
        String string = this.getInstallLocation();
        if (string == null) {
            return false;
        }
        MIMFile mIMFile = new MIMFile(string);
        for (int i2 = 0; i2 < 4; ++i2) {
            if ((mIMFile = mIMFile.g()) != null) continue;
            return false;
        }
        return mIMFile.getName().equalsIgnoreCase("mimjava");
    }

    @Override
    public boolean isAutoStart() {
        try {
            ProcessInfoBlob processInfoBlob = this.execute("sc qc " + this.type.f());
            for (String string : processInfoBlob.a()) {
                if (!string.contains("START_TYPE")) continue;
                return string.contains("AUTO_START");
            }
        }
        catch (IOException iOException) {
            ay.d((Object)("Unable to query service config for " + this.type.f()), (Throwable)iOException, this);
        }
        return false;
    }

    @Override
    public boolean wasInstalledByThisApp() throws ServiceException {
        String string = this.getInstallLocation();
        if (string == null) {
            throw new ServiceException("Unable to determine the install location for service: " + this.getName());
        }
        String string2 = PathUtils.getInstallDirOfCurrentlyRunningMim().getAbsolutePath();
        if (string2 == null) {
            throw new ServiceException("Unable to determine the install location for the current app");
        }
        File file = new File(string);
        File file2 = new File(string2);
        return PathUtils.isParentOf(file2, file);
    }

    @Override
    public SimpleServiceControl.MimServiceState getServerStatusCode() throws ServiceException {
        ProcessInfoBlob processInfoBlob = this.executeServiceCommands(SimpleServiceControl.MimServiceCommand.e, r.b.b("BASESERVER_STATUS_FAIL"));
        if (processInfoBlob.a().size() == 0) {
            return SimpleServiceControl.MimServiceState.a;
        }
        boolean bl2 = false;
        if (processInfoBlob.a().get(0).contains("1060")) {
            return SimpleServiceControl.MimServiceState.a;
        }
        for (String string : processInfoBlob.a()) {
            if ((string = string.toLowerCase()).contains("openservice failed")) {
                return SimpleServiceControl.MimServiceState.a;
            }
            bl2 |= string.contains("service_name") || string.contains(this.type.f().toLowerCase());
            if (string.contains("2") && string.contains("start_pending")) {
                return SimpleServiceControl.MimServiceState.e;
            }
            if (string.contains("4") && string.contains("running")) {
                return SimpleServiceControl.MimServiceState.d;
            }
            if (string.contains("3") && string.contains("stop_pending")) {
                return SimpleServiceControl.MimServiceState.c;
            }
            if (!string.contains("1") || !string.contains("stopped")) continue;
            return SimpleServiceControl.MimServiceState.b;
        }
        if (bl2) {
            return SimpleServiceControl.MimServiceState.f;
        }
        return SimpleServiceControl.MimServiceState.a;
    }

    public SimpleServiceControl.MimServiceState getServerStatusCodeNoXcpAndUseRegCheck() {
        SimpleServiceControl.MimServiceState mimServiceState = null;
        try {
            mimServiceState = this.getServerStatusCode();
        }
        catch (ServiceException serviceException) {
            ay.d((Object)"Service status check err", (Throwable)serviceException, WindowsServiceControl.class);
        }
        if (mimServiceState == null) {
            mimServiceState = this.getInstallLocation() == null ? SimpleServiceControl.MimServiceState.a : SimpleServiceControl.MimServiceState.f;
        }
        return mimServiceState;
    }

    @Override
    public String getServiceBinaryPath() throws ServiceException {
        return this.getInstallLocation();
    }

    @Override
    public void atomicallyRestartService() throws ServiceException {
        File file;
        try (PrintWriter printWriter = null;){
            file = File.createTempFile("restarter", ".bat");
            printWriter = new PrintWriter(file);
            printWriter.println("@echo off");
            printWriter.println(String.join((CharSequence)" ", this.getCmdString(SimpleServiceControl.MimServiceCommand.b)));
            printWriter.println(String.join((CharSequence)" ", this.getCmdString(SimpleServiceControl.MimServiceCommand.a)));
            printWriter.println("del /y " + file.getAbsolutePath());
        }
        try {
            this.execute(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            throw new ServiceException("Cannot restart service", iOException);
        }
    }

    private void setupDevInis() {
        MIMFile mIMFile = new MIMFile("services/" + this.type.i() + "/bin/" + this.type.i() + "32.ini");
        MIMFile mIMFile2 = new MIMFile("services/" + this.type.i() + "/bin/" + this.type.i() + "64.ini");
        String string = Path.getServiceIniPath();
        InstallerBackend.a(string);
        HashMap hashMap = Maps.newHashMap();
        HashMap hashMap2 = Maps.newHashMap();
        hashMap.put("ini.file.location", string + "/" + this.type.i() + "32.ini");
        hashMap2.put("ini.file.location", string + "/" + this.type.i() + "64.ini");
        try {
            bq.a(hashMap, mIMFile);
            bq.a(hashMap2, mIMFile2);
        }
        catch (Exception exception) {
            ay.d((Object)"Exception while trying to setup dev service inis!", (Throwable)exception, this);
        }
    }

    @Override
    public void createRedirectInisForInstall(MIMFile mIMFile) {
        MIMFile mIMFile2 = new MIMFile(mIMFile + "/services/" + this.type.i() + "/bin/" + this.type.i() + "32.ini");
        MIMFile mIMFile3 = new MIMFile(mIMFile + "/services/" + this.type.i() + "/bin/" + this.type.i() + "64.ini");
        String string = Path.getServiceIniPath();
        InstallerBackend.a(string);
        HashMap hashMap = Maps.newHashMap();
        HashMap hashMap2 = Maps.newHashMap();
        hashMap.put("ini.file.location", string + "/" + this.type.i() + "32.ini");
        hashMap2.put("ini.file.location", string + "/" + this.type.i() + "64.ini");
        try {
            bq.a(hashMap, mIMFile2);
            bq.a(hashMap2, mIMFile3);
        }
        catch (Exception exception) {
            ay.d((Object)("Exception while trying to setup install service inis! Path 64: " + mIMFile3), (Throwable)exception, this);
        }
    }

    public void updateConfigs() {
        Comparable<java.nio.file.Path> comparable;
        File file;
        Object object;
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new MIMFile("services/basicServiceConfig.txt"));
        if (g.a()) {
            arrayList.add(new MIMFile("services/basicServiceConfigDev.txt"));
        }
        arrayList.add(this.getServiceConfigFile32());
        Map<String, String> map = bh.a(arrayList);
        this.updateHeapSizeSetting(map);
        arrayList.add(1, new MIMFile("services/basicServiceConfig64.txt"));
        if (g.a()) {
            arrayList.add(3, new MIMFile("services/basicServiceConfig64Dev.txt"));
        }
        arrayList.add(this.getServiceConfigFile64());
        Map<String, String> map2 = bh.a(arrayList);
        this.updateHeapSizeSetting(map2);
        String string = "SERVICE_TYPE";
        String string2 = "MIM";
        if (MIMContext.j()) {
            string2 = "MIMviewer";
        } else if (MIMContext.x()) {
            string2 = "MIMcloudExpress";
        }
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("vmarg.2", "-D" + string + "=" + string2);
        hashMap.put("vmarg.3", "-Dlog.configpath=services/" + this.type.j() + "/lib");
        hashMap.put("vmarg.6", "-DSERVICE_NAME=" + this.type.i());
        String string3 = "-XX:ErrorFile=" + PathUtils.getWindowsErrorFileEnvPath();
        hashMap.put("vmarg.7", string3);
        if (g.a()) {
            int n2 = 50;
            object = ca.a();
            file = new File(PathUtils.getRelativePathToProjectDir("mimjava/mim"));
            comparable = Paths.get(file.toURI()).normalize();
            try {
                Iterator<URL> iterator = object.iterator();
                while (iterator.hasNext()) {
                    URL uRL = iterator.next();
                    java.nio.file.Path path = Paths.get(uRL.toURI());
                    java.nio.file.Path path2 = comparable.relativize(path);
                    hashMap.put("classpath." + n2++, path2.toString());
                    hashMap.put("classpath." + n2++, path2.resolve("../lib/jars").normalize() + "/*.jar");
                    hashMap.put("classpath." + n2++, path2.resolve("../lib/runtimeJars").normalize() + "/*.jar");
                    hashMap.put("classpath." + n2++, path2.resolve("../res-jar").normalize().toString());
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                ay.d((Object)"Error setting up dev service ini.", (Throwable)uRISyntaxException, WindowsServiceControl.class);
            }
        }
        String string4 = PathUtils.getServiceLogPath() + "/" + this.type.j() + "/wrapper.log";
        hashMap.put("log", string4);
        map.putAll(hashMap);
        map2.putAll(hashMap);
        this.normalizeMultiArg("classpath", map);
        this.normalizeMultiArg("classpath", map2);
        this.normalizeMultiArg("vmarg", map);
        this.normalizeMultiArg("vmarg", map2);
        if (g.a()) {
            this.setupDevInis();
        }
        object = Path.getServiceIniPath();
        file = new MIMFile((String)object + "/" + this.type.i() + "32.ini");
        comparable = new MIMFile((String)object + "/" + this.type.i() + "64.ini");
        try {
            bq.a(map, (MIMFile)file);
            bq.a(map2, (MIMFile)comparable);
        }
        catch (Exception exception) {
            ay.d((Object)"Exception while trying to update service inis!", (Throwable)exception, this);
        }
    }

    private void updateHeapSizeSetting(Map<String, String> map) {
        String string = map.get(VM_HEAPSIZE_PREFERRED);
        try {
            int n2 = Integer.parseInt(string);
            if (this.type.d() > n2) {
                ay.b((Object)("Updating vm.heapsize.preferred for " + this.type.name() + " from " + n2 + " to " + this.type.d()), this);
                map.put(VM_HEAPSIZE_PREFERRED, String.valueOf(this.type.d()));
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)("Unable to parse configured vm.heapsize.preferred: " + string + " for " + this.type.name()), this);
        }
    }

    private void normalizeMultiArg(String string, Map<String, String> map) {
        final String string2 = string + ".";
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList(map.entrySet());
        for (Object object : arrayList2) {
            String string3 = (String)object.getKey();
            if (!string3.startsWith(string2)) continue;
            class MultiArgKey {
                int index;

                public MultiArgKey(String string) {
                    this.index = Integer.valueOf(string.substring(string2.length()));
                }
            }
            arrayList.add(Pair.get(new MultiArgKey(string3), object.getValue()));
            map.remove(string3);
        }
        Collections.sort(arrayList, new Comparator<Pair<MultiArgKey, String>>(){

            @Override
            public int compare(Pair<MultiArgKey, String> pair, Pair<MultiArgKey, String> pair2) {
                return (int)Math.signum(((MultiArgKey)pair.x).index - ((MultiArgKey)pair2.x).index);
            }
        });
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Object object;
            object = (Pair)arrayList.get(i2);
            map.put(string2 + (i2 + 1), (String)((Pair)object).y);
        }
    }

    public String readValueFromServiceConfig(String string) {
        if (cn.h(string)) {
            return null;
        }
        MIMFile mIMFile = this.getServiceConfigFile32();
        Map<String, String> map = bh.a(Lists.newArrayList((Object[])new MIMFile[]{mIMFile}));
        String string2 = map.get(string);
        return string2;
    }

    public void addPropertyToServiceConfig(String string, String string2) throws IOException {
        if (cn.h(string) || cn.h(string2)) {
            return;
        }
        MIMFile mIMFile = this.getServiceConfigFile32();
        Map<String, String> map = bh.a(Lists.newArrayList((Object[])new MIMFile[]{mIMFile}));
        map.put(string, string2);
        bq.a(map, mIMFile);
    }

    private MIMFile getServiceConfigFile32() {
        return this.getServiceConfigFile("serviceConfig.txt");
    }

    private MIMFile getServiceConfigFile64() {
        return this.getServiceConfigFile("serviceConfig64.txt");
    }

    private MIMFile getServiceConfigFile(String string) {
        File file;
        block4: {
            file = Path.joinFile("services", this.type.i(), "bin", string);
            File file2 = Path.joinFile(Path.getBasePath(), "service-configs", this.type.i(), string);
            if (file2.isFile()) {
                return new MIMFile(file2);
            }
            if (file.isFile()) {
                try {
                    MIMFile.a(file, file2);
                    return new MIMFile(file2);
                }
                catch (IOException iOException) {
                    ay.d((Object)("Failed to generate default service config for " + this.type.i()), (Throwable)iOException, this);
                    if (!file2.exists() || file2.delete()) break block4;
                    ay.d((Object)("Failed to remove uncompletedly copied service config for " + this.type.i()), this);
                }
            }
        }
        return new MIMFile(file);
    }

    @Override
    public void startService() throws ServiceException {
        this.updateConfigs();
        super.startService();
    }

    @Override
    public void uninstallService() throws ServiceException {
        this.updateConfigs();
        super.uninstallService();
    }

    @Override
    public void installService() throws ServiceException {
        this.updateConfigs();
        super.installService();
    }

    @Override
    protected String[] getServiceControlCommand(SimpleServiceControl.MimServiceCommand mimServiceCommand) {
        if (this.type.b() && mimServiceCommand == SimpleServiceControl.MimServiceCommand.d) {
            return new String[]{"sc", "delete", this.type.f()};
        }
        String[] stringArray = mimServiceCommand.a();
        if (mimServiceCommand.c()) {
            MIMFile mIMFile = new MIMFile(".");
            stringArray[0] = this.windowsWorkingDir.trim().length() == 0 ? mIMFile.getAbsolutePath() + "/" + stringArray[0] : this.windowsWorkingDir + stringArray[0];
            return stringArray;
        }
        return stringArray;
    }
}

