/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.transform;

import com.mimvista.dicom.transform.TagRule;
import com.mimvista.dicom.transform.TagRuleSet;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class DicomTransformer {
    private TagRuleSet ruleSet;
    private boolean useTemplate = false;
    private boolean templateInitialized = false;

    public DicomTransformer(TagRuleSet tagRuleSet) {
        if (tagRuleSet == null) {
            throw new IllegalArgumentException("RuleSet can NOT be null!");
        }
        this.ruleSet = tagRuleSet;
        this.useTemplate = this.hasTemplateRule(this.ruleSet);
    }

    private boolean hasTemplateRule(TagRuleSet tagRuleSet) {
        TagRule[] tagRuleArray = tagRuleSet.getRules();
        for (int i2 = 0; i2 < tagRuleArray.length; ++i2) {
            if (tagRuleArray[i2].getInputType() != 1) continue;
            return true;
        }
        return false;
    }

    public void init(DicomObject dicomObject) {
        if (!this.useTemplate) {
            return;
        }
        for (DicomElement dicomElement : dicomObject) {
            TagRule tagRule = this.ruleSet.findRule(dicomElement.tag());
            if (tagRule == null) continue;
            tagRule.init(dicomElement);
        }
        this.templateInitialized = true;
    }

    public boolean isInitialized() {
        return !this.useTemplate | this.templateInitialized;
    }

    public void transform(DicomObject dicomObject) {
        if (dicomObject == null) {
            throw new IllegalArgumentException("Source DICOM object can not be null.");
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("DicomTransformer is NOT initialized.");
        }
        for (DicomElement dicomElement : dicomObject) {
            TagRule tagRule = this.ruleSet.findRule(dicomElement.tag());
            if (tagRule != null) {
                tagRule.transform(dicomObject);
                continue;
            }
            System.out.println("Warning: rule for tag doesn't exist, data element is KEPT: 0x" + Integer.toHexString(dicomElement.tag()));
        }
        TagRule[] tagRuleArray = this.ruleSet.getRulesForNotExistTags();
        for (int i2 = 0; i2 < tagRuleArray.length; ++i2) {
            tagRuleArray[i2].transform(dicomObject);
        }
    }
}

