/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.archive.Archiver;
import com.mimvista.archive.Parser;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.SeriesFilesTransfer;
import com.mimvista.archive.search.RemoteSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.util.AbstractDicomModifierNotification;
import com.mimvista.dicom.util.AbstractSeriesScanner;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.mimcloud.MIMcloudSearchSource;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.progress.q;
import com.mimvista.util.progress.u;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.media.FileMetaInformation;

public abstract class AbstractDicomModifier<T extends AbstractSeriesScanner> {
    protected static Messages ARCHIVE = Messages.a("Archive");
    protected static Messages DICOM = Messages.a("Dicom");
    protected T seriesScanner;
    protected DcmSeries series;
    protected String tempDestination;
    protected SendToDestination destination;
    protected String localTempSeriesPath;
    protected List<AbstractDicomModifierNotification.FinalizeListener> finalizeListeners = new ArrayList<AbstractDicomModifierNotification.FinalizeListener>();

    protected void sendTo(SearchSource searchSource, SendToDestination sendToDestination, String string) {
        new SeriesFilesTransfer(searchSource, string).a(sendToDestination);
        new MIMFile(string).delete();
    }

    protected void cleanUp() {
        if (this.localTempSeriesPath == null) {
            return;
        }
        MIMFile mIMFile = new MIMFile(this.localTempSeriesPath);
        MIMFile mIMFile2 = mIMFile.g().g();
        mIMFile.delete();
        for (File file : mIMFile2.listFiles()) {
            if (file.list().length != 0) continue;
            file.delete();
        }
        if (mIMFile2.list().length == 0) {
            ((File)mIMFile2).delete();
        }
    }

    protected String retrieveSeries(Progress progress) throws RemoteException {
        String string;
        SearchSource searchSource = this.series.getSearchSource();
        if (searchSource == null) {
            return null;
        }
        if (searchSource instanceof RemoteSearchSource) {
            string = MIMFormat.a(this.getLoadText(), this.series.getPatientName(), searchSource.j());
            ProgressPanel progressPanel = new ProgressPanel();
            progressPanel.a(string);
            progressPanel.b_(this.getQueuedText());
            progressPanel.a(true);
            ProgressQueueNotification.a(progressPanel);
            progressPanel.b(0);
            progress = progressPanel;
        }
        string = searchSource.a(this.series, progress);
        if (progress.n() != Progress.Status.e && string == null) {
            throw new RemoteException(this.series.getPatientName());
        }
        if (searchSource instanceof RemoteSearchSource) {
            this.localTempSeriesPath = string;
        }
        return string;
    }

    public void processSeries(Progress progress) throws RemoteException {
        if (this.processToTempDestination(progress) != null) {
            this.moveToPatientList();
        }
    }

    public String processToTempDestination(Progress progress) throws RemoteException {
        String string;
        boolean bl2 = this.series.getSearchSource() instanceof MIMcloudSearchSource;
        q q2 = new q();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        if (bl2) {
            progress = q2;
            q2.c(actionEvent -> {
                Progress.Status status = q2.n();
                if (status.a()) {
                    countDownLatch.countDown();
                }
            });
        }
        if ((string = this.retrieveSeries(progress)) == null) {
            return null;
        }
        u u2 = null;
        u u3 = null;
        if (progress != null) {
            u2 = new u(progress, 0.5f);
            u3 = new u(progress, 0.5f);
        }
        if (bl2) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                ay.e(interruptedException);
            }
        }
        ((AbstractSeriesScanner)this.seriesScanner).scan(string, u2);
        if (((AbstractSeriesScanner)this.seriesScanner).isCancelled()) {
            return null;
        }
        this.process(u3);
        Archiver.cleanTempDirForEmbeddedSeries(string);
        if (progress != null && progress.n() == Progress.Status.e) {
            if (this.tempDestination != null) {
                new MIMFile(this.tempDestination).delete();
            }
            return null;
        }
        return this.tempDestination;
    }

    protected void moveToPatientList() {
        this.sendTo(this.series.getSearchSource(), this.destination, this.tempDestination);
    }

    protected void preprocessDataset(DicomObject dicomObject) {
    }

    public MIMFile process() {
        return this.process(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIMFile process(Progress progress) {
        ProgressPanel progressPanel;
        this.tempDestination = Path.getTempPath("MIM_ANONYMIZED");
        MIMFile mIMFile = new MIMFile(this.tempDestination);
        if (!mIMFile.isDirectory()) {
            mIMFile.mkdirs();
        }
        if (progress == null) {
            progressPanel = new ProgressPanel();
            ProgressQueueNotification.a(progressPanel);
            progressPanel.a(this.getProgressText());
            progressPanel.a();
            progress = progressPanel;
        }
        progress.a(((AbstractSeriesScanner)this.seriesScanner).getImages().size());
        progressPanel = null;
        FileOutputStream fileOutputStream = null;
        try {
            for (String string : ((AbstractSeriesScanner)this.seriesScanner).getImages()) {
                DicomObject dicomObject;
                if (progress.n() == Progress.Status.e) {
                    dicomObject = null;
                    return dicomObject;
                }
                dicomObject = DicomReader.readFileIntoDicomObject(new MIMFile(string));
                if (dicomObject == null) {
                    ay.c((Object)("Can't read file as DICOM image: " + string), this);
                    continue;
                }
                Parser.setDefaultSpecificCharacterSet(dicomObject);
                String string2 = dicomObject.getString(524312, "");
                this.preprocessDataset(dicomObject);
                this.processDataset(dicomObject, true);
                String string3 = ((AbstractSeriesScanner)this.seriesScanner).anonymizeUID(string2);
                dicomObject.putString(524312, VR.UI, string3);
                for (AbstractDicomModifierNotification.FinalizeListener finalizeListener : this.finalizeListeners) {
                    finalizeListener.finalize(dicomObject, this.series);
                }
                FileMetaInformation fileMetaInformation = new FileMetaInformation(dicomObject);
                fileMetaInformation.setMediaStorageSOPInstanceUID(string3);
                if (fileMetaInformation.getTransferSyntaxUID() == null) {
                    fileMetaInformation.setTransferSyntaxUID("1.2.840.10008.1.2.1");
                }
                MIMFile object2 = new MIMFile(this.tempDestination, string3 + ".dcm");
                fileOutputStream = new FileOutputStream(object2);
                progressPanel = new DicomOutputStream((OutputStream)fileOutputStream);
                progressPanel.writeDicomFile(dicomObject);
                progress.N_();
                try {
                    progressPanel.close();
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {
                    ay.d((Object)throwable, this);
                }
            }
            progress.b();
            MIMFile mIMFile2 = mIMFile;
            return mIMFile2;
        }
        catch (IOException iOException) {
            ay.d((Object)"Error", (Throwable)iOException, this);
            progress.k();
        }
        finally {
            try {
                if (progressPanel != null) {
                    progressPanel.close();
                } else if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                ay.d((Object)"Error", (Throwable)iOException, this);
            }
            this.cleanUp();
        }
        return null;
    }

    public void addFinalizeListeners(List<AbstractDicomModifierNotification.FinalizeListener> list) {
        this.finalizeListeners.addAll(list);
    }

    protected abstract String getQueuedText();

    protected abstract String getLoadText();

    protected abstract String getProgressText();

    protected abstract void processDataset(DicomObject var1, boolean var2);
}

