/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.collect.Lists;
import com.mimvista.archive.Archiver;
import com.mimvista.archive.gui.PackageDestination;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.SendToDestinationUIFactory;
import com.mimvista.archive.gui.ag;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.util.AbstractDicomModifier;
import com.mimvista.dicom.util.AbstractSeriesScanner;
import com.mimvista.dicom.util.DicomAnonymizeNotification;
import com.mimvista.dicom.util.DicomHipaaUserInput;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.gui.util.AbstractInputContainer;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.af;
import com.mimvista.gui.util.c;
import com.mimvista.gui.util.l;
import com.mimvista.gui.util.m;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.progress.o;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.dcm4che2.data.DicomObject;

public abstract class AbstractDicomModifierNotification<T extends AbstractSeriesScanner, W extends ModifySeriesData<T>>
extends InputNotification {
    protected static Messages DICOM = Messages.a("Dicom");
    private static Messages SWING = Messages.a("Swing");
    private static String FINISH = "FINISH";
    protected List<W> seriesData;
    protected l<SendToDestination> destInput;
    protected SendToDestination lastSelectedDest = null;
    protected String progressString = null;
    protected HashMap<String, af> fields = new HashMap();
    protected Hashtable<String, JLabel> oldValueLabels = new Hashtable();
    protected int position = 0;
    private m columnHeaders;
    private Object updateLock = new Object();
    private PrevAction prevAction = null;
    private JPanel finishPage = null;
    private List<FinalizeListener> finalizeListeners = new ArrayList<FinalizeListener>();

    public AbstractDicomModifierNotification(String string) {
        super(new Notification.a(), string, "modify_data");
    }

    public void setSeries(List<DcmSeries> list, List<TreeMap<Integer, String>> list2) {
        this.seriesData = Lists.newArrayListWithCapacity((int)list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            W w2 = this.createSeriesData();
            this.fillSeriesData(w2, list.get(i2), (Map<Integer, String>)list2.get(i2));
            this.seriesData.add(w2);
        }
    }

    protected void fillSeriesData(W w2, DcmSeries dcmSeries, Map<Integer, String> map) {
        ((ModifySeriesData)w2).series = dcmSeries;
        ((ModifySeriesData)w2).seriesScanner = this.createSeriesScanner(dcmSeries, map);
        ((ModifySeriesData)w2).tagsMap = map;
    }

    public void showGui() {
        this.buildGui();
        if (this.seriesData.size() > 1) {
            this.prevAction = new PrevAction();
            this.setExtraBottomButtonAction(this.prevAction);
        }
        this.setShowReset(true);
        this.setOkAction(new NextAction());
        this.addToGrandNotifier();
    }

    private void buildGui() {
        this.setPriority(500);
        ModifySeriesData modifySeriesData = (ModifySeriesData)this.seriesData.get(0);
        this.buildHeader(modifySeriesData);
        this.buildInputFields(modifySeriesData);
        this.destInput = this.buildDestinationInput();
    }

    private String getHeaderString(W w2) {
        String string = ((ModifySeriesData)w2).series.getModality();
        if (this.seriesData.size() > 1) {
            string = string + " (" + (this.position + 1) + "/" + this.seriesData.size() + ")";
        }
        return string;
    }

    private void buildHeader(W w2) {
        this.columnHeaders = this.addCollection(this.getHeaderString(w2), null, 0);
        this.columnHeaders.b(DICOM.getProperty("DCM_FIX_HIPAA_NEW"));
        String string = "                                    ";
        this.columnHeaders.b(string + DICOM.getProperty("DCM_FIX_HIPAA_OLD"));
    }

    @Override
    public void reset() {
        SendToDestination sendToDestination = this.destInput.b();
        super.reset();
        if (this.seriesData.size() > 1 && this.position != this.seriesData.size()) {
            this.destInput.b(sendToDestination);
        }
    }

    private l<SendToDestination> buildDestinationInput() {
        Object object;
        JComponent jComponent;
        l<SendToDestination> l2;
        List<SendToDestination> list = ag.a(ag.a(true, true, true, true));
        Object[] objectArray = list.toArray(new SendToDestination[list.size()]);
        String string = DICOM.getProperty("ENCAPSULATE_FRAME_DESTINATION");
        if (this.seriesData.size() == 1) {
            l2 = this.addComboBox(string, objectArray);
        } else {
            this.finishPage = new JPanel(new GridBagLayout());
            jComponent = new JPanel();
            this.finishPage.add((Component)jComponent, new GridBagConstraints());
            object = new JLabel(string);
            jComponent.add((Component)object);
            AbstractInputContainer.b b2 = new AbstractInputContainer.b(6, "", objectArray, Object.class);
            this.buildFields.add(b2);
            AbstractInputContainer.d d2 = this.createComboBoxField((JPanel)jComponent, b2, null);
            l2 = new l((AbstractInputContainer)this, d2);
        }
        jComponent = (JComboBox)l2.g();
        ((JComboBox)jComponent).setRenderer(new SendToDestinationUIFactory.SourceOrDestListCellRenderer());
        object = ag.a(((ModifySeriesData)this.seriesData.get((int)0)).series.getSearchSource());
        if (object == null || !list.contains(object)) {
            object = list.get(0);
        }
        if (object != null) {
            l2.a((SendToDestination)object);
            l2.b((SendToDestination)object);
        }
        return l2;
    }

    private String getNextButtonText() {
        return SWING.getProperty("MIMWIZ_NEXT_TEXT");
    }

    private Icon getNextButtonIcon() {
        return ImageManipulator.c(SWING.getProperty("MIMWIZ_NEXT_ICON"), 16, 16);
    }

    private String getFinishButtonText() {
        return SWING.getProperty("MIMWIZ_FINISH_TEXT");
    }

    private Icon getFinishButtonIcon() {
        return c.b("OK_BUTTON_ICON");
    }

    private void makeAllPatInputsTheSame() {
        HashMap<Integer, String> hashMap = DicomHipaaUserInput.getPatientLevelInformation();
        for (ModifySeriesData modifySeriesData : this.seriesData) {
            DicomHipaaUserInput dicomHipaaUserInput = ((DicomAnonymizeNotification.AnonymizeSeriesData)modifySeriesData).userInput;
            for (int n2 : hashMap.keySet()) {
                dicomHipaaUserInput.updateValue(n2, dicomHipaaUserInput.getDefaultValue(n2));
            }
        }
    }

    private void updateGui(W w2) {
        this.updateHeader(w2);
        this.updateInputFields(w2);
        this.updateBottom();
    }

    private void updateHeader(W w2) {
        this.columnHeaders.a(this.getHeaderString(w2));
    }

    protected void updateBottom() {
        this.setOkButtonText(this.position == this.seriesData.size() ? SWING.getProperty("MIMWIZ_FINISH_TEXT") : SWING.getProperty("MIMWIZ_NEXT_TEXT"));
        this.setOkButtonIcon(this.position == this.seriesData.size() ? c.b("OK_BUTTON_ICON") : ImageManipulator.c(SWING.getProperty("MIMWIZ_NEXT_ICON"), 16, 16));
    }

    public void setProgressString(String string) {
        this.progressString = string;
    }

    public void addFinalizeListener(FinalizeListener finalizeListener) {
        this.finalizeListeners.add(finalizeListener);
    }

    protected void finish() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SendToDestination sendToDestination = AbstractDicomModifierNotification.this.destInput.b();
                AbstractDicomModifierNotification.this.handleFindings();
                int n2 = AbstractDicomModifierNotification.this.seriesData.size() * 100;
                PackageDestination packageDestination = null;
                File file = null;
                ArrayList arrayList = Lists.newArrayList();
                if (sendToDestination instanceof PackageDestination) {
                    packageDestination = (PackageDestination)sendToDestination;
                    file = PackageDestination.getSaveLocationFromModifySeriesData(AbstractDicomModifierNotification.this.seriesData);
                    n2 *= 2;
                }
                ProgressPanel progressPanel = new ProgressPanel();
                progressPanel.a(n2);
                ProgressQueueNotification.a(progressPanel);
                progressPanel.a();
                int n3 = 0;
                MIMFile mIMFile = PathUtils.getTempPathUnique("compressedFilesTransfer");
                for (Object object : AbstractDicomModifierNotification.this.seriesData) {
                    try {
                        String string = MIMFormat.a(AbstractDicomModifierNotification.this.progressString, ++n3, AbstractDicomModifierNotification.this.seriesData.size());
                        ((AbstractSeriesScanner)((ModifySeriesData)object).seriesScanner).setProgressString(string);
                        AbstractDicomModifier abstractDicomModifier = AbstractDicomModifierNotification.this.createModifier(object, string);
                        abstractDicomModifier.addFinalizeListeners(AbstractDicomModifierNotification.this.finalizeListeners);
                        progressPanel.a(abstractDicomModifier.getProgressText());
                        if (packageDestination != null) {
                            File file2 = new File(abstractDicomModifier.processToTempDestination(new com.mimvista.util.progress.u((Progress)progressPanel, 100)));
                            for (Archiver.a a2 : Archiver.archiveSeries((File)mIMFile, (File)file2).f) {
                                for (File file3 : a2.e) {
                                    arrayList.add(file3.getAbsolutePath());
                                }
                            }
                            continue;
                        }
                        abstractDicomModifier.processSeries(new com.mimvista.util.progress.u((Progress)progressPanel, 100));
                    }
                    catch (IOException iOException) {
                        AbstractDicomModifierNotification.this.popFailureWarning(object);
                        ay.d((Object)"Error while modifying DICOM", (Throwable)iOException, AbstractDicomModifierNotification.this);
                    }
                }
                if (packageDestination != null) {
                    try {
                        Iterator iterator = packageDestination.zipFiles(file, arrayList, new com.mimvista.util.progress.u((Progress)progressPanel, n2 / 2), null);
                        ((Thread)((Object)iterator)).join();
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)"Error ZIPing files in DICOM modifier", throwable, AbstractDicomModifierNotification.this);
                    }
                    finally {
                        for (Object object : arrayList) {
                            new MIMFile((String)object).delete();
                        }
                    }
                }
                progressPanel.b();
            }
        }.start();
    }

    protected void handleFindings() {
        if (this.finalizeListeners.isEmpty()) {
            return;
        }
        FinalizeListener finalizeListener = this.finalizeListeners.get(0);
        ArrayList arrayList = new ArrayList();
        for (ModifySeriesData modifySeriesData : this.seriesData) {
            if (!finalizeListener.getFindingsMap().keySet().contains(modifySeriesData.series)) continue;
            try {
                this.getByteData(finalizeListener, modifySeriesData, arrayList);
            }
            catch (Exception exception) {
                ay.d((Object)exception, AbstractDicomModifierNotification.class);
            }
        }
        this.seriesData.removeAll(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getByteData(FinalizeListener finalizeListener, W w2, List<W> list) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        for (ModifySeriesData modifySeriesData : this.seriesData) {
            if (!finalizeListener.getFindingsMap().get(((ModifySeriesData)w2).series).contains(modifySeriesData.series)) continue;
            list.add(modifySeriesData);
            AbstractDicomModifier<T> abstractDicomModifier = this.createModifier(modifySeriesData, "");
            FileInputStream fileInputStream = null;
            try {
                int n2;
                String string = abstractDicomModifier.processToTempDestination(new o());
                MIMFile mIMFile = new MIMFile(string);
                File file = mIMFile.listFiles()[0];
                String string2 = file.getName();
                zipOutputStream.putNextEntry(new ZipEntry(string2));
                fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[1024];
                while ((n2 = fileInputStream.read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n2);
                }
                fileInputStream.close();
            }
            catch (Exception exception) {
                ay.d((Object)exception, AbstractDicomModifierNotification.class);
            }
            finally {
                zipOutputStream.closeEntry();
                if (fileInputStream == null) continue;
                fileInputStream.close();
            }
        }
        finalizeListener.putFindingMapping(((ModifySeriesData)w2).series, byteArrayOutputStream.toByteArray());
        zipOutputStream.finish();
        zipOutputStream.close();
        byteArrayOutputStream.close();
    }

    protected abstract T createSeriesScanner(DcmSeries var1, Map<Integer, String> var2);

    protected abstract W createSeriesData();

    protected abstract AbstractDicomModifier<T> createModifier(W var1, String var2);

    protected abstract void popFailureWarning(W var1);

    protected abstract void buildInputFields(W var1);

    protected abstract void updateInputFields(W var1);

    protected abstract void storeInputFieldData(W var1);

    public static interface FinalizeListener {
        public void finalize(DicomObject var1, DcmSeries var2);

        public void putFindingMapping(DcmSeries var1, byte[] var2);

        public Map<DcmSeries, List<DcmSeries>> getFindingsMap();
    }

    private class PrevAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        PrevAction() {
            super(SWING.getProperty("MIMWIZ_PREV_TEXT"), ImageManipulator.c(SWING.getProperty("MIMWIZ_PREV_ICON"), 16, 16));
            this.setEnabled(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = AbstractDicomModifierNotification.this.updateLock;
            synchronized (object) {
                if (AbstractDicomModifierNotification.this.position == 0) {
                    return;
                }
                if (AbstractDicomModifierNotification.this.position != AbstractDicomModifierNotification.this.seriesData.size()) {
                    AbstractDicomModifierNotification.this.storeInputFieldData((ModifySeriesData)AbstractDicomModifierNotification.this.seriesData.get(AbstractDicomModifierNotification.this.position));
                    AbstractDicomModifierNotification.this.setOkButtonIcon(AbstractDicomModifierNotification.this.getNextButtonIcon());
                    AbstractDicomModifierNotification.this.setOkButtonText(AbstractDicomModifierNotification.this.getNextButtonText());
                } else {
                    AbstractDicomModifierNotification.this.getInputContentPanel().b();
                }
                --AbstractDicomModifierNotification.this.position;
                AbstractDicomModifierNotification.this.updateGui((ModifySeriesData)AbstractDicomModifierNotification.this.seriesData.get(AbstractDicomModifierNotification.this.position));
                if (AbstractDicomModifierNotification.this.position == 0) {
                    this.setEnabled(false);
                }
            }
        }
    }

    private class NextAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private NextAction() {
            super(1 == AbstractDicomModifierNotification.this.seriesData.size() ? AbstractDicomModifierNotification.this.getFinishButtonText() : AbstractDicomModifierNotification.this.getNextButtonText(), 1 == AbstractDicomModifierNotification.this.seriesData.size() ? AbstractDicomModifierNotification.this.getFinishButtonIcon() : AbstractDicomModifierNotification.this.getNextButtonIcon());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = AbstractDicomModifierNotification.this.updateLock;
            synchronized (object) {
                if (AbstractDicomModifierNotification.this.position == AbstractDicomModifierNotification.this.seriesData.size() || AbstractDicomModifierNotification.this.seriesData.size() == 1) {
                    if (AbstractDicomModifierNotification.this.seriesData.size() == 1) {
                        AbstractDicomModifierNotification.this.storeInputFieldData((ModifySeriesData)AbstractDicomModifierNotification.this.seriesData.get(AbstractDicomModifierNotification.this.position));
                    }
                    if (AbstractDicomModifierNotification.this.seriesData.get(0) instanceof DicomAnonymizeNotification.AnonymizeSeriesData) {
                        DicomAnonymizeNotification.AnonymizeSeriesData anonymizeSeriesData = (DicomAnonymizeNotification.AnonymizeSeriesData)AbstractDicomModifierNotification.this.seriesData.get(AbstractDicomModifierNotification.this.seriesData.size() - 1);
                        if (anonymizeSeriesData.userInput.isMergeMultiplePatient()) {
                            AbstractDicomModifierNotification.this.makeAllPatInputsTheSame();
                        }
                    }
                    AbstractDicomModifierNotification.this.finish();
                    u.b().d(AbstractDicomModifierNotification.this);
                } else {
                    AbstractDicomModifierNotification.this.storeInputFieldData((ModifySeriesData)AbstractDicomModifierNotification.this.seriesData.get(AbstractDicomModifierNotification.this.position));
                    ++AbstractDicomModifierNotification.this.position;
                    if (AbstractDicomModifierNotification.this.position == AbstractDicomModifierNotification.this.seriesData.size()) {
                        AbstractDicomModifierNotification.this.setOkButtonIcon(AbstractDicomModifierNotification.this.getFinishButtonIcon());
                        AbstractDicomModifierNotification.this.setOkButtonText(AbstractDicomModifierNotification.this.getFinishButtonText());
                        AbstractDicomModifierNotification.this.getInputContentPanel().a(AbstractDicomModifierNotification.this.finishPage, FINISH);
                        AbstractDicomModifierNotification.this.getInputContentPanel().a(FINISH);
                    } else {
                        AbstractDicomModifierNotification.this.updateGui((ModifySeriesData)AbstractDicomModifierNotification.this.seriesData.get(AbstractDicomModifierNotification.this.position));
                        if (AbstractDicomModifierNotification.this.position > 0 && AbstractDicomModifierNotification.this.prevAction != null) {
                            AbstractDicomModifierNotification.this.prevAction.setEnabled(true);
                        }
                    }
                }
            }
        }
    }

    public static class ModifySeriesData<T extends AbstractSeriesScanner> {
        public DcmSeries series;
        public T seriesScanner;
        public Map<Integer, String> tagsMap;
    }
}

