/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.file.MIMFile;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.progress.g;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.dcm4che2.data.DicomObject;

public abstract class AbstractSeriesScanner {
    protected static Messages props = Messages.a("Dicom");
    protected String progressString = null;
    protected ArrayList<String> images = new ArrayList();
    protected DcmSeries series;
    protected Map<Integer, Object> oldInfo = new HashMap<Integer, Object>();
    protected Map<Integer, Object> newInfo = new HashMap<Integer, Object>();
    protected DicomObject ds;
    protected boolean cancelled = false;
    protected String localPath;

    public void setProgressString(String string) {
        this.progressString = string;
    }

    public ArrayList<String> getImages() {
        return this.images;
    }

    public DcmSeries getSeries() {
        return this.series;
    }

    public Map<Integer, Object> getOldInfo() {
        return this.oldInfo;
    }

    public Map<Integer, Object> getNewInfo() {
        return this.newInfo;
    }

    public Object getNewValue(int n2) {
        return this.newInfo.get(n2);
    }

    public String getLocalPath() {
        return this.localPath;
    }

    protected void processSequence(int n2, int n3) {
        this.processSequence(n2, new int[]{n3});
    }

    protected void processSequence(int n2, int[] nArray) {
        this.record(n2, null, null);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.record(nArray[i2], null, null);
        }
    }

    protected void record(int n2, Object object, Object object2) {
        this.oldInfo.put(n2, object);
        this.newInfo.put(n2, object2);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    protected void doExtraSeriesProcessing(DicomObject dicomObject) {
    }

    public void scan(String string) {
        this.scan(string, null);
    }

    public void scan(String string, Progress progress) {
        Object object;
        Object object2;
        if (progress == null) {
            object2 = new ProgressPanel();
            object2.a(MIMFormat.a(this.getName(), this.progressString));
            ProgressQueueNotification.a((g)object2);
            object2.a();
            object = object2;
        } else {
            object = progress;
        }
        object2 = new MIMFile(string).b();
        this.localPath = string;
        boolean bl2 = false;
        if (((Vector)object2).size() == 0) {
            return;
        }
        Collections.sort(object2, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return file.getName().compareTo(file2.getName());
            }
        });
        object.a(((Vector)object2).size());
        Iterator iterator = ((Vector)object2).iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (object.n() == Progress.Status.e) {
                this.cancelled = true;
                return;
            }
            String string2 = file.getAbsolutePath();
            this.images.add(string2);
            if (!bl2) {
                this.ds = DicomReader.readFileIntoDicomObject((File)new MIMFile(string2), 2145386512);
                if (this.ds == null) continue;
                this.doExtraSeriesProcessing(this.ds);
                this.scan();
                bl2 = true;
                this.ds = null;
            }
            object.N_();
        }
        if (progress == null) {
            object.b();
        }
    }

    protected abstract String getName();

    protected abstract void scan();

    protected abstract String anonymizeUID(String var1);
}

