/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.collect.Lists;
import com.mimvista.dicom.util.DicomTagParseException;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.util.ay;
import com.mimvista.util.cg;
import com.mimvista.util.cn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BasicDicomTag
implements cg.a {
    private final int tagValue;
    private final String tagName;
    private final String englishDisplayName;

    public BasicDicomTag(int n2, String string) {
        this.tagValue = n2;
        this.tagName = string;
        this.englishDisplayName = this.buildEnglishDisplayName();
    }

    public BasicDicomTag(int n2) {
        this(n2, TagUtils.getTagName(n2));
    }

    public String getEnglishDisplayName() {
        return this.englishDisplayName;
    }

    public int getTagValue() {
        return this.tagValue;
    }

    public String getTagName() {
        return this.tagName;
    }

    private String buildEnglishDisplayName() {
        char[] cArray = this.tagName.toCharArray();
        if (cArray.length < 2) {
            return this.tagName;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cArray[0]);
        for (int i2 = 1; i2 < cArray.length; ++i2) {
            int n2 = i2 + 1;
            if (n2 < cArray.length) {
                if (Character.isUpperCase(cArray[i2]) && Character.isLowerCase(cArray[n2])) {
                    if (stringBuilder.charAt(stringBuilder.length() - 1) != ' ') {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(cArray[i2]);
                    continue;
                }
                if (Character.isLowerCase(cArray[i2]) && Character.isUpperCase(cArray[n2])) {
                    stringBuilder.append(cArray[i2]);
                    stringBuilder.append(' ');
                    continue;
                }
                stringBuilder.append(cArray[i2]);
                continue;
            }
            stringBuilder.append(cArray[i2]);
        }
        return stringBuilder.toString();
    }

    @Override
    public List<String> getRepresentativeTextForRelevanceSearch() {
        return Lists.newArrayList((Object[])new String[]{this.getTagName()});
    }

    @Override
    public List<String> getEnglishRepresentativeTextForRelevanceSearch() {
        return this.getRepresentativeTextForRelevanceSearch();
    }

    public String toString() {
        return this.getTagName();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.tagValue;
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BasicDicomTag basicDicomTag = (BasicDicomTag)object;
        return this.tagValue == basicDicomTag.tagValue;
    }

    public static BasicDicomTag getTagByValue(int n2) {
        if (n2 > -1) {
            return new BasicDicomTag(n2);
        }
        return null;
    }

    public static BasicDicomTag getTagByValue(String string) {
        try {
            return BasicDicomTag.getTagByValue(TagUtils.parseTagValue(string));
        }
        catch (DicomTagParseException dicomTagParseException) {
            ay.d((Object)("Unable to parse tag: " + string), (Throwable)dicomTagParseException, BasicDicomTag.class);
            return null;
        }
    }

    public static int[] searchForTagByName(String string, int n2) throws DicomTagParseException {
        List<BasicDicomTag> list;
        if (cn.g(string)) {
            throw new DicomTagParseException();
        }
        string = cn.f(string).toLowerCase();
        BasicDicomTag basicDicomTag = null;
        try {
            basicDicomTag = new BasicDicomTag(TagUtils.forTagName(string));
            if (n2 == 1) {
                return new int[]{basicDicomTag.getTagValue()};
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ArrayList arrayList = Lists.newArrayList();
        List<BasicDicomTag> list2 = BasicDicomTag.searchForTags(TagUtils.getDcmTags(), string, n2);
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        if ((list = BasicDicomTag.searchForTags(TagUtils.getMIMTags(), string, n2 - arrayList.size())) != null) {
            arrayList.addAll(list);
        }
        if (arrayList.contains(basicDicomTag)) {
            arrayList.remove(basicDicomTag);
            arrayList.add(0, basicDicomTag);
        }
        if (arrayList.isEmpty()) {
            throw new DicomTagParseException();
        }
        int[] nArray = new int[arrayList.size()];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            nArray[i2] = ((BasicDicomTag)arrayList.get(i2)).getTagValue();
        }
        return nArray;
    }

    private static List<BasicDicomTag> searchForTags(List<Integer> list, String string, int n2) {
        Collections.sort(list);
        ArrayList<BasicDicomTag> arrayList = new ArrayList<BasicDicomTag>();
        Object object = list.iterator();
        while (object.hasNext()) {
            int n3 = object.next();
            arrayList.add(new BasicDicomTag(n3));
        }
        object = cg.a(arrayList, string);
        ArrayList<BasicDicomTag> arrayList2 = new ArrayList<BasicDicomTag>();
        for (int i2 = 0; i2 < object.size() && i2 < n2; ++i2) {
            arrayList2.add((BasicDicomTag)object.get(i2));
        }
        return arrayList2;
    }
}

