/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.archive.NameFormatter;
import com.mimvista.dicom.BasicDcmStudyGrouping;
import com.mimvista.dicom.DcmStudy;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.preferences.al;
import com.mimvista.preferencesNew.ArchivePrefs;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.util.Comparator;
import javax.swing.SortOrder;

public final class DcmStudyComparators {
    private DcmStudyComparators() {
    }

    static class DcmStudyComparatorNameDateId
    extends DcmStudyComparatorDateId
    implements Comparator<DcmStudy> {
        DcmStudyComparatorNameDateId() {
        }

        @Override
        public int compare(DcmStudy dcmStudy, DcmStudy dcmStudy2) {
            if (dcmStudy == null && dcmStudy2 == null) {
                return 0;
            }
            if (dcmStudy == null) {
                return -1;
            }
            if (dcmStudy2 == null) {
                return 1;
            }
            String string = dcmStudy.getStringProperty(0x100010);
            string = SeriesIdentifier.sanitizeName(NameFormatter.d(string));
            String string2 = dcmStudy2.getStringProperty(0x100010);
            string2 = SeriesIdentifier.sanitizeName(NameFormatter.d(string2));
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            int n2 = string.compareTo(string2);
            if (n2 == 0) {
                n2 = super.compare(dcmStudy, dcmStudy2);
            }
            return n2;
        }
    }

    private static class DcmStudyComparatorDateId
    extends DcmStudyComparatorId
    implements Comparator<DcmStudy> {
        private DcmStudyComparatorDateId() {
        }

        @Override
        public int compare(DcmStudy dcmStudy, DcmStudy dcmStudy2) {
            if (dcmStudy == null && dcmStudy2 == null) {
                return 0;
            }
            if (dcmStudy == null) {
                return -1;
            }
            if (dcmStudy2 == null) {
                return 1;
            }
            String string = BasicDcmStudyGrouping.getCleanStudyDate(dcmStudy);
            String string2 = BasicDcmStudyGrouping.getCleanStudyDate(dcmStudy2);
            if (!(string != null && string.length() != 0 || string2 != null && string2.length() != 0)) {
                return 0;
            }
            if (string == null || string.length() == 0) {
                return -1;
            }
            if (string2 == null || string2.length() == 0) {
                return 1;
            }
            int n2 = string2.compareTo(string);
            if (n2 == 0) {
                n2 = super.compare(dcmStudy, dcmStudy2);
            }
            return n2;
        }
    }

    static class DcmStudyComparatorDateNameId
    extends DcmStudyComparatorNameId
    implements Comparator<DcmStudy> {
        DcmStudyComparatorDateNameId() {
        }

        @Override
        public int compare(DcmStudy dcmStudy, DcmStudy dcmStudy2) {
            if (dcmStudy == null && dcmStudy2 == null) {
                return 0;
            }
            if (dcmStudy == null) {
                return -1;
            }
            if (dcmStudy2 == null) {
                return 1;
            }
            String string = BasicDcmStudyGrouping.getCleanStudyDate(dcmStudy);
            String string2 = BasicDcmStudyGrouping.getCleanStudyDate(dcmStudy2);
            if (!(string != null && string.length() != 0 || string2 != null && string2.length() != 0)) {
                return 0;
            }
            if (string == null || string.length() == 0) {
                return -1;
            }
            if (string2 == null || string2.length() == 0) {
                return 1;
            }
            int n2 = string.trim().compareTo(string2.trim());
            if (n2 == 0) {
                n2 = super.compare(dcmStudy, dcmStudy2);
            }
            return n2;
        }
    }

    static class DcmStudyComparatorNameId
    extends DcmStudyComparatorId
    implements Comparator<DcmStudy> {
        DcmStudyComparatorNameId() {
        }

        @Override
        public int compare(DcmStudy dcmStudy, DcmStudy dcmStudy2) {
            if (dcmStudy == null && dcmStudy2 == null) {
                return 0;
            }
            if (dcmStudy == null) {
                return -1;
            }
            if (dcmStudy2 == null) {
                return 1;
            }
            String string = dcmStudy.getStringProperty(0x100010);
            string = SeriesIdentifier.sanitizeName(NameFormatter.d(string));
            String string2 = dcmStudy2.getStringProperty(0x100010);
            string2 = SeriesIdentifier.sanitizeName(NameFormatter.d(string2));
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            int n2 = string.compareTo(string2);
            if (n2 == 0) {
                n2 = super.compare(dcmStudy, dcmStudy2);
            }
            return n2;
        }
    }

    static class DcmStudyComparatorId
    implements Comparator<DcmStudy> {
        DcmStudyComparatorId() {
        }

        @Override
        public int compare(DcmStudy dcmStudy, DcmStudy dcmStudy2) {
            if (dcmStudy == null && dcmStudy2 == null) {
                return 0;
            }
            if (dcmStudy == null) {
                return -1;
            }
            if (dcmStudy2 == null) {
                return 1;
            }
            String string = dcmStudy.getStringProperty(0x100020);
            String string2 = dcmStudy2.getStringProperty(0x100020);
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.trim().compareTo(string2.trim());
        }
    }

    public static enum StudySortEnum implements al<StudySortEnum>
    {
        ID(DcmStudyComparatorId.class, SortOrder.ASCENDING),
        NAME_ID(DcmStudyComparatorNameId.class, SortOrder.ASCENDING),
        DATE_NAME_ID(DcmStudyComparatorDateNameId.class, SortOrder.DESCENDING),
        NAME_DATE_ID(DcmStudyComparatorNameDateId.class, SortOrder.ASCENDING);

        static String propsFile;
        static String propsPrefix;
        Class<? extends Comparator<DcmStudy>> c;
        SortOrder sortOrder;

        public static StudySortEnum getMIMDefaultSort() {
            return NAME_ID;
        }

        public static StudySortEnum getPreferenceConfiguredSort() {
            return ArchivePrefs.defaultStudySort.getValue();
        }

        @Override
        public String getStringForPrefs() {
            return this.toConfigString();
        }

        @Override
        public String getExternalizedString() {
            return this.toDisplayString();
        }

        public static StudySortEnum fromConfigString(String string) {
            for (StudySortEnum studySortEnum : StudySortEnum.values()) {
                if (!studySortEnum.toConfigString().equals(string)) continue;
                return studySortEnum;
            }
            ay.d((Object)("Hmm, didn't find this study sort enum: " + string), StudySortEnum.class);
            return StudySortEnum.getMIMDefaultSort();
        }

        private StudySortEnum(Class<? extends Comparator<DcmStudy>> clazz, SortOrder sortOrder) {
            this.c = clazz;
            this.sortOrder = sortOrder;
        }

        public Comparator<DcmStudy> getComparator() {
            try {
                return this.c.newInstance();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        public String toConfigString() {
            return this.name();
        }

        public String toDisplayString() {
            Messages messages = Messages.a(propsFile);
            return messages.getProperty(propsPrefix + this.toConfigString());
        }

        public SortOrder getSortOrder() {
            return this.sortOrder;
        }

        static {
            propsFile = "PropertyCollectionFactory";
            propsPrefix = "PROPERTYCOLL_FACT_STUDY_SORT_ENUM_";
        }
    }
}

