/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.SwingPatientList;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.util.AbstractDicomModifierNotification;
import com.mimvista.dicom.util.DicomHipaaAnonymizer;
import com.mimvista.dicom.util.DicomHipaaSeriesScanner;
import com.mimvista.dicom.util.DicomHipaaUserInput;
import com.mimvista.gui.util.af;
import com.mimvista.gui.util.l;
import com.mimvista.gui.util.m;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class DicomAnonymizeNotification
extends AbstractDicomModifierNotification<DicomHipaaSeriesScanner, AnonymizeSeriesData> {
    private static Messages ARCHIVE = Messages.a("Archive");
    protected l<Boolean> removeCheckBox;
    private boolean mergeMultiplePatient = false;
    protected Map<Integer, String> tagsFromFirstPatient = DicomHipaaUserInput.getPatientLevelInformation();

    public DicomAnonymizeNotification(List<DcmSeries> list, List<TreeMap<Integer, String>> list2, boolean bl2) {
        super(ARCHIVE.getProperty("ANONYMIZE_TITLE"));
        this.mergeMultiplePatient = bl2;
        this.setSeries(list, list2);
    }

    @Override
    protected AnonymizeSeriesData createSeriesData() {
        return new AnonymizeSeriesData();
    }

    @Override
    protected void fillSeriesData(AnonymizeSeriesData anonymizeSeriesData, DcmSeries dcmSeries, Map<Integer, String> map) {
        super.fillSeriesData(anonymizeSeriesData, dcmSeries, map);
        anonymizeSeriesData.userInput = new DicomHipaaUserInput(map, this.tagsFromFirstPatient);
        anonymizeSeriesData.userInput.setMergeMultiplePatient(this.mergeMultiplePatient);
    }

    @Override
    protected DicomHipaaSeriesScanner createSeriesScanner(DcmSeries dcmSeries, Map<Integer, String> map) {
        return new DicomHipaaSeriesScanner(dcmSeries);
    }

    @Override
    protected void buildInputFields(AnonymizeSeriesData anonymizeSeriesData) {
        for (String string : anonymizeSeriesData.userInput.getInputNames()) {
            String string2 = anonymizeSeriesData.userInput.getOldValue(string);
            String string3 = anonymizeSeriesData.userInput.getDefaultValue(string);
            boolean bl2 = true;
            if (!bl2 && string2 == null) continue;
            m m2 = this.addCollection(string, null, 0);
            af af2 = m2.m();
            this.fields.put(string, af2.d(string3));
            ((JTextField)af2.g()).setColumns(15);
            if (string2 == null) continue;
            this.oldValueLabels.put(string, m2.b("  " + string2));
        }
        this.removeCheckBox = this.addCheckBox(DICOM.getProperty("DCM_HIPAA_REMOVE_TAGS"));
        this.removeCheckBox.a((Boolean)anonymizeSeriesData.removePrivateTags);
    }

    @Override
    protected void updateInputFields(AnonymizeSeriesData anonymizeSeriesData) {
        for (String string : anonymizeSeriesData.userInput.getInputNames()) {
            af af2;
            String string2 = anonymizeSeriesData.userInput.getUserInputValue(anonymizeSeriesData.userInput.getTag(string));
            String string3 = anonymizeSeriesData.userInput.getDefaultValue(string);
            if (string2 == null || this.isPatientInfo(anonymizeSeriesData, string)) {
                string2 = string3;
            }
            if ((af2 = (af)this.fields.get(string)) != null) {
                af2.b(string2);
                af2.d(string3);
            }
            String string4 = anonymizeSeriesData.userInput.getOldValue(string);
            JLabel jLabel = (JLabel)this.oldValueLabels.get(string);
            if (jLabel == null) continue;
            jLabel.setText(string4);
        }
        if (this.removeCheckBox != null) {
            this.removeCheckBox.b((Boolean)anonymizeSeriesData.removePrivateTags);
            this.removeCheckBox.a((Boolean)true);
        }
    }

    private boolean isPatientInfo(AnonymizeSeriesData anonymizeSeriesData, String string) {
        return anonymizeSeriesData.userInput.isPatInfo(anonymizeSeriesData.userInput.getTag(string));
    }

    @Override
    protected void storeInputFieldData(AnonymizeSeriesData anonymizeSeriesData) {
        for (String string : this.fields.keySet()) {
            String string2 = (String)((af)this.fields.get(string)).b();
            anonymizeSeriesData.userInput.updateValue(string, string2);
        }
        anonymizeSeriesData.removePrivateTags = this.removePrivate();
    }

    protected boolean removePrivate() {
        if (this.removeCheckBox != null) {
            return this.removeCheckBox.b();
        }
        return false;
    }

    protected DicomHipaaAnonymizer createModifier(AnonymizeSeriesData anonymizeSeriesData, String string) {
        DicomHipaaAnonymizer dicomHipaaAnonymizer = new DicomHipaaAnonymizer(anonymizeSeriesData.userInput, (DicomHipaaSeriesScanner)anonymizeSeriesData.seriesScanner, (SendToDestination)this.destInput.b(), anonymizeSeriesData.removePrivateTags);
        dicomHipaaAnonymizer.setProgressString(string);
        return dicomHipaaAnonymizer;
    }

    @Override
    protected void popFailureWarning(AnonymizeSeriesData anonymizeSeriesData) {
        JOptionPane.showMessageDialog(SwingPatientList.c(), MIMFormat.a(ARCHIVE.getProperty("RETRIEVE_FAIL"), ((DicomHipaaSeriesScanner)anonymizeSeriesData.seriesScanner).getSeries().getPatientName()), DICOM.getProperty("DCM_TEST_FAIL"), 2);
    }

    public static class AnonymizeSeriesData
    extends AbstractDicomModifierNotification.ModifySeriesData<DicomHipaaSeriesScanner> {
        public DicomHipaaUserInput userInput;
        public boolean removePrivateTags = true;
    }
}

